/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.setting.configuration.notification.Notification;
import com.pmease.quickbuild.setting.configuration.promotion.Promotion;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.component.configuration.InheritIndicator;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.component.viewer.PropertyViewer;
import com.pmease.quickbuild.web.component.viewer.ViewContext;
import com.pmease.quickbuild.web.page.setting.NotificationEdit;
import com.pmease.quickbuild.web.page.setting.NotificationOverridesPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang.Validate;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class NotificationsPanel
extends Panel {
    public static final String SETTING_NAME = "notifications";
    private SelectionColumn<Notification> selectionColumn;

    public NotificationsPanel(final String id) {
        super(id);
        WebMarkupContainer operations = new WebMarkupContainer("operations"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.isEditSettingAllowed());
            }
        };
        this.add(new Component[]{operations});
        operations.add(new Component[]{new Link<Void>("addNew"){

            public void onClick() {
                NotificationsPanel.this.replaceWith((Component)((Object)new NotificationEdit(id, new Notification(), null)));
            }
        }});
        Component[] componentArray = new Component[1];
        Link<Void> link = new Link<Void>("deleteSelected"){

            public void onClick() {
                Configuration configuration = Context.getConfiguration();
                for (Notification notification : NotificationsPanel.this.selectionColumn.getSelections()) {
                    boolean found = false;
                    Iterator<Notification> it = configuration.getNotifications().iterator();
                    while (it.hasNext()) {
                        if (!it.next().getKey().equals(notification.getKey())) continue;
                        it.remove();
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.getSession().warn((Serializable)((Object)("Can not delete inherited notification: " + notification.getKey())));
                }
                ConfigurationManager.instance.saveNotifications(configuration);
                for (Notification notification : NotificationsPanel.this.selectionColumn.getSelections()) {
                    AuditManager.instance.audit(configuration, "Notification " + notification.getNotifier() + " was deleted.");
                }
                NotificationsPanel.this.selectionColumn.getSelections().clear();
            }
        };
        componentArray[0] = link;
        operations.add(componentArray);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete selected notifications?")});
        ArrayList<Object> columns = new ArrayList<Object>();
        if (SecurityHelper.isEditSettingAllowed()) {
            this.selectionColumn = new SelectionColumn();
            columns.add(this.selectionColumn);
        }
        columns.add(new AbstractColumn<Notification>((IModel)new Model((Serializable)((Object)"Receivers"))){

            public void populateItem(Item<ICellPopulator<Notification>> cellItem, String componentId, IModel<Notification> rowModel) {
                Fragment fragment = new Fragment(componentId, "nameFrag", (MarkupContainer)NotificationsPanel.this);
                cellItem.add(new Component[]{fragment});
                Configuration configuration = Context.getConfiguration();
                final Notification notification = (Notification)rowModel.getObject();
                Configuration declarer = configuration.findNotificationDeclarer(notification.getKey());
                Validate.notNull((Object)declarer);
                Configuration override = configuration.getParent();
                if (override != null) {
                    override = override.findNotificationDeclarer(notification.getKey());
                }
                final boolean inherited = !declarer.getId().equals(configuration.getId());
                fragment.add(new Component[]{new Label("receivers", StringUtils.join(notification.getReceivers()))});
                Component[] componentArray = new Component[1];
                Link<Void> link = new Link<Void>("edit"){

                    public void onClick() {
                        NotificationsPanel.this.replaceWith((Component)((Object)new NotificationEdit(id, notification, notification.getKey())));
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(SecurityHelper.isEditSettingAllowed());
                    }
                };
                componentArray[0] = link;
                fragment.add(componentArray);
                link.add(new Component[]{new WebMarkupContainer("icon"){

                    protected void onComponentTag(ComponentTag tag) {
                        super.onComponentTag(tag);
                        tag.put("src", (CharSequence)(inherited ? "/images/overwrite.png" : "/images/edit.png"));
                        tag.put("title", (CharSequence)(inherited ? "Overwrite this notification" : "Edit this notification"));
                    }
                }});
                fragment.add(new Component[]{new Link<Void>("find"){

                    public void onClick() {
                        NotificationsPanel.this.replaceWith((Component)((Object)new NotificationOverridesPanel(id, notification.getKey())));
                    }
                }.setVisible(!inherited)});
                fragment.add(new Component[]{new InheritIndicator("inherit", declarer, override, NotificationsPanel.SETTING_NAME)});
            }
        });
        columns.add(new AbstractColumn<Notification>((IModel)new Model((Serializable)((Object)"Notifier"))){

            public void populateItem(Item<ICellPopulator<Notification>> cellItem, String componentId, IModel<Notification> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, ((Notification)rowModel.getObject()).getNotifier())});
            }
        });
        columns.add(new AbstractColumn<Notification>((IModel)new Model((Serializable)((Object)"Condition"))){

            public void populateItem(Item<ICellPopulator<Notification>> cellItem, String componentId, IModel<Notification> rowModel) {
                Notification notification = (Notification)rowModel.getObject();
                ViewContext.ViewableProperty property = new ViewContext(notification).getProperty("condition");
                cellItem.add(new Component[]{new PropertyViewer(componentId, Promotion.class, property)});
            }
        });
        this.add(new Component[]{new DefaultDataTable(SETTING_NAME, columns, (ISortableDataProvider)new DataProvider<Notification>(){

            public Iterator<? extends Notification> iterator(int first, int count) {
                return Context.getConfiguration().findNotifications().iterator();
            }

            public int size() {
                return Context.getConfiguration().findNotifications().size();
            }
        }, Integer.MAX_VALUE)});
    }
}

