/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.setting.configuration.notification.Notification;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class NotificationEdit
extends Panel {
    public NotificationEdit(String id, final Notification notification, final Notification.Key key) {
        super(id);
        final EditContext editContext = new EditContext(notification);
        Form<Void> form = new Form<Void>("form"){

            protected void onSubmit() {
                String error = null;
                editContext.validate(false);
                if (!editContext.hasError()) {
                    editContext.update(notification);
                    Configuration configuration = Context.getConfiguration();
                    if (key == null) {
                        if (configuration.getNotification(notification.getKey()) != null) {
                            error = "This combination of receivers and notifier is already specified by another notification in this configuration.";
                        } else {
                            configuration.getNotifications().add(notification);
                            ConfigurationManager.instance.saveNotifications(configuration);
                            AuditManager.instance.audit(configuration, "Notification was added.");
                        }
                    } else {
                        Notification existing = configuration.getNotification(key);
                        if (existing != null) {
                            if (!notification.getKey().equals(key) && configuration.getNotification(notification.getKey()) != null) {
                                error = "This combination of receivers and notifier is already specified by another notification in this configuration.";
                            } else {
                                String previousAuditContent = VersionedDocument.fromBean(existing).toXML();
                                existing.setReceivers(notification.getReceivers());
                                existing.setCondition(notification.getCondition());
                                existing.setNotifier(notification.getNotifier());
                                ConfigurationManager.instance.saveNotifications(configuration);
                                AuditManager.instance.audit(configuration, "Notification was modified.", VersionedDocument.fromBean(existing).toXML(), previousAuditContent);
                            }
                        } else {
                            configuration.getNotifications().add(notification);
                            ConfigurationManager.instance.saveNotifications(configuration);
                            AuditManager.instance.audit(configuration, "Notification was overwrited from parent.");
                        }
                    }
                } else {
                    error = "Fix errors below.";
                }
                if (error == null) {
                    PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "notifications");
                    this.setResponsePage(ConfigurationSettingPage.class, params);
                    this.getSession().info((Serializable)((Object)"Setting saved."));
                } else {
                    this.getSession().error((Serializable)((Object)error));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        form.add(new Component[]{new Link<Void>("cancel"){

            public void onClick() {
                PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "notifications");
                this.setResponsePage(ConfigurationSettingPage.class, params);
            }
        }});
        this.add(new Component[]{form});
    }
}

