/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.General;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.setting.configuration.version.VersionManager;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.viewer.ViewContext;
import com.pmease.quickbuild.web.page.PageBack;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class GeneralSettingEdit
extends Panel {
    private boolean saveRecursively;

    public GeneralSettingEdit(String id, final Configuration configurationToEdit, final Long configurationIdToCopy, final PageBack pageback) {
        super(id);
        final Long configurationId = configurationToEdit.getId();
        final Long parentId = configurationId == null ? configurationToEdit.getParent().getId() : null;
        this.setDefaultModel((IModel)new LoadableDetachableModel<Configuration>(){

            protected Configuration load() {
                if (configurationId != null) {
                    return (Configuration)ConfigurationManager.instance.load(configurationId);
                }
                configurationToEdit.setParent((Configuration)ConfigurationManager.instance.load(parentId));
                return configurationToEdit;
            }
        });
        this.add(new Component[]{new Label("title", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                if (GeneralSettingEdit.this.getConfigurationToEdit().isNew()) {
                    return "Creating New Child Configuration";
                }
                return "Edit General Setting";
            }
        })});
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (Method getter : ViewContext.getViewables(Configuration.class)) {
            if (getter.getAnnotation(General.class) == null) continue;
            propertyNames.add(BeanUtils.getPropertyName(getter));
        }
        final EditContext editContext = new EditContext(configurationToEdit, propertyNames.toArray(new String[propertyNames.size()]));
        Form<Void> form = new Form<Void>("form"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    VersionManager versionManager;
                    String previousAuditContent = VersionedDocument.fromBean(GeneralSettingEdit.this.getConfigurationToEdit().cloneSettings()).toXML();
                    editContext.update(GeneralSettingEdit.this.getConfigurationToEdit());
                    if (!GeneralSettingEdit.this.getConfigurationToEdit().isRoot()) {
                        AbstractEntity childWithSameName = null;
                        for (Configuration child : GeneralSettingEdit.this.getConfigurationToEdit().getParent().getChildren()) {
                            if (!child.getName().equals(GeneralSettingEdit.this.getConfigurationToEdit().getName())) continue;
                            childWithSameName = child;
                            break;
                        }
                        if (childWithSameName != null && (GeneralSettingEdit.this.getConfigurationToEdit().isNew() || !childWithSameName.getId().equals(GeneralSettingEdit.this.getConfigurationToEdit().getId()))) {
                            editContext.getProperty("name").setError("This name is already used by another configuration under the same parent.");
                            this.getSession().error((Serializable)((Object)"Fix errors below."));
                            return;
                        }
                    }
                    if ((versionManager = GeneralSettingEdit.this.getConfigurationToEdit().getVersionManager()) != null) {
                        GeneralSettingEdit.this.getConfigurationToEdit().setVersionManagerDOM(VersionedDocument.fromBean(versionManager));
                    } else {
                        GeneralSettingEdit.this.getConfigurationToEdit().setVersionManagerDOM(null);
                    }
                    if (GeneralSettingEdit.this.getConfigurationToEdit().isNew()) {
                        ConfigurationManager.instance.save(GeneralSettingEdit.this.getConfigurationToEdit());
                        if (GeneralSettingEdit.this.saveRecursively) {
                            ConfigurationManager.instance.copyChildren((Configuration)ConfigurationManager.instance.load(configurationIdToCopy), GeneralSettingEdit.this.getConfigurationToEdit());
                            GeneralSettingEdit.this.saveChildren(GeneralSettingEdit.this.getConfigurationToEdit());
                        }
                        AuditManager.instance.audit(GeneralSettingEdit.this.getConfigurationToEdit(), "Configuration was added.");
                        this.getSession().info((Serializable)((Object)"New build configuration created."));
                    } else {
                        ConfigurationManager.instance.save(GeneralSettingEdit.this.getConfigurationToEdit());
                        String auditContent = VersionedDocument.fromBean(GeneralSettingEdit.this.getConfigurationToEdit().cloneSettings()).toXML();
                        AuditManager.instance.audit(GeneralSettingEdit.this.getConfigurationToEdit(), "Configuration general setting was modified.", auditContent, previousAuditContent);
                        this.getSession().info((Serializable)((Object)"Setting saved."));
                    }
                    PageParameters params = ConfigurationSettingPage.params4(GeneralSettingEdit.this.getConfigurationToEdit().getId(), "general");
                    this.setResponsePage(ConfigurationSettingPage.class, params);
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        form.add(new Component[]{new SubmitLink("save"){

            public void onSubmit() {
                GeneralSettingEdit.this.saveRecursively = false;
            }
        }});
        form.add(new Component[]{new SubmitLink("saveRecursively"){

            public void onSubmit() {
                GeneralSettingEdit.this.saveRecursively = true;
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(configurationIdToCopy != null);
            }
        }});
        form.add(new Component[]{new Link<Void>("cancel"){

            public void onClick() {
                if (pageback != null) {
                    pageback.go();
                } else {
                    PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "general");
                    this.setResponsePage(ConfigurationSettingPage.class, params);
                }
            }
        }});
        this.add(new Component[]{form});
    }

    public Configuration getConfigurationToEdit() {
        return (Configuration)this.getDefaultModelObject();
    }

    private void saveChildren(Configuration configuration) {
        for (Configuration child : configuration.getChildren()) {
            ConfigurationManager.instance.save(child);
            AuditManager.instance.audit(child, "Configuration was added.");
            this.saveChildren(child);
        }
    }
}

