/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.component.viewer.BeanViewer;
import com.pmease.quickbuild.web.component.viewer.ViewContext;
import com.pmease.quickbuild.web.page.setting.ConfigurationPluginSettingEdit;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import org.apache.commons.lang.ObjectUtils;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class DefaultConfigurationPluginSettingPanel
extends Panel {
    private Plugin plugin;
    private String panelId;

    public DefaultConfigurationPluginSettingPanel(String panelId, Plugin plugin) {
        super(panelId);
        this.panelId = panelId;
        this.plugin = plugin;
    }

    protected void onInitialize() {
        Fragment fragment;
        super.onInitialize();
        Configuration configuration = Context.getConfiguration();
        Class<?> settingClass = this.plugin.getConfigurationSettingClass();
        final String settingTitle = EditorHelper.getName(settingClass);
        this.add(new Component[]{new Label("title", settingTitle)});
        Object setting = null;
        Configuration inherited = configuration;
        while ((setting = this.plugin.getConfigurationSetting(inherited, false)) == null && (inherited = inherited.getParent()) != null) {
        }
        if (setting != null && setting != ObjectUtils.NULL) {
            if (inherited.getId().equals(configuration.getId())) {
                fragment = new Fragment("content", "definedFrag", (MarkupContainer)this);
                fragment.add(new Component[]{new BeanViewer("viewer", new ViewContext(setting))});
                fragment.add(new Component[]{new Link<Void>("edit"){

                    public void onClick() {
                        DefaultConfigurationPluginSettingPanel.this.replaceWith((Component)((Object)new ConfigurationPluginSettingEdit(DefaultConfigurationPluginSettingPanel.this.panelId, DefaultConfigurationPluginSettingPanel.this.plugin)));
                    }
                }});
                fragment.get("edit").setVisible(SecurityHelper.isEditSettingAllowed());
                Link link = new Link<Void>("inherit"){

                    public void onClick() {
                        Configuration configuration = Context.getConfiguration();
                        DefaultConfigurationPluginSettingPanel.this.plugin.saveConfigurationSetting(configuration, null);
                        AuditManager.instance.audit(configuration, "Configuration setting '" + settingTitle + "' changed to inherit from parent.");
                        PageParameters params = ConfigurationSettingPage.params4(configuration.getId(), ConfigurationSettingPage.getSettingName(DefaultConfigurationPluginSettingPanel.this.plugin));
                        this.setResponsePage(ConfigurationSettingPage.class, params);
                    }
                };
                link.setVisible(!configuration.isRoot() && SecurityHelper.isEditSettingAllowed());
                link.add(new Behavior[]{new ConfirmBehavior("Do you really want to clear this setting and inherit from parent?")});
                fragment.add(new Component[]{link});
                link = new Link<Void>("undefine"){

                    public void onClick() {
                        Configuration configuration = Context.getConfiguration();
                        DefaultConfigurationPluginSettingPanel.this.plugin.saveConfigurationSetting(configuration, ObjectUtils.NULL);
                        AuditManager.instance.audit(configuration, "Configuration setting '" + settingTitle + "' was undefined.");
                        PageParameters params = ConfigurationSettingPage.params4(configuration.getId(), ConfigurationSettingPage.getSettingName(DefaultConfigurationPluginSettingPanel.this.plugin));
                        this.setResponsePage(ConfigurationSettingPage.class, params);
                    }
                };
                link.add(new Behavior[]{new ConfirmBehavior("Do you really want to undefine this setting?")});
                link.setVisible(SecurityHelper.isEditSettingAllowed() && PluginSettingHelper.getDefaultSetting(settingClass) == null);
                fragment.add(new Component[]{link});
            } else {
                fragment = new Fragment("content", "inheritedFrag", (MarkupContainer)this);
                String settingName = ConfigurationSettingPage.getSettingName(this.plugin);
                PageParameters params = ConfigurationSettingPage.params4(inherited.getId(), settingName);
                BookmarkablePageLink link = new BookmarkablePageLink("link", ConfigurationSettingPage.class, params);
                link.add(new Component[]{new Label("label", inherited.getPathName())});
                link.setEnabled(SecurityHelper.hasPermission(inherited, ConfigurationPermission.ACCESS_SETTINGS.name()));
                fragment.add(new Component[]{link});
                fragment.add(new Component[]{new BeanViewer("viewer", new ViewContext(setting))});
                fragment.add(new Component[]{new Link<Void>("override"){

                    public void onClick() {
                        DefaultConfigurationPluginSettingPanel.this.replaceWith((Component)((Object)new ConfigurationPluginSettingEdit(DefaultConfigurationPluginSettingPanel.this.panelId, DefaultConfigurationPluginSettingPanel.this.plugin)));
                    }
                }});
                fragment.get("override").setVisible(SecurityHelper.isEditSettingAllowed());
                fragment.add(new Component[]{new Link<Void>("undefine"){

                    public void onClick() {
                        Configuration configuration = Context.getConfiguration();
                        DefaultConfigurationPluginSettingPanel.this.plugin.saveConfigurationSetting(configuration, ObjectUtils.NULL);
                        AuditManager.instance.audit(configuration, "Configuration setting '" + settingTitle + "' was undefined.");
                        PageParameters params = ConfigurationSettingPage.params4(configuration.getId(), ConfigurationSettingPage.getSettingName(DefaultConfigurationPluginSettingPanel.this.plugin));
                        this.setResponsePage(ConfigurationSettingPage.class, params);
                    }
                }});
                fragment.get("undefine").setVisible(SecurityHelper.isEditSettingAllowed() && PluginSettingHelper.getDefaultSetting(settingClass) == null);
            }
        } else {
            fragment = new Fragment("content", "undefinedFrag", (MarkupContainer)this);
            fragment.add(new Component[]{new Link<Void>("define"){

                public void onClick() {
                    DefaultConfigurationPluginSettingPanel.this.replaceWith((Component)((Object)new ConfigurationPluginSettingEdit(DefaultConfigurationPluginSettingPanel.this.panelId, DefaultConfigurationPluginSettingPanel.this.plugin)));
                }
            }});
            fragment.get("define").setVisible(SecurityHelper.isEditSettingAllowed());
            Link<Void> link = new Link<Void>("inherit"){

                public void onClick() {
                    Configuration configuration = Context.getConfiguration();
                    DefaultConfigurationPluginSettingPanel.this.plugin.saveConfigurationSetting(configuration, null);
                    AuditManager.instance.audit(configuration, "Configuration setting '" + settingTitle + "' changed to inherite from parent");
                    PageParameters params = ConfigurationSettingPage.params4(configuration.getId(), ConfigurationSettingPage.getSettingName(DefaultConfigurationPluginSettingPanel.this.plugin));
                    this.setResponsePage(ConfigurationSettingPage.class, params);
                }
            };
            fragment.add(new Component[]{link});
            if (SecurityHelper.isEditSettingAllowed() && !configuration.isRoot()) {
                inherited = configuration.getParent();
                while ((setting = this.plugin.getConfigurationSetting(inherited, false)) == null && (inherited = inherited.getParent()) != null) {
                }
                link.setVisible(setting != null && setting != ObjectUtils.NULL);
            } else {
                link.setVisible(false);
            }
        }
        this.add(new Component[]{fragment});
    }
}

