/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.component.tabbedpanel.GroupingTab;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.pmease.quickbuild.web.component.tabbedpanel.TabbedPanel;
import com.pmease.quickbuild.web.page.PageBack;
import com.pmease.quickbuild.web.page.configuration.ConfigurationPage;
import com.pmease.quickbuild.web.page.setting.AdvancedSettingPanel;
import com.pmease.quickbuild.web.page.setting.AggregationsPanel;
import com.pmease.quickbuild.web.page.setting.GeneralSettingEdit;
import com.pmease.quickbuild.web.page.setting.GeneralSettingPanel;
import com.pmease.quickbuild.web.page.setting.NotificationsPanel;
import com.pmease.quickbuild.web.page.setting.PromotionsPanel;
import com.pmease.quickbuild.web.page.setting.RepositoriesPanel;
import com.pmease.quickbuild.web.page.setting.StepsPanel;
import com.pmease.quickbuild.web.page.setting.VariablesPanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class ConfigurationSettingPage
extends ConfigurationPage {
    private String[] settingNames;
    private Configuration configurationToEdit;
    private Long configurationIdToCopy;
    private PageBack pageback;

    public ConfigurationSettingPage(PageParameters params) {
        this(params.get(0).toLong(), ConfigurationSettingPage.decodeSettingNames(params));
    }

    private static String[] decodeSettingNames(PageParameters params) {
        ArrayList<String> settingNames = new ArrayList<String>();
        for (int i = 1; i < params.getIndexedCount(); ++i) {
            settingNames.add(params.get(i).toString());
        }
        if (settingNames.isEmpty()) {
            settingNames.add("general");
        }
        return settingNames.toArray(new String[0]);
    }

    public static PageParameters params4(Long configurationId, String settingName) {
        PageParameters params = new PageParameters();
        params.set(0, (Object)configurationId);
        if (settingName != null) {
            params.set(1, (Object)settingName);
        }
        return params;
    }

    public static PageParameters params4(Long configurationId, String[] settingNames) {
        PageParameters params = new PageParameters();
        params.set(0, (Object)configurationId);
        if (settingNames != null) {
            for (int i = 0; i < settingNames.length; ++i) {
                params.set(i + 1, (Object)settingNames[i]);
            }
        }
        return params;
    }

    public ConfigurationSettingPage(Long configurationId) {
        this(configurationId, new String[]{"general"});
    }

    @Override
    protected boolean isAuthorized() {
        return SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_SETTINGS.name());
    }

    public ConfigurationSettingPage(Long configurationId, String[] settingNames) {
        super(configurationId);
        this.settingNames = settingNames;
    }

    public ConfigurationSettingPage(Configuration configurationToEdit, Long configurationIdToCopy, PageBack pageback) {
        super(configurationToEdit.isNew() ? configurationToEdit.getParent().getId() : configurationToEdit.getId());
        this.settingNames = new String[]{"general"};
        this.pageback = pageback;
        this.configurationToEdit = configurationToEdit;
        this.configurationIdToCopy = configurationIdToCopy;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        tabs.add(new Tab("general", "General Setting"){

            @Override
            public Panel getPanel(String id, Map<String, String> params) {
                if (ConfigurationSettingPage.this.configurationToEdit != null) {
                    return new GeneralSettingEdit(id, ConfigurationSettingPage.this.configurationToEdit, ConfigurationSettingPage.this.configurationIdToCopy, ConfigurationSettingPage.this.pageback);
                }
                return new GeneralSettingPanel(id);
            }
        });
        tabs.add(new Tab("repositories", "Repositories"){

            @Override
            public Panel getPanel(String id, Map<String, String> params) {
                return new RepositoriesPanel(id);
            }
        });
        tabs.add(new Tab("steps", "Steps"){

            @Override
            public Panel getPanel(String id, Map<String, String> params) {
                return new StepsPanel(id);
            }
        });
        tabs.add(new Tab("variables", "Variables"){

            @Override
            public Panel getPanel(String id, Map<String, String> params) {
                return new VariablesPanel(id);
            }
        });
        tabs.add(new Tab("promotions", "Promotions"){

            @Override
            public Panel getPanel(String id, Map<String, String> params) {
                return new PromotionsPanel(id);
            }
        });
        tabs.add(new Tab("notifications", "Notifications"){

            @Override
            public Panel getPanel(String id, Map<String, String> params) {
                return new NotificationsPanel(id);
            }
        });
        tabs.add(new Tab("aggregations", "Aggregations"){

            @Override
            public Panel getPanel(String id, Map<String, String> params) {
                return new AggregationsPanel(id);
            }
        });
        ArrayList<CategoryInfo> categoryInfos = new ArrayList<CategoryInfo>();
        for (Plugin plugin : PluginManager.instance.getPlugins()) {
            if (!plugin.isEnabled() || plugin.getConfigurationSettingClass() == null) continue;
            String[] categories = EditorHelper.getCategory(plugin.getConfigurationSettingClass());
            String category = categories.length == 0 ? "" : categories[0];
            int order = EditorHelper.getOrder(plugin.getConfigurationSettingClass());
            CategoryInfo categoryInfo = this.getCategoryInfo(categoryInfos, category);
            if (categoryInfo == null) {
                categoryInfo = new CategoryInfo();
                categoryInfo.setName(category);
                categoryInfo.setOrder(order);
                categoryInfos.add(categoryInfo);
            } else if (order < categoryInfo.getOrder()) {
                categoryInfo.setOrder(order);
            }
            categoryInfo.getPlugins().add(plugin);
        }
        Collections.sort(categoryInfos, new Comparator<CategoryInfo>(){

            @Override
            public int compare(CategoryInfo info1, CategoryInfo info2) {
                return info1.getOrder() - info2.getOrder();
            }
        });
        for (CategoryInfo info : categoryInfos) {
            Collections.sort(info.getPlugins(), new Comparator<Plugin>(){

                @Override
                public int compare(Plugin p1, Plugin p2) {
                    return EditorHelper.getOrder(p1.getConfigurationSettingClass()) - EditorHelper.getOrder(p2.getConfigurationSettingClass());
                }
            });
            ArrayList<Tab> childTabs = new ArrayList<Tab>();
            for (final Plugin plugin : info.getPlugins()) {
                childTabs.add(new Tab(EditorHelper.getName(plugin.getConfigurationSettingClass())){

                    @Override
                    public Panel getPanel(String id, Map<String, String> params) {
                        return plugin.getConfigurationSettingPanel(id);
                    }
                });
            }
            if (info.getName().length() != 0) {
                tabs.add(new GroupingTab(info.getName(), childTabs));
                continue;
            }
            tabs.addAll(childTabs);
        }
        tabs.add(new Tab("advanced", "Advanced Setting"){

            @Override
            public Panel getPanel(String id, Map<String, String> params) {
                return new AdvancedSettingPanel(id);
            }
        });
        this.add(new Component[]{new TabbedPanel("settingTab", tabs, this.settingNames){

            @Override
            protected WebMarkupContainer newTabLink(String linkId, String[] tabIds) {
                PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), tabIds);
                return new BookmarkablePageLink(linkId, ConfigurationSettingPage.class, params);
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String cssClasses = tag.getAttribute("class");
                if (cssClasses == null) {
                    cssClasses = "";
                }
                cssClasses = cssClasses + " " + ConfigurationSettingPage.this.settingNames[0];
                tag.put("class", (CharSequence)cssClasses);
            }
        }});
    }

    @Override
    protected PageParameters getPageParameters(Long configurationId) {
        return ConfigurationSettingPage.params4(configurationId, this.settingNames);
    }

    public static String getSettingName(Plugin plugin) {
        return ConfigurationSettingPage.toSettingName(EditorHelper.getName(plugin.getConfigurationSettingClass()));
    }

    public static String toSettingName(String settingTitle) {
        return settingTitle.toLowerCase().replace(' ', '_');
    }

    private CategoryInfo getCategoryInfo(List<CategoryInfo> categoryInfos, String name) {
        for (CategoryInfo each : categoryInfos) {
            if (!each.getName().equals(name)) continue;
            return each;
        }
        return null;
    }

    public static PageParameters getSettingPageParams(Plugin plugin) {
        String[] categories = EditorHelper.getCategory(plugin.getConfigurationSettingClass());
        String settingName = ConfigurationSettingPage.toSettingName(EditorHelper.getName(plugin.getConfigurationSettingClass()));
        PageParameters params = categories.length != 0 ? ConfigurationSettingPage.params4(Context.getConfiguration().getId(), new String[]{categories[0].toLowerCase().replace(' ', '_'), settingName}) : ConfigurationSettingPage.params4(Context.getConfiguration().getId(), settingName);
        return params;
    }

    private static class CategoryInfo {
        private String name;
        private int order;
        private List<Plugin> plugins = new ArrayList<Plugin>();

        private CategoryInfo() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public List<Plugin> getPlugins() {
            return this.plugins;
        }
    }
}

