/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import java.io.Serializable;
import org.apache.commons.lang.ObjectUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;

public class ConfigurationPluginSettingEdit
extends Panel {
    public ConfigurationPluginSettingEdit(String id, final Plugin plugin) {
        super(id);
        Configuration configuration = Context.getConfiguration();
        final Class<?> settingClass = plugin.getConfigurationSettingClass();
        final String settingTitle = EditorHelper.getName(settingClass);
        this.add(new Component[]{new Label("title", "Edit " + settingTitle)});
        String description = EditorHelper.getDescription(settingClass);
        Label label = new Label("description", description);
        label.setEscapeModelStrings(false);
        if (description == null) {
            label.setVisible(false);
        }
        this.add(new Component[]{label});
        Object setting = null;
        Configuration inherited = configuration;
        while ((setting = plugin.getConfigurationSetting(inherited, false)) == null && (inherited = inherited.getParent()) != null) {
        }
        if (setting == null || setting == ObjectUtils.NULL) {
            try {
                setting = settingClass.newInstance();
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
        final EditContext editContext = new EditContext(setting);
        Form<Void> form = new Form<Void>("form"){

            protected void onSubmit() {
                Configuration configuration = Context.getConfiguration();
                editContext.validate(false);
                if (!editContext.hasError()) {
                    Object setting;
                    try {
                        setting = settingClass.newInstance();
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.wrapAsUnchecked(e);
                    }
                    String previousAuditContent = VersionedDocument.fromBean(setting).toXML();
                    editContext.update(setting);
                    plugin.saveConfigurationSetting(configuration, setting);
                    AuditManager.instance.audit(configuration, "Configuration setting '" + settingTitle + "' was modified.", VersionedDocument.fromBean(setting).toXML(), previousAuditContent);
                    this.setResponsePage(ConfigurationSettingPage.class, ConfigurationSettingPage.getSettingPageParams(plugin));
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        form.add(new Component[]{new Link<Void>("cancel"){

            public void onClick() {
                this.setResponsePage(ConfigurationSettingPage.class, ConfigurationSettingPage.getSettingPageParams(plugin));
            }
        }});
        this.add(new Component[]{form});
    }
}

