/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.aggregationsupport.FailsafeAggregation;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.behavior.menu.TypeMenuBehavior;
import com.pmease.quickbuild.web.component.configuration.ConfigurationSubordinateChooser;
import com.pmease.quickbuild.web.component.configuration.InheritIndicator;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.component.viewer.BeanViewer;
import com.pmease.quickbuild.web.component.viewer.ViewContext;
import com.pmease.quickbuild.web.page.setting.AggregationEdit;
import com.pmease.quickbuild.web.page.setting.AggregationOverridesPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class AggregationsPanel
extends Panel {
    public static final String SETTING_NAME = "aggregations";
    private SelectionColumn<Aggregation> selectionColumn;

    public AggregationsPanel(final String id) {
        super(id);
        final boolean isEditSettingAllowed = SecurityHelper.isEditSettingAllowed();
        WebMarkupContainer operations = new WebMarkupContainer("operations"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(isEditSettingAllowed);
            }
        };
        this.add(new Component[]{operations});
        WebMarkupContainer addNewBtn = new WebMarkupContainer("addNew");
        operations.add(new Component[]{addNewBtn});
        addNewBtn.add(new Behavior[]{new TypeMenuBehavior<Aggregation>(){

            @Override
            public void onSelect(Class<Aggregation> aggregationClass) {
                try {
                    AggregationEdit editor = new AggregationEdit(id, aggregationClass.newInstance(), null);
                    AggregationsPanel.this.replaceWith((Component)((Object)editor));
                }
                catch (Exception e) {
                    throw ExceptionUtils.wrapAsUnchecked(e);
                }
            }
        }});
        WebMarkupContainer copyFromBtn = new WebMarkupContainer("copyFrom");
        operations.add(new Component[]{copyFromBtn});
        copyFromBtn.add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                return new ConfigurationSubordinateChooser(componentId){

                    @Override
                    protected List<String> getSubordinateNames(Configuration configuration) {
                        ArrayList<String> objectNames = new ArrayList<String>();
                        objectNames.addAll(configuration.getAggregationNames());
                        Collections.sort(objectNames);
                        return objectNames;
                    }

                    @Override
                    protected void subordinateSelected(Configuration configuration, String objectName) {
                        Aggregation aggregation = configuration.findAggregation(objectName);
                        Validate.notNull((Object)aggregation);
                        AggregationsPanel.this.replaceWith((Component)((Object)new AggregationEdit(id, aggregation, null)));
                    }
                };
            }
        }});
        Component[] componentArray = new Component[1];
        Link<Void> link = new Link<Void>("deleteSelected"){

            public void onClick() {
                Configuration configuration = Context.getConfiguration();
                Set<String> aggregationNames = configuration.getAggregationNames();
                for (Aggregation aggregation : AggregationsPanel.this.selectionColumn.getSelections()) {
                    if (!aggregationNames.contains(aggregation.getName())) {
                        this.getSession().warn((Serializable)((Object)("Can not delete inherited aggregation: " + aggregation.getName())));
                        continue;
                    }
                    ConfigurationManager.instance.deleteAggregation(configuration, aggregation.getName());
                }
                for (Aggregation aggregation : AggregationsPanel.this.selectionColumn.getSelections()) {
                    AuditManager.instance.audit(configuration, "Aggregation '" + aggregation.getName() + "' was deleted.");
                }
                AggregationsPanel.this.selectionColumn.getSelections().clear();
            }
        };
        componentArray[0] = link;
        operations.add(componentArray);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete selected aggregations?")});
        ArrayList<Object> columns = new ArrayList<Object>();
        if (isEditSettingAllowed) {
            this.selectionColumn = new SelectionColumn();
            columns.add(this.selectionColumn);
        }
        columns.add(new AbstractColumn<Aggregation>((IModel)new Model((Serializable)((Object)"Name"))){

            public void populateItem(Item<ICellPopulator<Aggregation>> cellItem, String componentId, IModel<Aggregation> rowModel) {
                Fragment fragment = new Fragment(componentId, "nameFrag", (MarkupContainer)AggregationsPanel.this);
                cellItem.add(new Component[]{fragment});
                cellItem.add(new Behavior[]{new AttributeModifier("nowrap", (Serializable)((Object)"true"))});
                final Aggregation aggregation = (Aggregation)rowModel.getObject();
                Configuration current = Context.getConfiguration();
                Configuration declarer = current.findAggregationDeclarer(aggregation.getName());
                Validate.notNull((Object)declarer);
                Configuration override = current.getParent();
                if (override != null) {
                    override = override.findAggregationDeclarer(aggregation.getName());
                }
                final boolean inherited = !current.getId().equals(declarer.getId());
                Label label = new Label("name", aggregation.getName());
                fragment.add(new Component[]{label});
                label.add(new Behavior[]{new PopupBehavior(){

                    @Override
                    protected Component getPopup(String componentId) {
                        if (aggregation instanceof FailsafeAggregation) {
                            return new Label(componentId, aggregation.getDescription());
                        }
                        return new BeanViewer(componentId, new ViewContext(aggregation));
                    }
                }.hoverMode(true)});
                Link<Void> toggleLink = new Link<Void>("toggle"){

                    public void onClick() {
                        Configuration configuration = Context.getConfiguration();
                        aggregation.setEnabled(!aggregation.isEnabled());
                        VersionedDocument dom = VersionedDocument.fromBean(aggregation);
                        configuration.getAggregationDOMs().put(aggregation.getName(), dom);
                        ConfigurationManager.instance.save(configuration);
                    }

                    protected void onComponentTag(ComponentTag tag) {
                        super.onComponentTag(tag);
                        if (aggregation.isEnabled()) {
                            tag.put("src", (CharSequence)"/images/enable.gif");
                            if (!inherited) {
                                tag.put("title", (CharSequence)"Aggregation is enabled. Click to disable.");
                            } else {
                                tag.put("title", (CharSequence)"Aggregation is enabled. Click to override as disabled.");
                            }
                        } else {
                            tag.put("src", (CharSequence)"/images/disable.png");
                            if (!inherited) {
                                tag.put("title", (CharSequence)"Aggregation is disabled. Click to enable.");
                            } else {
                                tag.put("title", (CharSequence)"Aggregation is disabled. Click to override as enabled.");
                            }
                        }
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(!(aggregation instanceof FailsafeAggregation) && isEditSettingAllowed);
                    }
                };
                fragment.add(new Component[]{toggleLink});
                Component[] componentArray = new Component[1];
                Link link = new Link<Void>("edit"){

                    public void onClick() {
                        AggregationsPanel.this.replaceWith((Component)((Object)new AggregationEdit(id, aggregation, aggregation.getName())));
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(isEditSettingAllowed);
                    }
                };
                componentArray[0] = link;
                fragment.add(componentArray);
                link.add(new Component[]{new WebMarkupContainer("icon"){

                    protected void onComponentTag(ComponentTag tag) {
                        super.onComponentTag(tag);
                        tag.put("src", (CharSequence)(inherited ? "/images/overwrite.png" : "/images/edit.png"));
                        tag.put("title", (CharSequence)(inherited ? "Overwrite this aggregation" : "Edit this aggregation"));
                    }
                }});
                Component[] componentArray2 = new Component[1];
                link = new Link<Void>("copy"){

                    public void onClick() {
                        AggregationsPanel.this.replaceWith((Component)((Object)new AggregationEdit(id, aggregation, null)));
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(isEditSettingAllowed);
                    }
                };
                componentArray2[0] = link;
                fragment.add(componentArray2);
                fragment.add(new Component[]{new Link<Void>("find"){

                    public void onClick() {
                        AggregationsPanel.this.replaceWith((Component)((Object)new AggregationOverridesPanel(id, aggregation.getName())));
                    }
                }.setVisible(!inherited)});
                fragment.add(new Component[]{new InheritIndicator("inherit", declarer, override, AggregationsPanel.SETTING_NAME)});
            }
        });
        columns.add(new AbstractColumn<Aggregation>((IModel)new Model((Serializable)((Object)"Type"))){

            public void populateItem(Item<ICellPopulator<Aggregation>> cellItem, String componentId, IModel<Aggregation> rowModel) {
                Aggregation aggregation = (Aggregation)rowModel.getObject();
                cellItem.add(new Component[]{new Label(componentId, EditorHelper.getName(aggregation.getClass()))});
                if (aggregation instanceof FailsafeAggregation) {
                    cellItem.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"red"))});
                }
                cellItem.add(new Behavior[]{new AttributeModifier("nowrap", (Serializable)((Object)"true"))});
            }
        });
        columns.add(new AbstractColumn<Aggregation>((IModel)new Model((Serializable)((Object)"Description"))){

            public void populateItem(Item<ICellPopulator<Aggregation>> cellItem, String componentId, IModel<Aggregation> rowModel) {
                Aggregation aggregation = (Aggregation)rowModel.getObject();
                cellItem.add(new Component[]{new Label(componentId, aggregation.getDescription())});
            }
        });
        DataProvider<Aggregation> dataProvider = new DataProvider<Aggregation>(){

            public Iterator<Aggregation> iterator(int first, int count) {
                List<Aggregation> aggregations = Context.getConfiguration().findAggregations();
                Collections.sort(aggregations, new Comparator<Aggregation>(){

                    @Override
                    public int compare(Aggregation aggregation1, Aggregation aggregation2) {
                        return aggregation1.getName().compareTo(aggregation2.getName());
                    }
                });
                return aggregations.iterator();
            }

            public int size() {
                return Context.getConfiguration().findAggregationNames().size();
            }
        };
        this.add(new Component[]{new DefaultDataTable(SETTING_NAME, columns, (ISortableDataProvider)dataProvider, Integer.MAX_VALUE)});
    }
}

