/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.behavior.menu.TypeMenuBehavior;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class AggregationEdit
extends Panel {
    public AggregationEdit(final String id, final Aggregation aggregation, final String aggregationName) {
        super(id);
        this.add(new Component[]{new Label("aggregationType", EditorHelper.getName(aggregation.getClass()))});
        WebMarkupContainer changeTypeBtn = new WebMarkupContainer("changeType");
        this.add(new Component[]{changeTypeBtn});
        changeTypeBtn.add(new Behavior[]{new TypeMenuBehavior<Aggregation>(){

            @Override
            public void onSelect(Class<Aggregation> aggregationClass) {
                Aggregation newAggregation;
                try {
                    newAggregation = aggregationClass.newInstance();
                }
                catch (Exception e) {
                    throw ExceptionUtils.wrapAsUnchecked(e);
                }
                newAggregation.setName(aggregation.getName());
                newAggregation.setDescription(aggregation.getDescription());
                newAggregation.setBuildMatcher(aggregation.getBuildMatcher());
                newAggregation.setEnabled(aggregation.isEnabled());
                AggregationEdit editor = new AggregationEdit(id, newAggregation, aggregationName);
                AggregationEdit.this.replaceWith((Component)((Object)editor));
            }
        }});
        String description = EditorHelper.getDescription(aggregation.getClass());
        Label label = new Label("description", description);
        label.setEscapeModelStrings(false);
        if (description == null) {
            label.setVisible(false);
        }
        this.add(new Component[]{label});
        final EditContext editContext = new EditContext(aggregation);
        Form form = new Form("form"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    editContext.update(aggregation);
                    Configuration configuration = Context.getConfiguration();
                    if (aggregationName == null) {
                        if (configuration.getAggregationNames().contains(aggregation.getName())) {
                            editContext.getProperty("name").setError("This name is already used by another aggregation in this configuration.");
                            this.getSession().error((Serializable)((Object)"Fix errors below."));
                        } else {
                            ConfigurationManager.instance.saveAggregation(configuration, aggregation, null);
                            AuditManager.instance.audit(configuration, "Aggregation '" + aggregation.getName() + "' was added.");
                            PageParameters params = ConfigurationSettingPage.params4(configuration.getId(), "aggregations");
                            this.setResponsePage(ConfigurationSettingPage.class, params);
                            this.getSession().info((Serializable)((Object)"Setting saved."));
                        }
                    } else {
                        VersionedDocument dom = AggregationEdit.this.getDom(aggregationName);
                        if (dom != null) {
                            if (!aggregation.getName().equals(aggregationName) && AggregationEdit.this.getDom(aggregation.getName()) != null) {
                                editContext.getProperty("name").setError("This name is already used by another aggregation in this configuration.");
                                this.getSession().error((Serializable)((Object)"Fix errors below."));
                            } else {
                                ConfigurationManager.instance.saveAggregation(configuration, aggregation, aggregationName);
                                AuditManager.instance.audit(configuration, "Aggregation '" + aggregation.getName() + "' was modified.", VersionedDocument.fromBean(aggregation).toXML(), dom.toXML());
                                PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "aggregations");
                                this.setResponsePage(ConfigurationSettingPage.class, params);
                                this.getSession().info((Serializable)((Object)"Setting saved."));
                            }
                        } else {
                            ConfigurationManager.instance.saveAggregation(configuration, aggregation, null);
                            AuditManager.instance.audit(configuration, "Aggregation '" + aggregation.getName() + "' was overwrited from parent.");
                            PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "aggregations");
                            this.setResponsePage(ConfigurationSettingPage.class, params);
                            this.getSession().info((Serializable)((Object)"Setting saved."));
                        }
                    }
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        form.add(new Component[]{new Link("cancel"){

            public void onClick() {
                PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "aggregations");
                this.setResponsePage(ConfigurationSettingPage.class, params);
            }
        }});
        this.add(new Component[]{form});
    }

    private VersionedDocument getDom(String aggregationName) {
        return Context.getConfiguration().getAggregationDOMs().get(aggregationName);
    }
}

