/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ArtifactStorage;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.viewer.ViewContext;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class AdvancedSettingEdit
extends Panel {
    public AdvancedSettingEdit(String id) {
        super(id);
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (Method getter : ViewContext.getViewables(Configuration.class)) {
            if (getter.getAnnotation(Advanced.class) == null) continue;
            propertyNames.add(BeanUtils.getPropertyName(getter));
        }
        final EditContext editContext = new EditContext(Context.getConfiguration(), propertyNames.toArray(new String[propertyNames.size()]));
        Form form = new Form("form"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    String previousAuditContent = VersionedDocument.fromBean(Context.getConfiguration().cloneSettings()).toXML();
                    editContext.update(Context.getConfiguration());
                    ArtifactStorage artifactStorage = Context.getConfiguration().getArtifactStorage();
                    if (artifactStorage != null) {
                        Context.getConfiguration().setArtifactStorageDOM(VersionedDocument.fromBean(artifactStorage));
                    } else {
                        Context.getConfiguration().setArtifactStorageDOM(null);
                    }
                    ConfigurationManager.instance.save(Context.getConfiguration());
                    AuditManager.instance.audit(Context.getConfiguration(), "Configuration advanced setting was modified.", VersionedDocument.fromBean(Context.getConfiguration().cloneSettings()).toXML(), previousAuditContent);
                    PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "advanced");
                    this.setResponsePage(ConfigurationSettingPage.class, params);
                    this.getSession().info((Serializable)((Object)"Setting saved."));
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        form.add(new Component[]{new Link("cancel"){

            public void onClick() {
                PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "advanced");
                this.setResponsePage(ConfigurationSettingPage.class, params);
            }
        }});
        this.add(new Component[]{form});
    }
}

