/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.queue;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.component.BookmarkableTextLink;
import com.pmease.quickbuild.web.component.build.BuildLink;
import com.pmease.quickbuild.web.component.configuration.ConfigurationLink;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.page.MainPage;
import com.pmease.quickbuild.web.page.configuration.BuildRequestWaitingReasonPanel;
import com.pmease.quickbuild.web.page.grid.GridPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class QueuePage
extends MainPage {
    private SelectionColumn<BuildRequest> selectionColumn;

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.setDefaultModel((IModel)new LoadableDetachableModel<Map<String, BuildRequest>>(){

            protected Map<String, BuildRequest> load() {
                LinkedHashMap<String, BuildRequest> requests = new LinkedHashMap<String, BuildRequest>();
                for (BuildRequest request : BuildEngine.instance.getBuildRequests(null)) {
                    requests.put(request.getId(), request);
                }
                return requests;
            }
        });
        ArrayList<Object> columns = new ArrayList<Object>();
        if (SecurityHelper.isAdmin()) {
            this.selectionColumn = new SelectionColumn();
            columns.add(this.selectionColumn);
        }
        columns.add(new AbstractColumn<BuildRequest>((IModel)new Model((Serializable)((Object)"Configuration")), "configuration"){

            public void populateItem(Item<ICellPopulator<BuildRequest>> cellItem, String componentId, final IModel<BuildRequest> rowModel) {
                cellItem.add(new Component[]{new ConfigurationLink(componentId, (IModel<Configuration>)new LoadableDetachableModel<Configuration>(){

                    protected Configuration load() {
                        return ((BuildRequest)rowModel.getObject()).getBuild().getConfiguration();
                    }
                })});
            }
        });
        columns.add(new AbstractColumn<BuildRequest>((IModel)new Model((Serializable)((Object)"Requested By")), "requestedBy"){

            public void populateItem(Item<ICellPopulator<BuildRequest>> cellItem, String componentId, IModel<BuildRequest> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, ((BuildRequest)rowModel.getObject()).getRequesterName())});
            }
        });
        columns.add(new AbstractColumn<BuildRequest>((IModel)new Model((Serializable)((Object)"Schedule Date")), "scheduleDate"){

            public void populateItem(Item<ICellPopulator<BuildRequest>> cellItem, String componentId, IModel<BuildRequest> rowModel) {
                String scheduleDateStr = DateUtils.formatDateTime(((BuildRequest)rowModel.getObject()).getRequestDate());
                cellItem.add(new Component[]{new Label(componentId, scheduleDateStr)});
            }
        });
        columns.add(new AbstractColumn<BuildRequest>((IModel)new Model((Serializable)((Object)"Priority")), "priority"){

            public void populateItem(Item<ICellPopulator<BuildRequest>> cellItem, String componentId, IModel<BuildRequest> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, String.valueOf(((BuildRequest)rowModel.getObject()).getPriority()))});
            }
        });
        columns.add(new AbstractColumn<BuildRequest>((IModel)new Model((Serializable)((Object)"Process Status")), "processStatus"){

            public void populateItem(Item<ICellPopulator<BuildRequest>> cellItem, String componentId, IModel<BuildRequest> rowModel) {
                BuildRequest request = (BuildRequest)rowModel.getObject();
                Fragment fragment = new Fragment(componentId, "requestStatusFrag", (MarkupContainer)QueuePage.this);
                fragment.add(new Component[]{new Label("statusName", request.getStatus().name())});
                fragment.add(new Component[]{new BuildRequestWaitingReasonPanel("waitingReason", rowModel)});
                cellItem.add(new Component[]{fragment});
            }
        });
        columns.add(new AbstractColumn<BuildRequest>((IModel)new Model((Serializable)((Object)"Master Node"))){

            public void populateItem(Item<ICellPopulator<BuildRequest>> cellItem, String componentId, IModel<BuildRequest> rowModel) {
                String masterNode = ((BuildRequest)rowModel.getObject()).getBuild().getMasterStep().getNodeAddress();
                if (masterNode != null) {
                    cellItem.add(new Component[]{new BookmarkableTextLink(componentId, masterNode, GridPage.class, GridPage.params4(masterNode)).add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"link"))})});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "<i>Not determined</i>").setEscapeModelStrings(false)});
                }
            }
        });
        columns.add(new AbstractColumn<BuildRequest>((IModel)new Model((Serializable)((Object)"Build Version")), "buildVersion"){

            public void populateItem(Item<ICellPopulator<BuildRequest>> cellItem, String componentId, final IModel<BuildRequest> rowModel) {
                BuildRequest request = (BuildRequest)rowModel.getObject();
                if (request.getBuild().getId() != null) {
                    cellItem.add(new Component[]{new BuildLink(componentId, (IModel<Build>)new LoadableDetachableModel<Build>(){

                        protected Build load() {
                            return ((BuildRequest)rowModel.getObject()).getBuild();
                        }
                    })});
                } else {
                    Label label = new Label(componentId, "<i>Not determined</i>");
                    label.setEscapeModelStrings(false);
                    cellItem.add(new Component[]{label});
                }
            }
        });
        this.add(new Component[]{new DefaultDataTable("buildRequests", columns, (ISortableDataProvider)new DataProvider<BuildRequest>(){

            @Override
            public IModel<BuildRequest> model(BuildRequest object) {
                final String requestId = object.getId();
                return new LoadableDetachableModel<BuildRequest>(){

                    protected BuildRequest load() {
                        return (BuildRequest)QueuePage.this.getBuildRequests().get(requestId);
                    }
                };
            }

            public Iterator<? extends BuildRequest> iterator(int first, int count) {
                ArrayList requests = new ArrayList(QueuePage.this.getBuildRequests().values());
                if (this.getSort() != null) {
                    if (this.getSort().getProperty().equals("configuration")) {
                        Collections.sort(requests, new Comparator<BuildRequest>(){

                            @Override
                            public int compare(BuildRequest o1, BuildRequest o2) {
                                return o1.getBuild().getConfiguration().getPathName().compareTo(o2.getBuild().getConfiguration().getPathName());
                            }
                        });
                    } else if (this.getSort().getProperty().equals("requestedBy")) {
                        Collections.sort(requests, new Comparator<BuildRequest>(){

                            @Override
                            public int compare(BuildRequest o1, BuildRequest o2) {
                                return o1.getRequesterName().compareTo(o2.getRequesterName());
                            }
                        });
                    } else if (this.getSort().getProperty().equals("scheduleDate")) {
                        Collections.sort(requests, new Comparator<BuildRequest>(){

                            @Override
                            public int compare(BuildRequest o1, BuildRequest o2) {
                                return o1.getRequestDate().compareTo(o2.getRequestDate());
                            }
                        });
                    } else if (this.getSort().getProperty().equals("priority")) {
                        Collections.sort(requests, new Comparator<BuildRequest>(){

                            @Override
                            public int compare(BuildRequest o1, BuildRequest o2) {
                                return o1.getPriority().compareTo(o2.getPriority());
                            }
                        });
                    } else if (this.getSort().getProperty().equals("processStatus")) {
                        Collections.sort(requests, new Comparator<BuildRequest>(){

                            @Override
                            public int compare(BuildRequest o1, BuildRequest o2) {
                                return o1.getStatus().name().compareTo(o2.getStatus().name());
                            }
                        });
                    } else if (this.getSort().getProperty().equals("buildVersion")) {
                        Collections.sort(requests, new Comparator<BuildRequest>(){

                            @Override
                            public int compare(BuildRequest o1, BuildRequest o2) {
                                String version2;
                                String version1 = o1.getBuild().getVersion();
                                if (version1 == null) {
                                    version1 = "";
                                }
                                if ((version2 = o2.getBuild().getVersion()) == null) {
                                    version2 = "";
                                }
                                return version1.compareTo(version2);
                            }
                        });
                    } else {
                        throw new IllegalStateException();
                    }
                    if (!this.getSort().isAscending()) {
                        Collections.reverse(requests);
                    }
                }
                return requests.subList(first, first + count).iterator();
            }

            public int size() {
                return QueuePage.this.getBuildRequests().size();
            }
        }, CacheManager.instance.getSystemSetting().getQueuePageSize())});
        Component[] componentArray = new Component[1];
        Link link = new Link<Void>("cancelSelected"){

            public void onClick() {
                if (!QueuePage.this.selectionColumn.getSelections().isEmpty()) {
                    for (BuildRequest request : QueuePage.this.selectionColumn.getSelections()) {
                        if (request == null) continue;
                        BuildEngine.instance.cancelRequest(request.getId());
                        AuditManager.instance.audit(request.getBuild().getConfiguration(), "Build request was cancelled from Queue.");
                    }
                    this.getSession().warn((Serializable)((Object)"Cancel command issued. The build may take a while to be cancelled."));
                } else {
                    this.getSession().warn((Serializable)((Object)"Please select build requests to cancel."));
                }
                this.setResponsePage(QueuePage.class);
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.isAdmin());
            }
        };
        componentArray[0] = link;
        this.add(componentArray);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to cancel selected build requests?")});
        Component[] componentArray2 = new Component[1];
        link = new Link<Void>("cancelAll"){

            public void onClick() {
                if (!QueuePage.this.getBuildRequests().isEmpty()) {
                    for (BuildRequest request : QueuePage.this.getBuildRequests().values()) {
                        BuildEngine.instance.cancelRequest(request.getId());
                        AuditManager.instance.audit(request.getBuild().getConfiguration(), "Build request was cancelled from Queue.");
                    }
                    this.getSession().warn((Serializable)((Object)"Cancel command issued. The build may take a while to be cancelled."));
                }
                this.setResponsePage(QueuePage.class);
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.isAdmin());
            }
        };
        componentArray2[0] = link;
        this.add(componentArray2);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to cancel all build requests?")});
    }

    private Map<String, BuildRequest> getBuildRequests() {
        return (Map)this.getDefaultModelObject();
    }
}

