/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.my;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Subscription;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.PropertyEditor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang.Validate;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;

public class MySettingEdit
extends Panel {
    public MySettingEdit(String panelId) {
        super(panelId);
        User user = Context.getUser();
        if (user == null) {
            throw new QuickbuildException("Sorry, anonymous user do not have user profiles, and thusly can not access the user setting page");
        }
        final EditContext editContext = new EditContext(user, new String[]{"subscriptions"}, true);
        final ArrayList<Pair<String, EditContext>> pluginSettingEditContexts = new ArrayList<Pair<String, EditContext>>();
        for (Plugin plugin : PluginManager.instance.getPlugins()) {
            if (!plugin.isEnabled() || plugin.getUserSettingClass() == null) continue;
            Object pluginSetting = plugin.getUserSetting(user, false);
            if (pluginSetting == null) {
                try {
                    pluginSetting = plugin.getUserSettingClass().newInstance();
                }
                catch (Exception e) {
                    throw ExceptionUtils.wrapAsUnchecked(e);
                }
            }
            pluginSettingEditContexts.add(new Pair<String, EditContext>(plugin.getId(), new EditContext(pluginSetting)));
        }
        final EditContext subscriptionListEditContext = new EditContext(user, new String[]{"subscriptions"});
        Form<Void> form = new Form<Void>("form"){

            protected void onSubmit() {
                editContext.validate(false);
                boolean hasError = false;
                if (editContext.hasError()) {
                    hasError = true;
                }
                for (Pair pair : pluginSettingEditContexts) {
                    ((EditContext)pair.getSecond()).validate(false);
                    if (!((EditContext)pair.getSecond()).hasError()) continue;
                    hasError = true;
                }
                subscriptionListEditContext.validate(false);
                if (subscriptionListEditContext.hasError()) {
                    hasError = true;
                }
                if (!hasError) {
                    User user = Context.getUser();
                    editContext.update(user);
                    User userWithSameName = UserManager.instance.get(user.getName());
                    if (userWithSameName != null && !userWithSameName.getId().equals(user.getId())) {
                        editContext.getProperty("name").setError("This name is already used by another user.");
                        this.getSession().error((Serializable)((Object)"Fix errors below."));
                        return;
                    }
                    subscriptionListEditContext.update(user);
                    HashSet<String> notifierNames = new HashSet<String>();
                    for (Subscription subscription : user.getSubscriptions()) {
                        subscription.setUser(user);
                        notifierNames.add(subscription.getNotifier());
                    }
                    for (Pair pair : pluginSettingEditContexts) {
                        Object pluginSetting;
                        Plugin plugin = PluginManager.instance.getPlugin((String)pair.getFirst());
                        Validate.notNull((Object)plugin);
                        Validate.notNull(plugin.getUserSettingClass());
                        try {
                            pluginSetting = plugin.getUserSettingClass().newInstance();
                        }
                        catch (Exception e) {
                            throw ExceptionUtils.wrapAsUnchecked(e);
                        }
                        ((EditContext)pair.getSecond()).update(pluginSetting);
                        user.getPluginSettingDOMs().put(plugin.getId(), VersionedDocument.fromBean(pluginSetting));
                    }
                    if (editContext.hasError()) {
                        this.getSession().error((Serializable)((Object)"Fix errors below."));
                        return;
                    }
                    for (Pair pair : pluginSettingEditContexts) {
                        if (!((EditContext)pair.getSecond()).hasError()) continue;
                        this.getSession().error((Serializable)((Object)"Fix errors below."));
                        return;
                    }
                    UserManager.instance.save(user);
                    this.getSession().info((Serializable)((Object)"Your setting has been updated."));
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        this.add(new Component[]{form});
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        RepeatingView pluginSettingEditorsView = new RepeatingView("pluginSettingEditors");
        for (Pair pair : pluginSettingEditContexts) {
            pluginSettingEditorsView.add(new Component[]{new BeanEditor(pluginSettingEditorsView.newChildId(), (EditContext)pair.getSecond())});
        }
        form.add(new Component[]{pluginSettingEditorsView});
        PropertyEditor listEditor = new PropertyEditor("subscriptionListEditor", "Subscriptions", User.class, subscriptionListEditContext.getProperty("subscriptions"));
        listEditor.setVisible(!CacheManager.instance.getSystemSetting().isDisableSubscriptions());
        form.add(new Component[]{listEditor});
    }
}

