/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.my;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.MiscUtils;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.pmease.quickbuild.web.component.tabbedpanel.TabbedPanel;
import com.pmease.quickbuild.web.page.MainPage;
import com.pmease.quickbuild.web.page.my.MonitorDownloadSetting;
import com.pmease.quickbuild.web.page.my.MyAgentPanel;
import com.pmease.quickbuild.web.page.my.MySettingEdit;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceRequestHandler;
import org.apache.wicket.request.resource.ByteArrayResource;
import org.apache.wicket.request.resource.IResource;

public class MyPage
extends MainPage {
    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new WebMarkupContainer("downloadAgent"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.isAgentAllowed());
            }
        }.add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                Fragment frag = new Fragment(componentId, "agentDownloadFrag", (MarkupContainer)MyPage.this);
                frag.add(new Component[]{new WebMarkupContainer("installServiceUrl").add(new Behavior[]{new AttributeModifier("href", (Serializable)((Object)(Bootstrap.docroot + "/Install+As+System+Service")))})});
                return frag;
            }
        }})});
        this.add(new Component[]{new WebMarkupContainer("downloadMonitor").add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                final EditContext monitorDownloadEditContext = new EditContext(new MonitorDownloadSetting());
                Fragment fragment = new Fragment(componentId, "monitorDownloadFormFrag", (MarkupContainer)MyPage.this);
                Form<Void> form = new Form<Void>("monitorDownloadForm"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void onSubmit() {
                        block14: {
                            MonitorDownloadSetting setting = new MonitorDownloadSetting();
                            monitorDownloadEditContext.update(setting);
                            File jarFile = MyPage.this.packageMonitorAsJar(setting);
                            try {
                                if (setting.getPlatform().startsWith("win")) {
                                    File zipFile = FileUtils.createTempFile("monitor");
                                    try {
                                        FileUtils.copyFile(new File(Bootstrap.getAssetDir(), "batch-download.zip"), zipFile);
                                        Project antProject = MiscUtils.createAntProject();
                                        Zip zip = new Zip();
                                        zip.setProject(antProject);
                                        zip.setDestFile(zipFile);
                                        ZipFileSet fileset = new ZipFileSet();
                                        fileset.setProject(antProject);
                                        fileset.setFile(new File(Bootstrap.getAddonsDir(), "traymonitor/wrapper/windows/traymonitor.exe"));
                                        fileset.setFullpath("traymonitor/traymonitor.exe");
                                        zip.add((ResourceCollection)fileset);
                                        fileset = new ZipFileSet();
                                        fileset.setProject(antProject);
                                        fileset.setFile(jarFile);
                                        fileset.setFullpath("traymonitor/traymonitor.jar");
                                        zip.add((ResourceCollection)fileset);
                                        zip.execute();
                                        ByteArrayResource resource = new ByteArrayResource("application/octet-stream", FileUtils.readFileAsBytes(zipFile), "traymonitor.zip");
                                        RequestCycle.get().scheduleRequestHandlerAfterCurrent((IRequestHandler)new ResourceRequestHandler((IResource)resource, null));
                                        break block14;
                                    }
                                    finally {
                                        FileUtils.deleteFile(zipFile);
                                    }
                                }
                                if (setting.getPlatform().startsWith("mac")) {
                                    File zipFile = FileUtils.createTempFile("monitor");
                                    try {
                                        File tempDir = FileUtils.createTempDir("monitor");
                                        try {
                                            File macosxDir = new File(Bootstrap.getAddonsDir(), "traymonitor/wrapper/macosx");
                                            FileUtils.copyDir(macosxDir, tempDir);
                                            FileUtils.copyFile(new File(Bootstrap.getAssetDir(), "batch-download.zip"), zipFile);
                                            Project antProject = MiscUtils.createAntProject();
                                            Zip zip = new Zip();
                                            zip.setProject(antProject);
                                            zip.setDestFile(zipFile);
                                            ZipFileSet fileset = new ZipFileSet();
                                            fileset.setProject(antProject);
                                            fileset.setDir(tempDir);
                                            fileset.setIncludes("**/*");
                                            fileset.setExcludes("TrayMonitor.app/Contents/MacOS/JavaApplicationStub");
                                            zip.add((ResourceCollection)fileset);
                                            fileset = new ZipFileSet();
                                            fileset.setProject(antProject);
                                            fileset.setDir(tempDir);
                                            fileset.setIncludes("TrayMonitor.app/Contents/MacOS/JavaApplicationStub");
                                            fileset.setFileMode("755");
                                            zip.add((ResourceCollection)fileset);
                                            fileset = new ZipFileSet();
                                            fileset.setProject(antProject);
                                            fileset.setFile(jarFile);
                                            fileset.setFullpath("TrayMonitor.app/Contents/Resources/Java/traymonitor.jar");
                                            zip.add((ResourceCollection)fileset);
                                            zip.execute();
                                            ByteArrayResource resource = new ByteArrayResource("application/octet-stream", FileUtils.readFileAsBytes(zipFile), "traymonitor.app.zip");
                                            RequestCycle.get().scheduleRequestHandlerAfterCurrent((IRequestHandler)new ResourceRequestHandler((IResource)resource, null));
                                            break block14;
                                        }
                                        finally {
                                            FileUtils.deleteDir(tempDir);
                                        }
                                    }
                                    finally {
                                        FileUtils.deleteFile(zipFile);
                                    }
                                }
                                ByteArrayResource resource = new ByteArrayResource("application/octet-stream", FileUtils.readFileAsBytes(jarFile), "traymonitor.jar");
                                RequestCycle.get().scheduleRequestHandlerAfterCurrent((IRequestHandler)new ResourceRequestHandler((IResource)resource, null));
                            }
                            finally {
                                FileUtils.deleteFile(jarFile);
                            }
                        }
                    }
                };
                form.add(new Component[]{new WebMarkupContainer("trayMonitorDoc"){

                    protected void onComponentTag(ComponentTag tag) {
                        super.onComponentTag(tag);
                        tag.put("href", (CharSequence)(Bootstrap.docroot + "/Tray+Monitor"));
                    }
                }});
                form.add(new Component[]{new BeanEditor("editor", monitorDownloadEditContext)});
                form.add(new Component[]{new SubmitLink("download")});
                fragment.add(new Component[]{form});
                return fragment;
            }
        }})});
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        tabs.add(new Tab("My Setting"){

            @Override
            public Panel getPanel(String panelId, Map<String, String> panelParams) {
                return new MySettingEdit(panelId);
            }
        });
        tabs.add(new Tab("My Agent"){

            @Override
            public Panel getPanel(String panelId, Map<String, String> panelParams) {
                return new MyAgentPanel(panelId);
            }
        });
        this.add(new Component[]{new TabbedPanel("tabs", tabs)});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File packageMonitorAsJar(MonitorDownloadSetting setting) {
        File jarFile = new File(Bootstrap.getTempDir(), "packagemonitor_" + UUID.randomUUID().toString());
        try {
            File tempDir = FileUtils.createTempDir("monitor");
            try {
                Project antProject = MiscUtils.createAntProject();
                Jar jar = new Jar();
                jar.setProject(antProject);
                jar.setDestFile(jarFile);
                jar.setFilesetmanifest((Jar.FilesetManifestConfig)Jar.FilesetManifestConfig.getInstance(Jar.FilesetManifestConfig.class, (String)"mergewithoutmain"));
                Manifest manifest = new Manifest();
                manifest.addConfiguredAttribute(new Manifest.Attribute("Main-Class", "com.pmease.quickbuild.monitor.MainApp"));
                manifest.addConfiguredAttribute(new Manifest.Attribute("Class-Path", "."));
                jar.addConfiguredManifest(manifest);
                FileSet fileset = new FileSet();
                fileset.setProject(antProject);
                File traymonitorDir = new File(Bootstrap.getAddonsDir(), "traymonitor");
                fileset.setDir(traymonitorDir);
                fileset.setExcludes("**/*.jar, settings.properties");
                jar.addFileset(fileset);
                fileset = new FileSet();
                fileset.setProject(antProject);
                fileset.setDir(tempDir);
                Properties monitorSettings = new Properties();
                monitorSettings.setProperty("host", Quickbuild.getInstance().getUrl());
                monitorSettings.setProperty("username", "");
                monitorSettings.setProperty("password", "");
                monitorSettings.setProperty("notificationDisplayTime", "5");
                monitorSettings.setProperty("interval", "60");
                FileUtils.saveProps(new File(tempDir, "settings.properties"), monitorSettings);
                jar.addFileset(fileset);
                String excludes = "META-INF/*.SF, *.txt, *.html, .api_*, *.xpt, plugin.*";
                for (File file : new File(traymonitorDir, "lib").listFiles()) {
                    if (!file.getName().endsWith(".jar")) continue;
                    ZipFileSet zipfileset = new ZipFileSet();
                    zipfileset.setProject(antProject);
                    zipfileset.setExcludes(excludes);
                    zipfileset.setSrc(file);
                    jar.addZipfileset(zipfileset);
                }
                ZipFileSet zipfileset = new ZipFileSet();
                zipfileset.setProject(antProject);
                zipfileset.setExcludes(excludes);
                zipfileset.setSrc(new File(traymonitorDir, "lib/" + setting.getPlatform() + "/swt.jar"));
                jar.addZipfileset(zipfileset);
                jar.execute();
                File file = jarFile;
                return file;
            }
            catch (ManifestException e) {
                throw new RuntimeException(e);
            }
            finally {
                FileUtils.deleteDir(tempDir);
            }
        }
        catch (Exception e) {
            if (!jarFile.exists()) throw ExceptionUtils.wrapAsUnchecked(e);
            FileUtils.deleteFile(jarFile);
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }
}

