/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.my;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.pmease.quickbuild.web.component.tabbedpanel.TabbedPanel;
import com.pmease.quickbuild.web.page.grid.GridNodeModel;
import com.pmease.quickbuild.web.page.grid.SystemAttributePanel;
import com.pmease.quickbuild.web.page.grid.UserAttributeEdit;
import java.util.ArrayList;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class MyAgentPanel
extends Panel {
    public MyAgentPanel(String panelId) {
        super(panelId);
        this.setDefaultModel((IModel)new LoadableDetachableModel<GridNode>(){

            protected GridNode load() {
                return AgentManager.instance.getUserAgent(Context.getUser());
            }
        });
        this.add(new Component[]{new WebMarkupContainer("agentNotActive"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(MyAgentPanel.this.getAgent() == null);
            }
        }});
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        if (this.getAgent() != null) {
            tabs.add(new Tab("System Attributes"){

                @Override
                public Panel getPanel(String panelId, Map<String, String> panelParams) {
                    return new SystemAttributePanel(panelId, (IModel<GridNode>)new GridNodeModel(MyAgentPanel.this.getAgent().getAddress()));
                }
            });
            tabs.add(new Tab("User Attributes"){

                @Override
                public Panel getPanel(String panelId, Map<String, String> panelParams) {
                    return new UserAttributeEdit(panelId, (IModel<GridNode>)new GridNodeModel(MyAgentPanel.this.getAgent().getAddress()));
                }
            });
        }
        this.add(new Component[]{new TabbedPanel("tabs", tabs){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(MyAgentPanel.this.getAgent() != null);
            }
        }});
    }

    private GridNode getAgent() {
        return (GridNode)this.getDefaultModelObject();
    }
}

