/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.my;

import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;

public class MonitorDownloadSetting {
    private String platform = "windows-x86-32";

    @Editable(order=50, description="Choose your OS platform. The 64-bit tray monitor requires 64-bit JVM. If you are running a 32-bit JVM on your 64-bit OS, please download the 32-bit version.")
    @ChoiceProvider(value="getPlatformChoices")
    @NotNull
    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    private static List<String> getPlatformChoices() {
        ArrayList<String> choices = new ArrayList<String>();
        for (File file : new File(Bootstrap.installDir, "addons/traymonitor/lib").listFiles()) {
            if (!file.isDirectory()) continue;
            choices.add(file.getName());
        }
        Collections.sort(choices);
        return choices;
    }
}

