/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.lite;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.RequestResult;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.variable.VariableBeanHelper;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.behavior.RefreshBehavior;
import com.pmease.quickbuild.web.component.build.BuildInfoPanel;
import com.pmease.quickbuild.web.component.configuration.ConfigurationStatusPanel;
import com.pmease.quickbuild.web.component.configuration.ConfigurationTreeTable;
import com.pmease.quickbuild.web.component.treetable.TreeState;
import com.pmease.quickbuild.web.component.treetable.TreeTableColumn;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.PageBack;
import com.pmease.quickbuild.web.page.build.HistoryBuildsPage;
import com.pmease.quickbuild.web.page.configuration.ConfigurationOverview;
import com.pmease.quickbuild.web.page.configuration.ConfigurationPage;
import com.pmease.quickbuild.web.page.lite.LiteBuildOptionEdit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.visit.IVisit;

public class LiteDashboardPage
extends BasePage {
    public LiteDashboardPage(PageParameters params) {
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        ArrayList<TreeTableColumn> columns = new ArrayList<TreeTableColumn>();
        columns.add(new TreeTableColumn(){

            @Override
            public Component newCell(String id, Serializable nodeKey) {
                final Long configurationId = (Long)nodeKey;
                Fragment fragment = new Fragment(id, "historyFrag", (MarkupContainer)LiteDashboardPage.this);
                BookmarkablePageLink link = new BookmarkablePageLink("link", HistoryBuildsPage.class, HistoryBuildsPage.params4(configurationId, null));
                final Label label = new Label("label", (IModel)new Model((Serializable)Long.valueOf(CacheManager.instance.getHistoryCount(configurationId))));
                label.add(new Behavior[]{new RefreshBehavior(){

                    @Override
                    public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                        Long historyCount = CacheManager.instance.getHistoryCount(configurationId);
                        if (!historyCount.equals(label.getDefaultModelObject())) {
                            label.setDefaultModel((IModel)new Model((Serializable)historyCount));
                            return true;
                        }
                        return false;
                    }
                }});
                link.add(new Component[]{label});
                fragment.add(new Component[]{link});
                return fragment;
            }

            @Override
            public Component newHeader(String id) {
                return new Label(id, "#Builds");
            }
        });
        columns.add(new TreeTableColumn(){

            @Override
            public Component newHeader(String id) {
                return new Label(id, "Latest build");
            }

            @Override
            public Component newCell(String id, final Serializable nodeKey) {
                return new BuildInfoPanel(id, (IModel<Build>)new LoadableDetachableModel<Build>(){

                    protected Build load() {
                        return CacheManager.instance.getLatestBuild((Long)nodeKey);
                    }
                }).liteMode(true);
            }
        });
        TreeTableColumn treeColumn = new TreeTableColumn(){

            @Override
            public Component newCell(String id, Serializable nodeKey) {
                final Long configurationId = (Long)nodeKey;
                Configuration configuration = (Configuration)ConfigurationManager.instance.load(configurationId);
                Fragment fragment = new Fragment(id, "nodeFrag", (MarkupContainer)LiteDashboardPage.this);
                fragment.add(new Component[]{new ConfigurationStatusPanel("status", configuration.getId())});
                BookmarkablePageLink link = new BookmarkablePageLink("link", ConfigurationOverview.class, ConfigurationPage.params4(configuration.getId()));
                Label label = configuration.getParent() != null && !SecurityHelper.hasPermission(configuration.getParent()) ? new Label("label", configuration.getPathName()) : new Label("label", configuration.getName());
                label.setRenderBodyOnly(true);
                link.add(new Component[]{label});
                fragment.add(new Component[]{link});
                fragment.add(new Component[]{new Link<Void>("run"){

                    public void onClick() {
                        Configuration reloaded = (Configuration)ConfigurationManager.instance.load(configurationId);
                        if (VariableBeanHelper.hasPromptFields(reloaded.getVariablePromptBeanClass())) {
                            this.setResponsePage((Page)new LiteBuildOptionEdit(configurationId, new PageBack(){

                                @Override
                                public void go() {
                                    this.setResponsePage(LiteDashboardPage.class);
                                }
                            }));
                        } else {
                            BuildRequest request = new BuildRequest();
                            request.setConfigurationId(configurationId);
                            request.setRespectBuildCondition(false);
                            RequestResult result = BuildEngine.instance.requestBuild(Context.getUser(), false, request);
                            if (result.getRequestId() != null) {
                                if (reloaded.findAuditBuildRequest().booleanValue()) {
                                    AuditManager.instance.audit(reloaded, "Build was requested via lite GUI.");
                                }
                                this.getSession().info((Serializable)((Object)"Build request has been queued."));
                            } else {
                                this.getSession().warn((Serializable)((Object)result.getRejectReason()));
                            }
                            this.setResponsePage(LiteDashboardPage.class);
                        }
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        Configuration configuration = (Configuration)ConfigurationManager.instance.load(configurationId);
                        this.setVisible(!configuration.isDisabled() && SecurityHelper.hasPermission(Context.getUser(), configuration, ConfigurationPermission.RUN_BUILD.name()));
                    }
                }});
                return fragment;
            }

            @Override
            public Component newHeader(String id) {
                Fragment fragment = new Fragment(id, "headerFrag", (MarkupContainer)LiteDashboardPage.this);
                fragment.add(new Component[]{new Link<Void>("expand"){

                    public void onClick() {
                        for (Configuration configuration : BasePage.get().getConfigurations().values()) {
                            if (configuration.getParent() == null) continue;
                            LiteDashboardPage.this.getState().setExpanded(configuration.getParent().getId(), true);
                        }
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(SecurityHelper.isExpandAllAllowed());
                    }
                }});
                fragment.add(new Component[]{new Link<Void>("collapse"){

                    public void onClick() {
                        for (Configuration configuration : BasePage.get().getConfigurations().values()) {
                            LiteDashboardPage.this.getState().setExpanded(configuration.getId(), false);
                        }
                    }
                }});
                return fragment;
            }
        };
        this.add(new Component[]{new ConfigurationTreeTable("treeTable", Configuration.ROOT_ID, true, this.getState(), treeColumn, columns.toArray(new TreeTableColumn[columns.size()]))});
    }

    private TreeState getState() {
        return new TreeState(){

            @Override
            public boolean isExpanded(Serializable nodeKey) {
                return WebSession.get().getConfigurationTreeViewState().isExpanded(nodeKey);
            }

            @Override
            public void setExpanded(Serializable nodeKey, boolean expanded) {
                WebSession.get().getConfigurationTreeViewState().setExpanded(nodeKey, expanded);
            }
        };
    }

    @Override
    protected int getAjaxRefreshInterval() {
        return CacheManager.instance.getSystemSetting().getAutoRefreshInterval() * 1000;
    }
}

