/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.lite;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.RequestResult;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.BuildOptionManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.BuildOption;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.typeconverter.TypeConverterRegistry;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.PageBack;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;

public class LiteBuildOptionEdit
extends BasePage {
    private Long configurationId;
    private PageBack pageback;

    public LiteBuildOptionEdit(Long configurationId, PageBack pageback) {
        this.configurationId = configurationId;
        this.pageback = pageback;
    }

    @Override
    protected void onInitialize() {
        Object variableBean;
        BuildOption buildOption;
        super.onInitialize();
        Configuration configuration = (Configuration)ConfigurationManager.instance.load(this.configurationId);
        Class<?> variablePromptBeanClass = configuration.getVariablePromptBeanClass();
        HashMap<String, String> variableMap = null;
        if (Context.getUser() != null && (buildOption = BuildOptionManager.instance.get(Context.getUser(), configuration)) != null) {
            variableMap = buildOption.getVariables();
            for (String key : variableMap.keySet()) {
                try {
                    Method getter = BeanUtils.getGetter(variablePromptBeanClass, key);
                    if (getter.getAnnotation(Password.class) == null) continue;
                    variableMap.put(key, StringUtils.decrypt((String)variableMap.get(key)));
                }
                catch (Exception e) {}
            }
        }
        if (variableMap == null) {
            variableMap = new HashMap<String, String>();
        }
        try {
            variableBean = variablePromptBeanClass.newInstance();
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
        for (Method getter : BeanUtils.getGetters(variablePromptBeanClass)) {
            if (getter.getAnnotation(Editable.class) == null) continue;
            Method setter = BeanUtils.getSetter(getter);
            TypeConverter typeConverter = Quickbuild.getInstance(TypeConverterRegistry.class).getTypeConverter(getter);
            if (typeConverter == null) continue;
            try {
                setter.invoke(variableBean, typeConverter.toObject(getter.getReturnType(), (String)variableMap.get(BeanUtils.getPropertyName(getter))));
            }
            catch (Exception e) {}
        }
        final EditContext editContext = new EditContext(variableBean);
        Form<Void> form = new Form<Void>("form"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    Configuration configuration = (Configuration)ConfigurationManager.instance.load(LiteBuildOptionEdit.this.configurationId);
                    HashMap<String, String> variableMap = new HashMap<String, String>();
                    for (EditContext.EditableProperty property : editContext.getProperties()) {
                        variableMap.put(property.getName(), (String)property.getValue());
                    }
                    if (Context.getUser() != null) {
                        BuildOption buildOption = BuildOptionManager.instance.get(Context.getUser(), configuration);
                        if (buildOption == null) {
                            buildOption = new BuildOption();
                            buildOption.setConfiguration(configuration);
                            buildOption.setUser(Context.getUser());
                        }
                        LinkedHashMap<String, String> variableMapToSave = new LinkedHashMap<String, String>();
                        for (Map.Entry entry : variableMap.entrySet()) {
                            Method getter = BeanUtils.getGetter(editContext.getBeanClass(), (String)entry.getKey());
                            if (getter.getAnnotation(Password.class) != null) {
                                variableMapToSave.put((String)entry.getKey(), StringUtils.encrypt((String)entry.getValue()));
                                continue;
                            }
                            variableMapToSave.put((String)entry.getKey(), (String)entry.getValue());
                        }
                        buildOption.setVariables(variableMapToSave);
                        BuildOptionManager.instance.save(buildOption);
                    }
                    BuildRequest request = new BuildRequest();
                    request.setConfigurationId(LiteBuildOptionEdit.this.configurationId);
                    request.setRespectBuildCondition(false);
                    request.getVariables().putAll(variableMap);
                    RequestResult result = BuildEngine.instance.requestBuild(Context.getUser(), false, request);
                    if (result.getRequestId() != null) {
                        if (configuration.findAuditBuildRequest().booleanValue()) {
                            AuditManager.instance.audit(configuration, "Build was requested via lite GUI.");
                        }
                        this.getSession().info((Serializable)((Object)"Build request has been queued."));
                    } else {
                        this.getSession().warn((Serializable)((Object)result.getRejectReason()));
                    }
                    LiteBuildOptionEdit.this.pageback.go();
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below"));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        form.add(new Component[]{new Link<Void>("cancel"){

            public void onClick() {
                LiteBuildOptionEdit.this.pageback.go();
            }
        }});
        this.add(new Component[]{form});
    }
}

