/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid.resource;

import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ResourceManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.MainPage;
import com.pmease.quickbuild.web.page.grid.GridPage;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class ResourceEdit
extends MainPage {
    public ResourceEdit(final Resource resource) {
        this.setDefaultModel((IModel)new LoadableDetachableModel<Resource>(){

            protected Resource load() {
                if (resource.getId() != null) {
                    return (Resource)ResourceManager.instance.load(resource.getId());
                }
                return resource;
            }
        });
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        final EditContext editContext = new EditContext(this.getResource());
        Form form = new Form("form"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    String previousAuditContent = !ResourceEdit.this.getResource().isNew() ? VersionedDocument.fromBean(ResourceEdit.this.getResource()).toXML() : null;
                    String previousName = !ResourceEdit.this.getResource().isNew() ? ResourceEdit.this.getResource().getName() : null;
                    editContext.update(ResourceEdit.this.getResource());
                    Resource resourceWithSameName = ResourceManager.instance.get(ResourceEdit.this.getResource().getName());
                    if (resourceWithSameName != null && (ResourceEdit.this.getResource().isNew() || !resourceWithSameName.getId().equals(ResourceEdit.this.getResource().getId()))) {
                        editContext.getProperty("name").setError("This name is already used by another resource.");
                        this.getSession().error((Serializable)((Object)"Fix errors below."));
                        return;
                    }
                    ResourceManager.instance.save(ResourceEdit.this.getResource(), previousName);
                    if (previousAuditContent != null) {
                        AuditManager.instance.audit("Grid::Resources", "Resource '" + ResourceEdit.this.getResource().getName() + "' was modified.", VersionedDocument.fromBean(ResourceEdit.this.getResource()).toXML(), previousAuditContent);
                    } else {
                        AuditManager.instance.audit("Grid::Resources", "Resource '" + ResourceEdit.this.getResource().getName() + "' was added.");
                    }
                    this.setResponsePage(GridPage.class, GridPage.params4Resources());
                    this.getSession().info((Serializable)((Object)"Resource definition has been saved."));
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        form.add(new Component[]{new Link("cancel"){

            public void onClick() {
                this.setResponsePage(GridPage.class, GridPage.params4Resources());
            }
        }});
        this.add(new Component[]{form});
    }

    private Resource getResource() {
        return (Resource)this.getDefaultModelObject();
    }
}

