/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid.resource;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.component.build.BuildLink;
import com.pmease.quickbuild.web.component.configuration.ConfigurationLink;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class NodeResourcesPanel
extends Panel {
    private IModel<List<BuildRequest>> buildRequestsModel = new LoadableDetachableModel<List<BuildRequest>>(){

        protected List<BuildRequest> load() {
            return BuildEngine.instance.getBuildRequests(null);
        }
    };

    public NodeResourcesPanel(String panelId, IModel<GridNode> nodeModel) {
        super(panelId, nodeModel);
        final ArrayList<ResourceCount> resourceCounts = new ArrayList<ResourceCount>();
        for (Resource resource : CacheManager.instance.getResources()) {
            int count = resource.getCount(this.getNode());
            if (count == 0) continue;
            ResourceCount resourceCount = new ResourceCount();
            resourceCount.setCount(count);
            resourceCount.setResource(resource);
            resourceCounts.add(resourceCount);
        }
        ArrayList<AbstractColumn> columns = new ArrayList<AbstractColumn>();
        columns.add(new AbstractColumn<ResourceCount>((IModel)new Model((Serializable)((Object)"Name"))){

            public void populateItem(Item<ICellPopulator<ResourceCount>> cellItem, String componentId, IModel<ResourceCount> rowModel) {
                ResourceCount resourceCount = (ResourceCount)rowModel.getObject();
                cellItem.add(new Component[]{new Label(componentId, resourceCount.getResource().getName())});
            }
        });
        columns.add(new AbstractColumn<ResourceCount>((IModel)new Model((Serializable)((Object)"#Available"))){

            public void populateItem(Item<ICellPopulator<ResourceCount>> cellItem, String componentId, IModel<ResourceCount> rowModel) {
                ResourceCount resourceCount = (ResourceCount)rowModel.getObject();
                int usageCount = 0;
                for (BuildRequest request : NodeResourcesPanel.this.getBuildRequests()) {
                    Build build = request.getBuild();
                    for (Map.Entry<String, StepRuntime> entry : build.getStepRuntimes().entrySet()) {
                        Integer count;
                        String nodeAddress = entry.getValue().getNodeAddress();
                        if (!NodeResourcesPanel.this.getNode().getAddress().equals(nodeAddress) || (count = entry.getValue().getResources().get(resourceCount.getResource().getName())) == null) continue;
                        usageCount += count.intValue();
                    }
                }
                int availableCount = resourceCount.getCount() - usageCount;
                if (availableCount < 0) {
                    availableCount = 0;
                }
                cellItem.add(new Component[]{new Label(componentId, String.valueOf(availableCount))});
            }
        });
        columns.add(new AbstractColumn<ResourceCount>((IModel)new Model((Serializable)((Object)"#Used"))){

            public void populateItem(Item<ICellPopulator<ResourceCount>> cellItem, String componentId, IModel<ResourceCount> rowModel) {
                Resource resource = ((ResourceCount)rowModel.getObject()).getResource();
                final ArrayList<ResourceUsage> usages = new ArrayList<ResourceUsage>();
                int usageCount = 0;
                for (BuildRequest request : NodeResourcesPanel.this.getBuildRequests()) {
                    Build build = request.getBuild();
                    for (Map.Entry<String, StepRuntime> entry : build.getStepRuntimes().entrySet()) {
                        Integer count;
                        StepRuntime runtime = entry.getValue();
                        if (runtime.getStatus() != StepRuntime.Status.RUNNING) continue;
                        String nodeAddress = runtime.getNodeAddress();
                        if (!NodeResourcesPanel.this.getNode().getAddress().equals(nodeAddress) || (count = runtime.getResources().get(resource.getName())) == null || count == 0) continue;
                        ResourceUsage usage = new ResourceUsage();
                        usage.setRequest(request);
                        usage.setResourceCount(count);
                        usage.setStepPath(StepPath.fromString(entry.getKey()));
                        usages.add(usage);
                        usageCount += count.intValue();
                    }
                }
                Fragment fragment = new Fragment(componentId, "usedColumn", (MarkupContainer)NodeResourcesPanel.this);
                fragment.add(new Component[]{new Label("count", String.valueOf(usageCount))});
                fragment.add(new Component[]{new WebMarkupContainer("popupTrigger").add(new Behavior[]{new PopupBehavior(){

                    @Override
                    protected Component getPopup(String componentId) {
                        Fragment fragment = new Fragment(componentId, "usedPopup", (MarkupContainer)NodeResourcesPanel.this);
                        ArrayList<AbstractColumn> columns = new ArrayList<AbstractColumn>();
                        columns.add(new AbstractColumn<ResourceUsage>((IModel)new Model((Serializable)((Object)"Configuration"))){

                            public void populateItem(Item<ICellPopulator<ResourceUsage>> cellItem, String componentId, final IModel<ResourceUsage> rowModel) {
                                cellItem.add(new Component[]{new ConfigurationLink(componentId, (IModel<Configuration>)new AbstractReadOnlyModel<Configuration>(){

                                    public Configuration getObject() {
                                        return ((ResourceUsage)rowModel.getObject()).getRequest().getBuild().getConfiguration();
                                    }
                                })});
                            }
                        });
                        columns.add(new AbstractColumn<ResourceUsage>((IModel)new Model((Serializable)((Object)"Build"))){

                            public void populateItem(Item<ICellPopulator<ResourceUsage>> cellItem, String componentId, final IModel<ResourceUsage> rowModel) {
                                ResourceUsage usage = (ResourceUsage)rowModel.getObject();
                                if (usage.getRequest().getBuild().getId() != null) {
                                    cellItem.add(new Component[]{new BuildLink(componentId, (IModel<Build>)new LoadableDetachableModel<Build>(){

                                        protected Build load() {
                                            return ((ResourceUsage)rowModel.getObject()).getRequest().getBuild();
                                        }
                                    })});
                                } else {
                                    cellItem.add(new Component[]{new Label(componentId, "<i>Not generated yet</i>").setEscapeModelStrings(false)});
                                }
                            }
                        });
                        columns.add(new AbstractColumn<ResourceUsage>((IModel)new Model((Serializable)((Object)"Step"))){

                            public void populateItem(Item<ICellPopulator<ResourceUsage>> cellItem, String componentId, IModel<ResourceUsage> rowModel) {
                                ResourceUsage usage = (ResourceUsage)rowModel.getObject();
                                cellItem.add(new Component[]{new Label(componentId, usage.getStepPath().toString())});
                            }
                        });
                        columns.add(new AbstractColumn<ResourceUsage>((IModel)new Model((Serializable)((Object)"Count"))){

                            public void populateItem(Item<ICellPopulator<ResourceUsage>> cellItem, String componentId, IModel<ResourceUsage> rowModel) {
                                ResourceUsage usage = (ResourceUsage)rowModel.getObject();
                                cellItem.add(new Component[]{new Label(componentId, String.valueOf(usage.getResourceCount()))});
                            }
                        });
                        DataProvider<ResourceUsage> dataProvider = new DataProvider<ResourceUsage>(){

                            public Iterator<? extends ResourceUsage> iterator(int first, int count) {
                                return usages.iterator();
                            }

                            public int size() {
                                return usages.size();
                            }
                        };
                        fragment.add(new Component[]{new DefaultDataTable("steps", columns, (ISortableDataProvider)dataProvider, 25)});
                        return fragment;
                    }
                }.hoverMode(true)})});
                cellItem.add(new Component[]{fragment});
            }
        });
        this.add(new Component[]{new DefaultDataTable("resources", columns, (ISortableDataProvider)new DataProvider<ResourceCount>(){

            public Iterator<? extends ResourceCount> iterator(int first, int count) {
                return resourceCounts.iterator();
            }

            public int size() {
                return resourceCounts.size();
            }
        }, 25)});
    }

    private GridNode getNode() {
        return (GridNode)this.getDefaultModelObject();
    }

    private List<BuildRequest> getBuildRequests() {
        return (List)this.buildRequestsModel.getObject();
    }

    protected void detachModel() {
        this.buildRequestsModel.detach();
        super.detachModel();
    }

    private static class ResourceUsage
    implements Serializable {
        private BuildRequest request;
        private StepPath stepPath;
        private int resourceCount;

        private ResourceUsage() {
        }

        public BuildRequest getRequest() {
            return this.request;
        }

        public void setRequest(BuildRequest request) {
            this.request = request;
        }

        public StepPath getStepPath() {
            return this.stepPath;
        }

        public void setStepPath(StepPath stepPath) {
            this.stepPath = stepPath;
        }

        public int getResourceCount() {
            return this.resourceCount;
        }

        public void setResourceCount(int resourceCount) {
            this.resourceCount = resourceCount;
        }
    }

    private static class ResourceCount
    implements Serializable {
        private Resource resource;
        private int count;

        private ResourceCount() {
        }

        public Resource getResource() {
            return this.resource;
        }

        public void setResource(Resource resource) {
            this.resource = resource;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

