/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid.resource;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.entitymanager.ResourceAccessManager;
import com.pmease.quickbuild.entitymanager.ResourceManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.model.ResourceAccess;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.component.TextLink;
import com.pmease.quickbuild.web.component.build.BuildLink;
import com.pmease.quickbuild.web.component.configuration.ConfigurationLink;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import com.pmease.quickbuild.web.component.datatablesupport.EntityColumn;
import com.pmease.quickbuild.web.component.datatablesupport.EntityProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.component.viewer.PropertyViewer;
import com.pmease.quickbuild.web.component.viewer.ViewContext;
import com.pmease.quickbuild.web.page.grid.GridPage;
import com.pmease.quickbuild.web.page.grid.resource.ResourceEdit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NavigationToolbar;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridResourcesPanel
extends Panel {
    private static final Logger logger = LoggerFactory.getLogger(GridResourcesPanel.class);
    private SelectionColumn<Long> selectionColumn = new SelectionColumn();

    public GridResourcesPanel(String id) {
        super(id);
        this.setDefaultModel((IModel)new LoadableDetachableModel<Map<String, BuildRequest>>(){

            protected Map<String, BuildRequest> load() {
                LinkedHashMap<String, BuildRequest> requests = new LinkedHashMap<String, BuildRequest>();
                for (BuildRequest request : BuildEngine.instance.getBuildRequests(null)) {
                    requests.put(request.getId(), request);
                }
                return requests;
            }
        });
    }

    protected void onInitialize() {
        super.onInitialize();
        WebMarkupContainer actionsTrigger = new WebMarkupContainer("actions");
        actionsTrigger.setVisible(SecurityHelper.isAdmin());
        this.add(new Component[]{actionsTrigger});
        actionsTrigger.add(new Behavior[]{new MenuBehavior(){

            @Override
            protected List<MenuItem> getMenuItems() {
                ArrayList<MenuItem> items = new ArrayList<MenuItem>();
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Define New Resource"))){

                            public void onClick() {
                                this.setResponsePage((Page)new ResourceEdit(new Resource()));
                            }
                        };
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Delete Selected Resources"))){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void onClick() {
                                Session session = SessionManager.openSession();
                                try {
                                    Transaction tx = session.beginTransaction();
                                    try {
                                        for (Long resourceId : GridResourcesPanel.this.selectionColumn.getSelections()) {
                                            Resource resource = (Resource)ResourceManager.instance.load(resourceId);
                                            ResourceManager.instance.delete(resource);
                                            AuditManager.instance.audit("Grid::Resources", "Resource " + resource.getName() + " was deleted.");
                                        }
                                        GridResourcesPanel.this.selectionColumn.getSelections().clear();
                                        SessionManager.getSession().flush();
                                        tx.commit();
                                    }
                                    catch (Throwable t) {
                                        tx.rollback();
                                    }
                                }
                                finally {
                                    SessionManager.closeSession();
                                }
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete selected resources?")});
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Delete All Resources"))){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void onClick() {
                                Session session = SessionManager.openSession();
                                try {
                                    Transaction tx = session.beginTransaction();
                                    try {
                                        for (Resource resource : ResourceManager.instance.getAll()) {
                                            ResourceManager.instance.delete(resource);
                                        }
                                        AuditManager.instance.audit("Grid::Resources", "All resources were deleted.");
                                        GridResourcesPanel.this.selectionColumn.getSelections().clear();
                                        SessionManager.getSession().flush();
                                        tx.commit();
                                    }
                                    catch (Throwable t) {
                                        tx.rollback();
                                    }
                                }
                                finally {
                                    SessionManager.closeSession();
                                }
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete all resources?")});
                    }
                });
                return items;
            }
        }});
        ArrayList<Object> columns = new ArrayList<Object>();
        if (SecurityHelper.isAdmin()) {
            columns.add(this.selectionColumn);
        }
        columns.add(new EntityColumn(Resource.class, "name", true){

            @Override
            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, final IModel<Long> rowModel) {
                final Resource resource = (Resource)ResourceManager.instance.load((Long)rowModel.getObject());
                Fragment fragment = new Fragment(componentId, "resourceFrag", (MarkupContainer)GridResourcesPanel.this);
                fragment.add(new Component[]{new Label("name", resource.getName())});
                fragment.add(new Component[]{new Link<Void>("edit"){

                    public void onClick() {
                        this.setResponsePage((Page)new ResourceEdit(resource));
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(SecurityHelper.isAdmin());
                    }
                }});
                fragment.add(new Component[]{new Link<Void>("copy"){

                    public void onClick() {
                        Resource newResource = (Resource)ResourceManager.instance.load((Long)rowModel.getObject());
                        newResource.setId(null);
                        this.setResponsePage((Page)new ResourceEdit(newResource));
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(SecurityHelper.isAdmin());
                    }
                }});
                cellItem.add(new Component[]{fragment});
            }
        });
        columns.add(new EntityColumn(Resource.class, "description", false));
        columns.add(new AbstractColumn<Long>((IModel)new Model((Serializable)((Object)"Providers"))){

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                Resource resource = (Resource)ResourceManager.instance.load((Long)rowModel.getObject());
                ViewContext context = new ViewContext(resource);
                cellItem.add(new Component[]{new PropertyViewer(componentId, context.getBeanClass(), context.getProperty("providers"))});
            }
        });
        final HashMap usedResourceCounts = new HashMap();
        columns.add(new AbstractColumn<Long>((IModel)new Model((Serializable)((Object)"#Available"))){

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, final IModel<Long> rowModel) {
                try {
                    Resource resource = (Resource)ResourceManager.instance.load((Long)rowModel.getObject());
                    int totalDefined = 0;
                    for (GridNode node : Grid.instance.getAllNodes()) {
                        totalDefined += resource.getCount(node);
                    }
                    int totalUsed = 0;
                    for (BuildRequest request : GridResourcesPanel.this.getBuildRequests().values()) {
                        Build build = request.getBuild();
                        for (StepRuntime runtime : build.getStepRuntimes().values()) {
                            Integer used;
                            if (runtime.getStatus() != StepRuntime.Status.RUNNING || (used = runtime.getResources().get(resource.getName())) == null) continue;
                            totalUsed += used.intValue();
                        }
                    }
                    usedResourceCounts.put(resource.getId(), totalUsed);
                    int totalAvailable = totalDefined - totalUsed;
                    if (totalAvailable < 0) {
                        totalAvailable = 0;
                    }
                    Fragment fragment = new Fragment(componentId, "availableColumn", (MarkupContainer)GridResourcesPanel.this);
                    fragment.add(new Component[]{new Label("count", String.valueOf(totalAvailable))});
                    fragment.add(new Component[]{new WebMarkupContainer("popupTrigger").add(new Behavior[]{new PopupBehavior(){

                        @Override
                        protected Component getPopup(String componentId) {
                            Fragment fragment = new Fragment(componentId, "availablePopup", (MarkupContainer)GridResourcesPanel.this);
                            ArrayList<AbstractColumn> columns = new ArrayList<AbstractColumn>();
                            columns.add(new AbstractColumn<Pair<String, Integer>>((IModel)new Model((Serializable)((Object)"Node"))){

                                public void populateItem(Item<ICellPopulator<Pair<String, Integer>>> cellItem, String componentId, IModel<Pair<String, Integer>> rowModel) {
                                    Fragment fragment = new Fragment(componentId, "nodeLinkFrag", (MarkupContainer)GridResourcesPanel.this);
                                    Pair pair = (Pair)rowModel.getObject();
                                    BookmarkablePageLink link = new BookmarkablePageLink("link", GridPage.class, GridPage.params4((String)pair.getFirst()));
                                    link.add(new Component[]{new Label("label", (String)pair.getFirst())});
                                    fragment.add(new Component[]{link});
                                    cellItem.add(new Component[]{fragment});
                                }
                            });
                            columns.add(new AbstractColumn<Pair<String, Integer>>((IModel)new Model((Serializable)((Object)"Count"))){

                                public void populateItem(Item<ICellPopulator<Pair<String, Integer>>> cellItem, String componentId, IModel<Pair<String, Integer>> rowModel) {
                                    Pair pair = (Pair)rowModel.getObject();
                                    cellItem.add(new Component[]{new Label(componentId, ((Integer)pair.getSecond()).toString())});
                                }
                            });
                            Resource resource = (Resource)ResourceManager.instance.load((Long)rowModel.getObject());
                            final HashMap<String, Integer> nodeCounts = new HashMap<String, Integer>();
                            for (GridNode node : Grid.instance.getAllNodes()) {
                                nodeCounts.put(node.getAddress(), resource.getCount(node));
                            }
                            for (BuildRequest request : GridResourcesPanel.this.getBuildRequests().values()) {
                                Build build = request.getBuild();
                                for (StepRuntime runtime : build.getStepRuntimes().values()) {
                                    Integer usedCount;
                                    if (runtime.getStatus() != StepRuntime.Status.RUNNING) continue;
                                    Integer count = (Integer)nodeCounts.get(runtime.getNodeAddress());
                                    if (count == null) {
                                        count = 0;
                                    }
                                    if ((usedCount = runtime.getResources().get(resource.getName())) != null) {
                                        count = count - usedCount;
                                    }
                                    nodeCounts.put(runtime.getNodeAddress(), count);
                                }
                            }
                            Iterator it = nodeCounts.entrySet().iterator();
                            while (it.hasNext()) {
                                if ((Integer)it.next().getValue() != 0) continue;
                                it.remove();
                            }
                            DataProvider<Pair<String, Integer>> dataProvider = new DataProvider<Pair<String, Integer>>(){

                                public Iterator<? extends Pair<String, Integer>> iterator(int first, int count) {
                                    ArrayList pairs = new ArrayList();
                                    for (Map.Entry entry : nodeCounts.entrySet()) {
                                        pairs.add(new Pair(entry.getKey(), entry.getValue()));
                                    }
                                    return pairs.subList(first, first + count).iterator();
                                }

                                public int size() {
                                    return nodeCounts.size();
                                }
                            };
                            fragment.add(new Component[]{new AjaxFallbackDefaultDataTable("instances", columns, (ISortableDataProvider)dataProvider, 25)});
                            return fragment;
                        }
                    }.hoverMode(true)})});
                    cellItem.add(new Component[]{fragment});
                }
                catch (Exception e) {
                    cellItem.add(new Component[]{new Label(componentId, "<span class='red'>Error calcuating. Check server log for details.</span>").setEscapeModelStrings(false)});
                    logger.error("Error calculating available resources.", (Throwable)e);
                }
            }
        });
        columns.add(new AbstractColumn<Long>((IModel)new Model((Serializable)((Object)"#Used"))){

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, final IModel<Long> rowModel) {
                Fragment fragment = new Fragment(componentId, "usedColumn", (MarkupContainer)GridResourcesPanel.this);
                fragment.add(new Component[]{new Label("count", String.valueOf(usedResourceCounts.get(rowModel.getObject())))});
                fragment.add(new Component[]{new WebMarkupContainer("popupTrigger").add(new Behavior[]{new PopupBehavior(){

                    @Override
                    protected Component getPopup(String componentId) {
                        Resource resource = (Resource)ResourceManager.instance.load((Long)rowModel.getObject());
                        final ArrayList<ResourceUsage> usages = new ArrayList<ResourceUsage>();
                        for (BuildRequest request : GridResourcesPanel.this.getBuildRequests().values()) {
                            Build build = request.getBuild();
                            for (Map.Entry<String, StepRuntime> entry : build.getStepRuntimes().entrySet()) {
                                StepRuntime runtime = entry.getValue();
                                if (runtime.getStatus() != StepRuntime.Status.RUNNING) continue;
                                String nodeAddress = runtime.getNodeAddress();
                                Validate.notNull((Object)nodeAddress);
                                Integer count = runtime.getResources().get(resource.getName());
                                if (count == null || count == 0) continue;
                                ResourceUsage usage = new ResourceUsage();
                                usage.setNodeAddress(nodeAddress);
                                usage.setRequestId(request.getId());
                                usage.setResourceCount(count);
                                usage.setStepPath(StepPath.fromString(entry.getKey()));
                                usages.add(usage);
                            }
                        }
                        Fragment fragment = new Fragment(componentId, "usedPopup", (MarkupContainer)GridResourcesPanel.this);
                        ArrayList<AbstractColumn> columns = new ArrayList<AbstractColumn>();
                        columns.add(new AbstractColumn<ResourceUsage>((IModel)new Model((Serializable)((Object)"Configuration"))){

                            public void populateItem(Item<ICellPopulator<ResourceUsage>> cellItem, String componentId, final IModel<ResourceUsage> rowModel) {
                                cellItem.add(new Component[]{new ConfigurationLink(componentId, (IModel<Configuration>)new AbstractReadOnlyModel<Configuration>(){

                                    public Configuration getObject() {
                                        BuildRequest request = (BuildRequest)GridResourcesPanel.this.getBuildRequests().get(((ResourceUsage)rowModel.getObject()).getRequestId());
                                        return request.getBuild().getConfiguration();
                                    }
                                })});
                            }
                        });
                        columns.add(new AbstractColumn<ResourceUsage>((IModel)new Model((Serializable)((Object)"Build"))){

                            public void populateItem(Item<ICellPopulator<ResourceUsage>> cellItem, String componentId, final IModel<ResourceUsage> rowModel) {
                                ResourceUsage usage = (ResourceUsage)rowModel.getObject();
                                BuildRequest request = (BuildRequest)GridResourcesPanel.this.getBuildRequests().get(usage.getRequestId());
                                if (request.getBuild().getId() != null) {
                                    cellItem.add(new Component[]{new BuildLink(componentId, (IModel<Build>)new LoadableDetachableModel<Build>(){

                                        protected Build load() {
                                            ResourceUsage usage = (ResourceUsage)rowModel.getObject();
                                            BuildRequest request = (BuildRequest)GridResourcesPanel.this.getBuildRequests().get(usage.getRequestId());
                                            return request.getBuild();
                                        }
                                    })});
                                } else {
                                    cellItem.add(new Component[]{new Label(componentId, "<i>Not generated yet</i>").setEscapeModelStrings(false)});
                                }
                            }
                        });
                        columns.add(new AbstractColumn<ResourceUsage>((IModel)new Model((Serializable)((Object)"Step"))){

                            public void populateItem(Item<ICellPopulator<ResourceUsage>> cellItem, String componentId, IModel<ResourceUsage> rowModel) {
                                ResourceUsage usage = (ResourceUsage)rowModel.getObject();
                                cellItem.add(new Component[]{new Label(componentId, usage.getStepPath().toString())});
                            }
                        });
                        columns.add(new AbstractColumn<ResourceUsage>((IModel)new Model((Serializable)((Object)"Node"))){

                            public void populateItem(Item<ICellPopulator<ResourceUsage>> cellItem, String componentId, IModel<ResourceUsage> rowModel) {
                                Fragment fragment = new Fragment(componentId, "nodeLinkFrag", (MarkupContainer)GridResourcesPanel.this);
                                ResourceUsage usage = (ResourceUsage)rowModel.getObject();
                                BookmarkablePageLink link = new BookmarkablePageLink("link", GridPage.class, GridPage.params4(usage.getNodeAddress()));
                                link.add(new Component[]{new Label("label", usage.getNodeAddress())});
                                fragment.add(new Component[]{link});
                                cellItem.add(new Component[]{fragment});
                            }
                        });
                        columns.add(new AbstractColumn<ResourceUsage>((IModel)new Model((Serializable)((Object)"Count"))){

                            public void populateItem(Item<ICellPopulator<ResourceUsage>> cellItem, String componentId, IModel<ResourceUsage> rowModel) {
                                ResourceUsage usage = (ResourceUsage)rowModel.getObject();
                                cellItem.add(new Component[]{new Label(componentId, String.valueOf(usage.getResourceCount()))});
                            }
                        });
                        DataProvider<ResourceUsage> dataProvider = new DataProvider<ResourceUsage>(){

                            public Iterator<? extends ResourceUsage> iterator(int first, int count) {
                                return usages.subList(first, first + count).iterator();
                            }

                            public int size() {
                                return usages.size();
                            }
                        };
                        fragment.add(new Component[]{new AjaxFallbackDefaultDataTable("steps", columns, (ISortableDataProvider)dataProvider, 25)});
                        return fragment;
                    }
                }.hoverMode(true)})});
                cellItem.add(new Component[]{fragment});
            }
        });
        columns.add(new AbstractColumn<Long>((IModel)new Model((Serializable)((Object)"Access Info"))){

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, final IModel<Long> rowModel) {
                Fragment fragment = new Fragment(componentId, "accessColumn", (MarkupContainer)GridResourcesPanel.this);
                Long resourceId = (Long)rowModel.getObject();
                Date date = CacheManager.instance.getLastAccessTimeOfResource(resourceId);
                if (date != null) {
                    fragment.add(new Component[]{new Label("date", "Last Access " + DateUtils.formatDate(date))});
                    fragment.add(new Component[]{new WebMarkupContainer("popupTrigger").add(new Behavior[]{new PopupBehavior(){

                        @Override
                        protected Component getPopup(String componentId) {
                            final Resource resource = (Resource)ResourceManager.instance.load((Long)rowModel.getObject());
                            ArrayList<EntityColumn> columns = new ArrayList<EntityColumn>();
                            columns.add(new EntityColumn(ResourceAccess.class, "configuration", true){

                                @Override
                                public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                                    ResourceAccess access = (ResourceAccess)ResourceAccessManager.instance.load((Long)rowModel.getObject());
                                    final Long configurationId = access.getConfiguration().getId();
                                    cellItem.add(new Component[]{new ConfigurationLink(componentId, (IModel<Configuration>)new LoadableDetachableModel<Configuration>(){

                                        protected Configuration load() {
                                            return (Configuration)ConfigurationManager.instance.load(configurationId);
                                        }
                                    })});
                                }
                            });
                            columns.add(new EntityColumn(ResourceAccess.class, "steps", false){

                                @Override
                                public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                                    ResourceAccess access = (ResourceAccess)ResourceAccessManager.instance.load((Long)rowModel.getObject());
                                    cellItem.add(new Component[]{new Label(componentId, StringUtils.join(access.getSteps(), (String)", "))});
                                }
                            });
                            columns.add(new EntityColumn(ResourceAccess.class, "when", true){

                                @Override
                                public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                                    ResourceAccess access = (ResourceAccess)ResourceAccessManager.instance.load((Long)rowModel.getObject());
                                    cellItem.add(new Component[]{new Label(componentId, DateUtils.formatDate(access.getWhen()))});
                                }
                            });
                            columns.add(new EntityColumn(ResourceAccess.class, "duration", true){

                                @Override
                                public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                                    ResourceAccess access = (ResourceAccess)ResourceAccessManager.instance.load((Long)rowModel.getObject());
                                    cellItem.add(new Component[]{new Label(componentId, DateUtils.formatDuration(access.getDuration()))});
                                }
                            });
                            AjaxFallbackDefaultDataTable dataTable = new AjaxFallbackDefaultDataTable("accesses", columns, (ISortableDataProvider)new EntityProvider(ResourceAccess.class, new SortParam("when", false)){

                                @Override
                                protected Criterion[] getCriterions() {
                                    return new Criterion[]{Restrictions.eq((String)"resource", (Object)resource)};
                                }
                            }, 25);
                            Fragment fragment = new Fragment(componentId, "accessPopup", (MarkupContainer)GridResourcesPanel.this);
                            fragment.add(new Component[]{dataTable});
                            return fragment;
                        }
                    }.hoverMode(true)})});
                } else {
                    fragment.add(new Component[]{new Label("date", "<i>Not Accessed Yet</i>").setEscapeModelStrings(false)});
                    fragment.add(new Component[]{new WebMarkupContainer("popupTrigger").setVisible(false)});
                }
                cellItem.add(new Component[]{fragment});
            }
        });
        DefaultDataTable dataTable = new DefaultDataTable("resources", columns, (ISortableDataProvider)new EntityProvider(Resource.class, new SortParam("name", true)){

            @Override
            protected Criterion[] getCriterions() {
                return new Criterion[0];
            }
        }, 25);
        dataTable.addBottomToolbar((AbstractToolbar)new NavigationToolbar((DataTable)dataTable));
        this.add(new Component[]{dataTable});
    }

    private Map<String, BuildRequest> getBuildRequests() {
        return (Map)this.getDefaultModelObject();
    }

    private static class ResourceUsage
    implements Serializable {
        private String requestId;
        private StepPath stepPath;
        private String nodeAddress;
        private int resourceCount;

        private ResourceUsage() {
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public StepPath getStepPath() {
            return this.stepPath;
        }

        public void setStepPath(StepPath stepPath) {
            this.stepPath = stepPath;
        }

        public String getNodeAddress() {
            return this.nodeAddress;
        }

        public void setNodeAddress(String nodeAddress) {
            this.nodeAddress = nodeAddress;
        }

        public int getResourceCount() {
            return this.resourceCount;
        }

        public void setResourceCount(int resourceCount) {
            this.resourceCount = resourceCount;
        }
    }
}

