/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid.cloud;

import com.pmease.quickbuild.Property;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class TestAttributesPanel
extends Panel {
    public TestAttributesPanel(String panelId, Map<String, String> attributes) {
        super(panelId);
        this.add(new Component[]{new WebMarkupContainer("info").setVisible(attributes != null)});
        this.add(new Component[]{new WebMarkupContainer("warn").setVisible(attributes == null)});
        final ArrayList<Property> properties = new ArrayList<Property>();
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                properties.add(new Property(entry.getKey(), entry.getValue()));
            }
        }
        this.add(new Component[]{new ListView<Property>("properties", (IModel)new LoadableDetachableModel<List<Property>>(){

            protected List<Property> load() {
                Collections.sort(properties, new Comparator<Property>(){

                    @Override
                    public int compare(Property prop1, Property prop2) {
                        return prop1.getName().compareTo(prop2.getName());
                    }
                });
                return properties;
            }
        }){

            protected void populateItem(ListItem<Property> item) {
                Property property = (Property)item.getModelObject();
                item.add(new Component[]{new Label("name", property.getName())});
                item.add(new Component[]{new Label("value", property.getValue())});
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(properties != null);
            }
        }});
    }
}

