/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid.cloud;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.CloudProfileManager;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.model.Token;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.component.BookmarkableTextLink;
import com.pmease.quickbuild.web.component.TextLink;
import com.pmease.quickbuild.web.component.datatablesupport.EntityColumn;
import com.pmease.quickbuild.web.component.datatablesupport.EntityDataTable;
import com.pmease.quickbuild.web.component.datatablesupport.FilterableEntityProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.page.grid.GridPage;
import com.pmease.quickbuild.web.page.grid.cloud.CloudProfileEdit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackHeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class CloudProfilesOverview
extends Panel {
    private SelectionColumn<Long> selectionColumn;

    public CloudProfilesOverview(String panelId) {
        super(panelId);
        this.setDefaultModel((IModel)new LoadableDetachableModel<List<CloudProfile>>(){

            protected List<CloudProfile> load() {
                return CloudProfileManager.instance.getAll();
            }
        });
        WebMarkupContainer actionsTrigger = new WebMarkupContainer("actions");
        actionsTrigger.setVisible(SecurityHelper.isAdmin());
        this.add(new Component[]{actionsTrigger});
        actionsTrigger.add(new Behavior[]{new MenuBehavior(){

            @Override
            protected List<MenuItem> getMenuItems() {
                ArrayList<MenuItem> items = new ArrayList<MenuItem>();
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Add New Cloud Profile"))){

                            public void onClick() {
                                CloudProfilesOverview.this.replaceWith((Component)((Object)new CloudProfileEdit(CloudProfilesOverview.this.getId(), new CloudProfile(), null)));
                            }
                        };
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Run Test Launch for Selected Profiles"))){

                            public void onClick() {
                                if (!CloudProfilesOverview.this.selectionColumn.getSelections().isEmpty()) {
                                    for (Long profileId : CloudProfilesOverview.this.selectionColumn.getSelections()) {
                                        CloudProfile profile = (CloudProfile)CloudProfileManager.instance.load(profileId);
                                        CloudProfileManager.instance.testLaunch(profile);
                                    }
                                    CloudProfilesOverview.this.selectionColumn.getSelections().clear();
                                } else {
                                    this.getSession().warn((Serializable)((Object)"Please select cloud profiles to run test launch."));
                                }
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to run test launch for selected cloud profiles?")});
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Delete Selected Cloud Profiles"))){

                            public void onClick() {
                                ArrayList<String> notDeleted = new ArrayList<String>();
                                HashSet<String> nodeAddressesInUse = new HashSet<String>();
                                for (BuildRequest request : BuildEngine.instance.getBuildRequests(null)) {
                                    for (StepRuntime runtime : request.getBuild().getStepRuntimes().values()) {
                                        if (runtime.getStatus() != StepRuntime.Status.RUNNING) continue;
                                        nodeAddressesInUse.add(runtime.getNodeAddress());
                                    }
                                }
                                if (!CloudProfilesOverview.this.selectionColumn.getSelections().isEmpty()) {
                                    for (Long profileId : CloudProfilesOverview.this.selectionColumn.getSelections()) {
                                        CloudProfile profile = (CloudProfile)CloudProfileManager.instance.load(profileId);
                                        boolean found = false;
                                        for (Token token : profile.getTokens()) {
                                            if (!nodeAddressesInUse.contains(token.getAddress())) continue;
                                            found = true;
                                            break;
                                        }
                                        if (found) {
                                            notDeleted.add(profile.getName());
                                            continue;
                                        }
                                        CloudProfileManager.instance.delete(profile);
                                        AuditManager.instance.audit("Grid::Cloud Profiles", "Cloud profile " + profile.getName() + " was deleted.");
                                    }
                                    CloudProfilesOverview.this.selectionColumn.getSelections().clear();
                                    if (!notDeleted.isEmpty()) {
                                        this.getSession().warn((Serializable)((Object)("Unable to delete profiles '" + StringUtils.join(notDeleted) + "' as some of their launched nodes are still being used by builds.")));
                                    }
                                } else {
                                    this.getSession().warn((Serializable)((Object)"Please select cloud profiles to delete."));
                                }
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("This will also terminate all associated nodes with these profiles. Do you really want to delete selected cloud profiles?")});
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Run Test Launch for All Profiles"))){

                            public void onClick() {
                                for (CloudProfile profile : CloudProfilesOverview.this.getCloudProfiles()) {
                                    CloudProfileManager.instance.testLaunch(profile);
                                }
                                CloudProfilesOverview.this.getDefaultModel().detach();
                                CloudProfilesOverview.this.selectionColumn.getSelections().clear();
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to run test launch for all cloud profiles?")});
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Delete All Cloud Profiles"))){

                            public void onClick() {
                                ArrayList<String> notDeleted = new ArrayList<String>();
                                HashSet<String> nodeAddressesInUse = new HashSet<String>();
                                for (BuildRequest request : BuildEngine.instance.getBuildRequests(null)) {
                                    for (StepRuntime runtime : request.getBuild().getStepRuntimes().values()) {
                                        if (runtime.getStatus() != StepRuntime.Status.RUNNING) continue;
                                        nodeAddressesInUse.add(runtime.getNodeAddress());
                                    }
                                }
                                for (CloudProfile profile : CloudProfilesOverview.this.getCloudProfiles()) {
                                    boolean found = false;
                                    for (Token token : profile.getTokens()) {
                                        if (!nodeAddressesInUse.contains(token.getAddress())) continue;
                                        found = true;
                                        break;
                                    }
                                    if (found) {
                                        notDeleted.add(profile.getName());
                                        continue;
                                    }
                                    CloudProfileManager.instance.delete(profile);
                                    AuditManager.instance.audit("Grid::Cloud Profiles", "Cloud profile " + profile.getName() + " was deleted.");
                                }
                                if (!notDeleted.isEmpty()) {
                                    this.getSession().warn((Serializable)((Object)("Unable to delete profiles '" + StringUtils.join(notDeleted) + "' as some of their launched nodes are still being used by builds.")));
                                }
                                CloudProfilesOverview.this.getDefaultModel().detach();
                                CloudProfilesOverview.this.selectionColumn.getSelections().clear();
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("This will also terminate all launched nodes associated with these profiles. Do you really want to delete all cloud profiles?")});
                    }
                });
                return items;
            }
        }});
        ArrayList<IColumn<Long>> columns = new ArrayList<IColumn<Long>>();
        if (SecurityHelper.isAdmin()) {
            this.selectionColumn = new SelectionColumn();
            columns.add((IColumn<Long>)this.selectionColumn);
        }
        columns.add((IColumn<Long>)new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"name"))){

            public void populateItem(Item<ICellPopulator<Long>> item, String componentId, IModel<Long> rowModel) {
                CloudProfile profile = (CloudProfile)CloudProfileManager.instance.load((Long)rowModel.getObject());
                Fragment fragment = new Fragment(componentId, "linkFrag", (MarkupContainer)CloudProfilesOverview.this);
                fragment.add(new Component[]{new BookmarkableTextLink("link", profile.getName(), GridPage.class, GridPage.params4Profile(profile.getId()))});
                item.add(new Component[]{fragment});
            }

            public String getSortProperty() {
                return "name";
            }

            public boolean isSortable() {
                return true;
            }
        });
        columns.add((IColumn<Long>)new EntityColumn(CloudProfile.class, "maxNodesToLaunch", true));
        columns.add((IColumn<Long>)new EntityColumn(CloudProfile.class, "idleTimeToTerminate", true));
        columns.add((IColumn<Long>)new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"Test Launch"))){

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                CloudProfile profile = (CloudProfile)CloudProfileManager.instance.load((Long)rowModel.getObject());
                if (profile.getTestInfo() != null) {
                    if (profile.getTestInfo().getNodeCharacteristics() != null) {
                        cellItem.add(new Component[]{new Label(componentId, profile.getTestInfo().getNodeCharacteristics().getOSInfo())});
                        cellItem.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"green"))});
                    } else if (profile.getTestInfo().getErrorMessage() != null) {
                        cellItem.add(new Component[]{new Label(componentId, profile.getTestInfo().getErrorMessage())});
                        cellItem.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"red"))});
                    } else {
                        cellItem.add(new Component[]{new Label(componentId, "Test launch in progress...")});
                        cellItem.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"orange"))});
                    }
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "Pending test launch...")});
                    cellItem.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"orange"))});
                }
            }
        });
        final HashSet<String> activeTokens = new HashSet<String>();
        for (GridNode agent : AgentManager.instance.getBuildAgents()) {
            activeTokens.add(agent.getToken());
        }
        final List<Token> tokens = CacheManager.instance.getTokens();
        columns.add((IColumn<Long>)new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"#Active Nodes"))){

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                CloudProfile profile = (CloudProfile)CloudProfileManager.instance.load((Long)rowModel.getObject());
                int count = 0;
                for (Token token : tokens) {
                    if (!activeTokens.contains(token.getValue()) || token.getCloudProfile() == null || !token.getCloudProfile().getId().equals(profile.getId())) continue;
                    ++count;
                }
                Fragment fragment = new Fragment(componentId, "linkFrag", (MarkupContainer)CloudProfilesOverview.this);
                fragment.add(new Component[]{new BookmarkableTextLink("link", String.valueOf(count), GridPage.class, GridPage.params4Profile(profile.getId(), "active_launched_nodes"))});
                cellItem.add(new Component[]{fragment});
            }
        });
        columns.add((IColumn<Long>)new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"#Inactive Nodes"))){

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                CloudProfile profile = (CloudProfile)CloudProfileManager.instance.load((Long)rowModel.getObject());
                int count = 0;
                for (Token token : tokens) {
                    if (activeTokens.contains(token.getValue()) || token.getCloudProfile() == null || !token.getCloudProfile().getId().equals(profile.getId())) continue;
                    ++count;
                }
                Fragment fragment = new Fragment(componentId, "linkFrag", (MarkupContainer)CloudProfilesOverview.this);
                fragment.add(new Component[]{new BookmarkableTextLink("link", String.valueOf(count), GridPage.class, GridPage.params4Profile(profile.getId(), "inactive_launched_nodes"))});
                cellItem.add(new Component[]{fragment});
            }
        });
        columns.add((IColumn<Long>)new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"Operations"))){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                Fragment fragment = new Fragment(componentId, "operationsFrag", (MarkupContainer)CloudProfilesOverview.this);
                final CloudProfile cloudProfile = (CloudProfile)CloudProfileManager.instance.load((Long)rowModel.getObject());
                fragment.add(new Component[]{new Link<Void>("edit"){
                    private static final long serialVersionUID = 1L;

                    public void onClick() {
                        CloudProfilesOverview.this.replaceWith((Component)((Object)new CloudProfileEdit(CloudProfilesOverview.this.getId(), cloudProfile, null)));
                    }
                }});
                fragment.add(new Component[]{new Link<Void>("copy"){
                    private static final long serialVersionUID = 1L;

                    public void onClick() {
                        CloudProfilesOverview.this.replaceWith((Component)((Object)new CloudProfileEdit(CloudProfilesOverview.this.getId(), CloudProfileManager.instance.copyAsNew(cloudProfile), null)));
                    }
                }});
                cellItem.add(new Component[]{fragment});
            }

            public String getCssClass() {
                return "nowrap-text";
            }
        });
        FilterableEntityProvider dataProvider = new FilterableEntityProvider(CloudProfile.class, new SortParam("name", true), new String[0]);
        EntityDataTable dataTable = new EntityDataTable("cloudProfiles", columns, dataProvider);
        this.add(new Component[]{dataTable});
        dataTable.addTopToolbar((AbstractToolbar)new AjaxFallbackHeadersToolbar((DataTable)dataTable, (ISortStateLocator)dataProvider));
    }

    private List<CloudProfile> getCloudProfiles() {
        return (List)this.getDefaultModelObject();
    }
}

