/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid.cloud;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.pmease.quickbuild.web.component.tabbedpanel.TabbedPanel;
import com.pmease.quickbuild.web.page.grid.GridPage;
import com.pmease.quickbuild.web.page.grid.InactiveNodesPanel;
import com.pmease.quickbuild.web.page.grid.cloud.ActiveNodesPanel;
import com.pmease.quickbuild.web.page.grid.cloud.CloudProfileOverview;
import com.pmease.quickbuild.web.page.grid.cloud.TestAttributesPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Panel;

public class CloudProfilePanel
extends Panel {
    public static final String OVERVIEW = "overview";
    public static final String SYSTEM_ATTRIBUTES = "system_attributes";
    public static final String USER_ATTRIBUTES = "user_attributes";
    public static final String ACTIVE_LAUNCHED_NODES = "active_launched_nodes";
    public static final String INACTIVE_LAUNCHED_NODES = "inactive_launched_nodes";

    public CloudProfilePanel(String panelId, CloudProfile cloudProfile) {
        this(panelId, cloudProfile, null, null);
    }

    public CloudProfilePanel(String panelId, final CloudProfile cloudProfile, String tabId, String tabParam) {
        super(panelId);
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        tabs.add(new Tab(OVERVIEW, "Overview"){

            @Override
            public Panel getPanel(String id, Map<String, String> params) {
                return new CloudProfileOverview(id, cloudProfile.getId());
            }
        });
        if (SecurityHelper.isNodeAttributesAllowed(Context.getUser())) {
            tabs.add(new Tab(SYSTEM_ATTRIBUTES, "System Attributes"){

                @Override
                public Panel getPanel(String panelId, Map<String, String> panelParams) {
                    if (cloudProfile.getTestInfo() != null && cloudProfile.getTestInfo().getNodeCharacteristics() != null) {
                        return new TestAttributesPanel(panelId, cloudProfile.getTestInfo().getNodeCharacteristics().getSystemAttributes());
                    }
                    return new TestAttributesPanel(panelId, null);
                }
            });
            tabs.add(new Tab(USER_ATTRIBUTES, "User Attributes"){

                @Override
                public Panel getPanel(String panelId, Map<String, String> panelParams) {
                    if (cloudProfile.getTestInfo() != null && cloudProfile.getTestInfo().getNodeCharacteristics() != null) {
                        return new TestAttributesPanel(panelId, cloudProfile.getTestInfo().getNodeCharacteristics().getUserAttributes());
                    }
                    return new TestAttributesPanel(panelId, null);
                }
            });
        }
        tabs.add(new Tab(ACTIVE_LAUNCHED_NODES, "Active Launched Nodes"){

            @Override
            public Panel getPanel(String panelId, Map<String, String> panelParams) {
                ActiveNodesPanel panel = new ActiveNodesPanel(panelId, cloudProfile.getId());
                panel.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"mt8p"))});
                return panel;
            }
        });
        tabs.add(new Tab(INACTIVE_LAUNCHED_NODES, "Inactive Launched Nodes"){

            @Override
            public Panel getPanel(String panelId, Map<String, String> panelParams) {
                InactiveNodesPanel panel = new InactiveNodesPanel(panelId, cloudProfile.getId());
                panel.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"mt8p"))});
                return panel;
            }
        });
        if (tabId != null) {
            this.add(new Component[]{new TabbedPanel("tabs", tabs, new String[]{tabId}){

                @Override
                protected WebMarkupContainer newTabLink(String linkId, String[] tabIds) {
                    return new BookmarkablePageLink(linkId, GridPage.class, GridPage.params4Profile(cloudProfile.getId(), tabIds[0]));
                }
            }});
        } else {
            this.add(new Component[]{new TabbedPanel("tabs", tabs){

                @Override
                protected WebMarkupContainer newTabLink(String linkId, String[] tabIds) {
                    return new BookmarkablePageLink(linkId, GridPage.class, GridPage.params4Profile(cloudProfile.getId(), tabIds[0]));
                }
            }});
        }
    }
}

