/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid.cloud;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.CloudProfileManager;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.model.Token;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.component.viewer.BeanViewer;
import com.pmease.quickbuild.web.component.viewer.ViewContext;
import com.pmease.quickbuild.web.page.grid.GridPage;
import com.pmease.quickbuild.web.page.grid.cloud.CloudProfileEdit;
import java.io.Serializable;
import java.util.HashSet;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class CloudProfileOverview
extends Panel {
    public CloudProfileOverview(String id, final Long cloudProfileId) {
        super(id, (IModel)new LoadableDetachableModel<CloudProfile>(){

            protected CloudProfile load() {
                return (CloudProfile)CloudProfileManager.instance.load(cloudProfileId);
            }
        });
        WebMarkupContainer testInfoContainer = new WebMarkupContainer("testInfo");
        this.add(new Component[]{testInfoContainer});
        if (this.getCloudProfile().getTestInfo() == null) {
            testInfoContainer.add(new Component[]{new Label("osInfo", "Pending test launch...")});
            testInfoContainer.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"round window yellow mt8p"))});
        } else if (this.getCloudProfile().getTestInfo().getErrorMessage() != null) {
            testInfoContainer.add(new Component[]{new Label("osInfo", this.getCloudProfile().getTestInfo().getErrorMessage())});
            testInfoContainer.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"round window red mt8p"))});
        } else if (this.getCloudProfile().getTestInfo().getNodeCharacteristics() != null) {
            testInfoContainer.add(new Component[]{new Label("osInfo", this.getCloudProfile().getTestInfo().getNodeCharacteristics().getOSInfo())});
            testInfoContainer.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"round window green mt8p"))});
        } else {
            testInfoContainer.add(new Component[]{new Label("osInfo", "Test launch in progress...")});
            testInfoContainer.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"round window yellow mt8p"))});
        }
        WebMarkupContainer submits = new WebMarkupContainer("submits");
        submits.setVisible(SecurityHelper.isAdmin());
        testInfoContainer.add(new Component[]{submits});
        submits.add(new Component[]{new Link<Void>("testLaunch"){

            public void onClick() {
                CloudProfileManager.instance.testLaunch(CloudProfileOverview.this.getCloudProfile());
            }
        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to run a test launch for this profile?")})});
        this.add(new Component[]{new BeanViewer("viewer", new ViewContext(this.getCloudProfile(), new String[]{"name"}, true))});
        submits = new WebMarkupContainer("submits");
        submits.setVisible(SecurityHelper.isAdmin());
        this.add(new Component[]{submits});
        submits.add(new Component[]{new Link<Void>("edit"){

            public void onClick() {
                CloudProfileOverview.this.replaceWith((Component)((Object)new CloudProfileEdit(CloudProfileOverview.this.getId(), CloudProfileOverview.this.getCloudProfile(), CloudProfileOverview.this.getCloudProfile().getId())));
            }
        }});
        submits.add(new Component[]{new Link<Void>("delete"){

            public void onClick() {
                HashSet<String> nodeAddressesInUse = new HashSet<String>();
                for (BuildRequest request : BuildEngine.instance.getBuildRequests(null)) {
                    for (StepRuntime runtime : request.getBuild().getStepRuntimes().values()) {
                        if (runtime.getStatus() != StepRuntime.Status.RUNNING) continue;
                        nodeAddressesInUse.add(runtime.getNodeAddress());
                    }
                }
                for (Token token : CloudProfileOverview.this.getCloudProfile().getTokens()) {
                    if (!nodeAddressesInUse.contains(token.getAddress())) continue;
                    this.getSession().warn((Serializable)((Object)("Unable to delete this profile as its launched node '" + token.getAddress() + "' is still being used.")));
                    return;
                }
                CloudProfileManager.instance.delete(CloudProfileOverview.this.getCloudProfile());
                AuditManager.instance.audit("Grid::Cloud Profiles", "Cloud profile " + CloudProfileOverview.this.getCloudProfile().getName() + " was deleted.");
                this.setResponsePage(GridPage.class, GridPage.params4(new String[]{"cloud_profiles"}));
            }
        }.add(new Behavior[]{new ConfirmBehavior("This will terminuate all launched nodes associated with this profile. Do you really want to delete this profile?")})});
    }

    private CloudProfile getCloudProfile() {
        return (CloudProfile)this.getDefaultModelObject();
    }
}

