/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid.cloud;

import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.CloudProfileManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.grid.GridPage;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class CloudProfileEdit
extends Panel {
    private Long backToProfileId;

    public CloudProfileEdit(String id, final CloudProfile cloudProfile, Long backToProfileId) {
        super(id, (IModel)new LoadableDetachableModel<CloudProfile>(){

            protected CloudProfile load() {
                if (cloudProfile.getId() != null) {
                    return (CloudProfile)CloudProfileManager.instance.load(cloudProfile.getId());
                }
                return cloudProfile;
            }
        });
        this.backToProfileId = backToProfileId;
    }

    protected void onInitialize() {
        super.onInitialize();
        final EditContext editContext = new EditContext(this.getCloudProfile());
        Form form = new Form("form"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    String previousAuditContent = !CloudProfileEdit.this.getCloudProfile().isNew() ? VersionedDocument.fromBean(CloudProfileEdit.this.getCloudProfile()).toXML() : null;
                    editContext.update(CloudProfileEdit.this.getCloudProfile());
                    CloudProfileEdit.this.getCloudProfile().setNodeLauncherDOM(VersionedDocument.fromBean(CloudProfileEdit.this.getCloudProfile().getNodeLauncher()));
                    CloudProfile profileWithSameName = CloudProfileManager.instance.get(CloudProfileEdit.this.getCloudProfile().getName());
                    if (profileWithSameName != null && (CloudProfileEdit.this.getCloudProfile().isNew() || !profileWithSameName.getId().equals(CloudProfileEdit.this.getCloudProfile().getId()))) {
                        editContext.getProperty("name").setError("This name is already used by another cloud profile.");
                        this.getSession().error((Serializable)((Object)"Fix errors below."));
                        return;
                    }
                    CloudProfileEdit.this.getCloudProfile().setTestInfo(null);
                    CloudProfileManager.instance.save(CloudProfileEdit.this.getCloudProfile());
                    if (previousAuditContent != null) {
                        AuditManager.instance.audit("Grid::Cloud Profiles", "Cloud profile '" + CloudProfileEdit.this.getCloudProfile().getName() + "' was modified.", VersionedDocument.fromBean(CloudProfileEdit.this.getCloudProfile()).toXML(), previousAuditContent);
                    } else {
                        AuditManager.instance.audit("Grid::Cloud Profiles", "Cloud profile '" + CloudProfileEdit.this.getCloudProfile().getName() + "' was added.");
                    }
                    if (CloudProfileEdit.this.backToProfileId == null) {
                        this.setResponsePage(GridPage.class, GridPage.params4(new String[]{"cloud_profiles"}));
                    } else {
                        this.setResponsePage(GridPage.class, GridPage.params4(new String[]{"cloud_profiles", String.valueOf(CloudProfileEdit.this.backToProfileId)}));
                    }
                    this.getSession().info((Serializable)((Object)"Settings have been saved."));
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        form.add(new Component[]{new Link("cancel"){

            public void onClick() {
                if (CloudProfileEdit.this.backToProfileId == null) {
                    this.setResponsePage(GridPage.class, GridPage.params4(new String[]{"cloud_profiles"}));
                } else {
                    this.setResponsePage(GridPage.class, GridPage.params4(new String[]{"cloud_profiles", String.valueOf(CloudProfileEdit.this.backToProfileId)}));
                }
            }
        }});
        this.add(new Component[]{form});
    }

    private CloudProfile getCloudProfile() {
        return (CloudProfile)this.getDefaultModelObject();
    }
}

