/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid.cloud;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.TokenManager;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.model.Token;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.component.BookmarkableTextLink;
import com.pmease.quickbuild.web.component.TextLink;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.page.grid.GridPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class ActiveNodesPanel
extends Panel {
    private SelectionColumn<GridNode> selectionColumn;
    private IModel<List<BuildRequest>> buildRequestsModel;

    public ActiveNodesPanel(String panelId, final Long cloudProfileId) {
        super(panelId);
        this.setDefaultModel((IModel)new LoadableDetachableModel<List<GridNode>>(){

            protected List<GridNode> load() {
                ArrayList<GridNode> activeNodes = new ArrayList<GridNode>();
                for (GridNode agent : AgentManager.instance.getBuildAgents()) {
                    if (agent.getCloudProfile() == null || !agent.getCloudProfile().getId().equals(cloudProfileId)) continue;
                    activeNodes.add(agent);
                }
                return activeNodes;
            }
        });
        this.buildRequestsModel = new LoadableDetachableModel<List<BuildRequest>>(){

            protected List<BuildRequest> load() {
                return BuildEngine.instance.getBuildRequests(null);
            }
        };
        WebMarkupContainer actionsTrigger = new WebMarkupContainer("actions");
        actionsTrigger.setVisible(SecurityHelper.isAdmin());
        this.add(new Component[]{actionsTrigger});
        actionsTrigger.add(new Behavior[]{new MenuBehavior(){

            @Override
            protected List<MenuItem> getMenuItems() {
                ArrayList<MenuItem> items = new ArrayList<MenuItem>();
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Restart Agents on Selected Nodes"))){

                            public void onClick() {
                                if (!ActiveNodesPanel.this.selectionColumn.getSelections().isEmpty()) {
                                    for (GridNode node : ActiveNodesPanel.this.selectionColumn.getSelections()) {
                                        if (node.isServer()) continue;
                                        node.getNodeService().restart();
                                        AuditManager.instance.audit("Grid::Nodes", "Active agent " + node.getAddress() + " is requested to restart.");
                                    }
                                    ActiveNodesPanel.this.selectionColumn.getSelections().clear();
                                    this.getSession().info((Serializable)((Object)"Restart command has been issued to selected agents."));
                                } else {
                                    this.getSession().warn((Serializable)((Object)"Please select agents to restart."));
                                }
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to restart agents on selected nodes?")});
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Stop Agents on Selected Nodes"))){

                            public void onClick() {
                                if (!ActiveNodesPanel.this.selectionColumn.getSelections().isEmpty()) {
                                    for (GridNode node : ActiveNodesPanel.this.selectionColumn.getSelections()) {
                                        if (node.isServer()) continue;
                                        node.getNodeService().stop();
                                        AuditManager.instance.audit("Grid::Nodes", "Active agent " + node.getAddress() + " is requested to stop.");
                                    }
                                    ActiveNodesPanel.this.selectionColumn.getSelections().clear();
                                    this.getSession().info((Serializable)((Object)"Stop command has been issued to selected agents."));
                                } else {
                                    this.getSession().warn((Serializable)((Object)"Please select agents to stop."));
                                }
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to stop agents on selected nodes?")});
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Unauthorize Selected Nodes"))){

                            public void onClick() {
                                if (!ActiveNodesPanel.this.selectionColumn.getSelections().isEmpty()) {
                                    for (GridNode node : ActiveNodesPanel.this.selectionColumn.getSelections()) {
                                        if (node.isServer()) continue;
                                        Token token = CacheManager.instance.getToken(node.getToken());
                                        if (token != null) {
                                            TokenManager.instance.delete(token);
                                        }
                                        AgentManager.instance.removeBuildAgent(node.getIp(), node.getPort());
                                        AuditManager.instance.audit("Grid::Nodes", "Active node " + node.getAddress() + " was unauthorized.");
                                    }
                                    ActiveNodesPanel.this.selectionColumn.getSelections().clear();
                                } else {
                                    this.getSession().warn((Serializable)((Object)"Please select nodes to unauthorize."));
                                }
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to unauthorize selected nodes?")});
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Terminate Selected Cloud Nodes"))){

                            public void onClick() {
                                if (!ActiveNodesPanel.this.selectionColumn.getSelections().isEmpty()) {
                                    boolean notEligiblesFound = false;
                                    for (GridNode node : ActiveNodesPanel.this.selectionColumn.getSelections()) {
                                        if (node.getCloudProfile() != null) {
                                            CloudProfile profile = CacheManager.instance.getCloudProfile(node.getCloudProfile().getId());
                                            if (profile == null) continue;
                                            profile.getNodeLauncher().terminateNode(node.getLaunchId());
                                            Token token = TokenManager.instance.getByValue(node.getToken());
                                            if (token != null) {
                                                TokenManager.instance.delete(token);
                                            }
                                            AuditManager.instance.audit("Grid::Nodes", "Terminating request was sent to node '" + node.getAddress() + "'.");
                                            continue;
                                        }
                                        notEligiblesFound = true;
                                    }
                                    ActiveNodesPanel.this.selectionColumn.getSelections().clear();
                                    if (notEligiblesFound) {
                                        this.getSession().warn((Serializable)((Object)"Some of the selected nodes can not be terminated as they are not launched by cloud profiles."));
                                    } else {
                                        this.getSession().info((Serializable)((Object)"Terminating requests have been sent to selected nodes."));
                                    }
                                } else {
                                    this.getSession().warn((Serializable)((Object)"Please select nodes to terminate."));
                                }
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("This will forcibly terminate selected nodes launched by cloud profiles even if they are still being used by builds. Do you really want to continue?")});
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Restart Agents on All Active Nodes"))){

                            public void onClick() {
                                for (GridNode node : ActiveNodesPanel.this.getActiveNodes()) {
                                    if (node.isServer()) continue;
                                    node.getNodeService().restart();
                                }
                                AuditManager.instance.audit("Grid::Nodes", "All active agents are requested to restart.");
                                ActiveNodesPanel.this.getDefaultModel().detach();
                                ActiveNodesPanel.this.selectionColumn.getSelections().clear();
                                this.getSession().info((Serializable)((Object)"Restart command has been issued to all active agents."));
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to restart agents on all active nodes?")});
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Stop Agents on All Active Nodes"))){

                            public void onClick() {
                                for (GridNode node : ActiveNodesPanel.this.getActiveNodes()) {
                                    if (node.isServer()) continue;
                                    node.getNodeService().stop();
                                }
                                AuditManager.instance.audit("Grid::Nodes", "All active agents are requested to restart.");
                                ActiveNodesPanel.this.getDefaultModel().detach();
                                ActiveNodesPanel.this.selectionColumn.getSelections().clear();
                                this.getSession().info((Serializable)((Object)"Stop command has been issued to all active agents."));
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to stop agents on all active nodes?")});
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Unauthorize All Active Nodes"))){

                            public void onClick() {
                                for (GridNode node : ActiveNodesPanel.this.getActiveNodes()) {
                                    if (node.isServer()) continue;
                                    Token token = CacheManager.instance.getToken(node.getToken());
                                    if (token != null) {
                                        TokenManager.instance.delete(token);
                                    }
                                    AgentManager.instance.removeBuildAgent(node.getIp(), node.getPort());
                                }
                                AuditManager.instance.audit("Grid::Nodes", "All active nodes were unauthorized.");
                                ActiveNodesPanel.this.getDefaultModel().detach();
                                ActiveNodesPanel.this.selectionColumn.getSelections().clear();
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to unauthorize all active nodes?")});
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Terminate All Active Cloud Nodes"))){

                            public void onClick() {
                                for (GridNode node : ActiveNodesPanel.this.getActiveNodes()) {
                                    CloudProfile profile;
                                    if (node.getCloudProfile() == null || (profile = CacheManager.instance.getCloudProfile(node.getCloudProfile().getId())) == null) continue;
                                    profile.getNodeLauncher().terminateNode(node.getLaunchId());
                                    Token token = TokenManager.instance.getByValue(node.getToken());
                                    if (token != null) {
                                        TokenManager.instance.delete(token);
                                    }
                                    AuditManager.instance.audit("Grid::Nodes", "Request to terminuate node '" + node.getAddress() + "'.");
                                }
                                this.getSession().info((Serializable)((Object)"Terminating requests have been sent to all nodes launched by cloud profiles."));
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("This will forcibly terminate all nodes launched by cloud profiles even if they are still being used by builds. Do you really want to continue?")});
                    }
                });
                return items;
            }
        }});
        ArrayList<Object> columns = new ArrayList<Object>();
        if (SecurityHelper.isAdmin()) {
            this.selectionColumn = new SelectionColumn();
            columns.add(this.selectionColumn);
        }
        columns.add(new AbstractColumn<GridNode>((IModel)new Model((Serializable)((Object)"Address")), "address"){

            public void populateItem(Item<ICellPopulator<GridNode>> cellItem, String componentId, IModel<GridNode> rowModel) {
                GridNode node = (GridNode)rowModel.getObject();
                Fragment fragment = new Fragment(componentId, "linkFrag", (MarkupContainer)ActiveNodesPanel.this);
                fragment.add(new Component[]{new BookmarkableTextLink("link", node.getAddress(), GridPage.class, GridPage.params4(node.getAddress()))});
                cellItem.add(new Component[]{fragment});
            }
        });
        columns.add(new AbstractColumn<GridNode>((IModel)new Model((Serializable)((Object)"IP")), "ip"){

            public void populateItem(Item<ICellPopulator<GridNode>> cellItem, String componentId, IModel<GridNode> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, ((GridNode)rowModel.getObject()).getIp())});
            }
        });
        columns.add(new AbstractColumn<GridNode>((IModel)new Model((Serializable)((Object)"Launch Id"))){

            public void populateItem(Item<ICellPopulator<GridNode>> cellItem, String componentId, IModel<GridNode> rowModel) {
                GridNode node = (GridNode)rowModel.getObject();
                if (node.getLaunchId() != null) {
                    cellItem.add(new Component[]{new Label(componentId, node.getLaunchId())});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "<i>N/A</i>").setEscapeModelStrings(false)});
                }
            }
        });
        columns.add(new AbstractColumn<GridNode>((IModel)new Model((Serializable)((Object)"Over SSL")), "ssl"){

            public void populateItem(Item<ICellPopulator<GridNode>> cellItem, String componentId, IModel<GridNode> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, String.valueOf(((GridNode)rowModel.getObject()).isOverSSL()))});
            }
        });
        columns.add(new AbstractColumn<GridNode>((IModel)new Model((Serializable)((Object)"#Steps")), "#steps"){

            public void populateItem(Item<ICellPopulator<GridNode>> cellItem, String componentId, IModel<GridNode> rowModel) {
                GridNode node = (GridNode)rowModel.getObject();
                int count = 0;
                for (BuildRequest request : ActiveNodesPanel.this.getBuildRequests()) {
                    for (StepRuntime runtime : request.getBuild().getStepRuntimes().values()) {
                        if (runtime.getStatus() != StepRuntime.Status.RUNNING || !runtime.getNodeAddress().equals(node.getAddress())) continue;
                        ++count;
                    }
                }
                if (count != 0) {
                    cellItem.add(new Component[]{new BookmarkableTextLink(componentId, String.valueOf(count), GridPage.class, GridPage.params4(node.getAddress(), "steps")){

                        protected void onComponentTag(ComponentTag tag) {
                            tag.setName("a");
                            super.onComponentTag(tag);
                        }
                    }});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, String.valueOf(count))});
                }
            }
        });
        columns.add(new AbstractColumn<GridNode>((IModel)new Model((Serializable)((Object)"Benchmark")), "benchmark"){

            public void populateItem(Item<ICellPopulator<GridNode>> cellItem, String componentId, IModel<GridNode> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, String.valueOf(((GridNode)rowModel.getObject()).getBenchmark()))});
            }
        });
        this.add(new Component[]{new DefaultDataTable("nodes", columns, (ISortableDataProvider)new DataProvider<GridNode>(){

            public Iterator<GridNode> iterator(int first, int count) {
                List nodes = ActiveNodesPanel.this.getActiveNodes();
                Collections.sort(nodes, new Comparator<GridNode>(){

                    @Override
                    public int compare(GridNode node1, GridNode node2) {
                        int result;
                        if (this.getSort() != null) {
                            if (this.getSort().getProperty().equals("address")) {
                                result = node1.getAddress().compareTo(node2.getAddress());
                            } else if (this.getSort().getProperty().equals("ip")) {
                                result = node1.getIp().compareTo(node2.getIp());
                            } else if (this.getSort().getProperty().equals("ssl")) {
                                result = node1.isOverSSL() ? -1 : 1;
                            } else {
                                if (this.getSort().getProperty().equals("#steps")) {
                                    int count1 = 0;
                                    int count2 = 0;
                                    for (BuildRequest request : ActiveNodesPanel.this.getBuildRequests()) {
                                        for (StepRuntime runtime : request.getBuild().getStepRuntimes().values()) {
                                            if (runtime.getStatus() != StepRuntime.Status.RUNNING) continue;
                                            if (runtime.getNodeAddress().equals(node1.getAddress())) {
                                                ++count1;
                                            }
                                            if (!runtime.getNodeAddress().equals(node2.getAddress())) continue;
                                            ++count2;
                                        }
                                    }
                                    return count1 - count2;
                                }
                                if (this.getSort().getProperty().equals("benchmark")) {
                                    result = (int)(node1.getBenchmark() - node2.getBenchmark());
                                } else if (this.getSort().getProperty().equals("cloudProfile")) {
                                    result = node1.getCloudProfile() == null ? -1 : (node2.getCloudProfile() == null ? 1 : node1.getCloudProfile().getName().compareTo(node2.getCloudProfile().getName()));
                                } else {
                                    throw new QuickbuildException("Unrecognized sort property: " + this.getSort().getProperty());
                                }
                            }
                            if (!this.getSort().isAscending()) {
                                result *= -1;
                            }
                        } else {
                            result = node1.getAddress().compareTo(node2.getAddress());
                        }
                        return result;
                    }
                });
                return nodes.subList(first, first + count).iterator();
            }

            public int size() {
                return ActiveNodesPanel.this.getActiveNodes().size();
            }
        }, 25)});
    }

    private List<GridNode> getActiveNodes() {
        return (List)this.getDefaultModelObject();
    }

    private List<BuildRequest> getBuildRequests() {
        return (List)this.buildRequestsModel.getObject();
    }

    protected void detachModel() {
        this.buildRequestsModel.detach();
        super.detachModel();
    }
}

