/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid;

import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.util.StringUtils;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class UserAttributeEdit
extends Panel {
    private String attributeText;

    public UserAttributeEdit(String panelId, IModel<GridNode> nodeModel) {
        super(panelId, nodeModel);
        Form form = new Form("form"){

            protected void onSubmit() {
                LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
                if (UserAttributeEdit.this.attributeText != null) {
                    List<String> lines = StringUtils.splitAndTrim(UserAttributeEdit.this.attributeText, "\n");
                    for (String line : lines) {
                        String name = StringUtils.substringBefore((String)line, (String)"=").trim();
                        if (name.length() == 0) continue;
                        attributes.put(name, StringUtils.substringAfter((String)line, (String)"=").trim());
                    }
                }
                AuditManager.instance.audit("Grid::Node::" + UserAttributeEdit.this.getNode().getAddress(), "User attributes were modified.", VersionedDocument.fromBean(attributes).toXML(), VersionedDocument.fromBean(UserAttributeEdit.this.getNode().getUserAttributes()).toXML());
                UserAttributeEdit.this.getNode().setUserAttributes(attributes, true);
                this.getSession().info((Serializable)((Object)"User attributes updated successfully."));
            }
        };
        this.add(new Component[]{form});
        form.add(new Component[]{new TextArea("attributes", new IModel(){

            public Object getObject() {
                StringBuffer attributeText = new StringBuffer();
                for (Map.Entry<String, String> entry : UserAttributeEdit.this.getNode().getUserAttributes().entrySet()) {
                    attributeText.append(entry.getKey() + "=");
                    if (entry.getValue() != null) {
                        attributeText.append(entry.getValue().toString());
                    }
                    attributeText.append("\n");
                }
                return attributeText.toString();
            }

            public void setObject(Object object) {
                UserAttributeEdit.this.attributeText = (String)object;
            }

            public void detach() {
            }
        })});
    }

    private GridNode getNode() {
        return (GridNode)this.getDefaultModelObject();
    }
}

