/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.component.BookmarkableTextLink;
import com.pmease.quickbuild.web.component.TextLink;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.page.grid.GridPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class UserAgentsOverview
extends Panel {
    private SelectionColumn<GridNode> selectionColumn;

    public UserAgentsOverview(String panelId) {
        super(panelId);
        final List<BuildRequest> requests = BuildEngine.instance.getBuildRequests(null);
        this.setDefaultModel((IModel)new LoadableDetachableModel<List<GridNode>>(){

            protected List<GridNode> load() {
                return AgentManager.instance.getUserAgents();
            }
        });
        WebMarkupContainer actionsTrigger = new WebMarkupContainer("actions");
        actionsTrigger.setVisible(SecurityHelper.isAdmin());
        this.add(new Component[]{actionsTrigger});
        actionsTrigger.add(new Behavior[]{new MenuBehavior(){

            @Override
            protected List<MenuItem> getMenuItems() {
                ArrayList<MenuItem> items = new ArrayList<MenuItem>();
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Restart User Agents on Selected Nodes"))){

                            public void onClick() {
                                if (!UserAgentsOverview.this.selectionColumn.getSelections().isEmpty()) {
                                    for (GridNode node : UserAgentsOverview.this.selectionColumn.getSelections()) {
                                        node.getNodeService().restart();
                                    }
                                    UserAgentsOverview.this.selectionColumn.getSelections().clear();
                                    this.getSession().info((Serializable)((Object)"Agent restart command issued."));
                                } else {
                                    this.getSession().warn((Serializable)((Object)"Please select agents to restart."));
                                }
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to restart user agents on selected nodes?")});
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Restart User Agents on All Nodes"))){

                            public void onClick() {
                                for (GridNode node : UserAgentsOverview.this.getUserAgents()) {
                                    node.getNodeService().restart();
                                }
                                UserAgentsOverview.this.getDefaultModel().detach();
                                UserAgentsOverview.this.selectionColumn.getSelections().clear();
                                this.getSession().info((Serializable)((Object)"Agent restart command issued."));
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to restart user agents on all nodes?")});
                    }
                });
                return items;
            }
        }});
        ArrayList<Object> columns = new ArrayList<Object>();
        if (SecurityHelper.isAdmin()) {
            this.selectionColumn = new SelectionColumn();
            columns.add(this.selectionColumn);
        }
        columns.add(new AbstractColumn<GridNode>((IModel)new Model((Serializable)((Object)"User")), "user"){

            public void populateItem(Item<ICellPopulator<GridNode>> cellItem, String componentId, IModel<GridNode> rowModel) {
                GridNode node = (GridNode)rowModel.getObject();
                if (node.getUserId() != null) {
                    cellItem.add(new Component[]{new Label(componentId, ((User)UserManager.instance.load(node.getUserId())).getDisplayName())});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "<i>Unknown</i>").setEscapeModelStrings(false)});
                }
            }
        });
        columns.add(new AbstractColumn<GridNode>((IModel)new Model((Serializable)((Object)"Address")), "address"){

            public void populateItem(Item<ICellPopulator<GridNode>> cellItem, String componentId, IModel<GridNode> rowModel) {
                GridNode node = (GridNode)rowModel.getObject();
                Fragment fragment = new Fragment(componentId, "linkFrag", (MarkupContainer)UserAgentsOverview.this);
                fragment.add(new Component[]{new BookmarkableTextLink("link", node.getAddress(), GridPage.class, GridPage.params4(node.getAddress()))});
                cellItem.add(new Component[]{fragment});
            }
        });
        columns.add(new AbstractColumn<GridNode>((IModel)new Model((Serializable)((Object)"IP")), "ip"){

            public void populateItem(Item<ICellPopulator<GridNode>> cellItem, String componentId, IModel<GridNode> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, ((GridNode)rowModel.getObject()).getIp())});
            }
        });
        columns.add(new AbstractColumn<GridNode>((IModel)new Model((Serializable)((Object)"Over SSL")), "ssl"){

            public void populateItem(Item<ICellPopulator<GridNode>> cellItem, String componentId, IModel<GridNode> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, String.valueOf(((GridNode)rowModel.getObject()).isOverSSL()))});
            }
        });
        columns.add(new AbstractColumn<GridNode>((IModel)new Model((Serializable)((Object)"#Steps"))){

            public void populateItem(Item<ICellPopulator<GridNode>> cellItem, String componentId, IModel<GridNode> rowModel) {
                GridNode node = (GridNode)rowModel.getObject();
                int count = 0;
                for (BuildRequest request : requests) {
                    for (StepRuntime runtime : request.getBuild().getStepRuntimes().values()) {
                        if (runtime.getStatus() != StepRuntime.Status.RUNNING || !runtime.getNodeAddress().equals(node.getAddress())) continue;
                        ++count;
                    }
                }
                cellItem.add(new Component[]{new BookmarkableTextLink(componentId, String.valueOf(count), GridPage.class, GridPage.params4(node.getAddress(), "steps"))});
            }
        });
        columns.add(new AbstractColumn<GridNode>((IModel)new Model((Serializable)((Object)"Benchmark")), "benchmark"){

            public void populateItem(Item<ICellPopulator<GridNode>> cellItem, String componentId, IModel<GridNode> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, String.valueOf(((GridNode)rowModel.getObject()).getBenchmark()))});
            }
        });
        this.add(new Component[]{new DefaultDataTable("nodes", columns, (ISortableDataProvider)new DataProvider<GridNode>(){

            public Iterator<GridNode> iterator(int first, int count) {
                List nodes = UserAgentsOverview.this.getUserAgents();
                Collections.sort(nodes, new Comparator<GridNode>(){

                    @Override
                    public int compare(GridNode node1, GridNode node2) {
                        int result;
                        if (this.getSort() != null) {
                            if (this.getSort().getProperty().equals("user")) {
                                result = node1.getUser().getDisplayName().compareTo(node2.getUser().getDisplayName());
                            } else if (this.getSort().getProperty().equals("address")) {
                                result = node1.getAddress().compareTo(node2.getAddress());
                            } else if (this.getSort().getProperty().equals("ip")) {
                                result = node1.getIp().compareTo(node2.getIp());
                            } else if (this.getSort().getProperty().equals("ssl")) {
                                result = node1.isOverSSL() ? -1 : 1;
                            } else if (this.getSort().getProperty().equals("benchmark")) {
                                result = (int)(node1.getBenchmark() - node2.getBenchmark());
                            } else {
                                throw new QuickbuildException("Unrecognized sort property: " + this.getSort().getProperty());
                            }
                            if (!this.getSort().isAscending()) {
                                result *= -1;
                            }
                        } else {
                            result = node1.getAddress().compareTo(node2.getAddress());
                        }
                        return result;
                    }
                });
                return nodes.subList(first, first + count).iterator();
            }

            public int size() {
                return UserAgentsOverview.this.getUserAgents().size();
            }
        }, 25)});
    }

    private List<GridNode> getUserAgents() {
        return (List)this.getDefaultModelObject();
    }
}

