/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.TokenManager;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.UnauthorizedAgent;
import com.pmease.quickbuild.model.Token;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.component.TextLink;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.SearchNavToolbar;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.SearchPatternChanged;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackHeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NoRecordsToolbar;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class UnauthorizedNodesPanel
extends Panel {
    private SelectionColumn<UnauthorizedAgent> selectionColumn;
    private IModel<String> patternModel = Model.of((Serializable)((Object)""));

    public UnauthorizedNodesPanel(String id) {
        super(id);
        this.setOutputMarkupId(true);
        this.setDefaultModel((IModel)new LoadableDetachableModel<List<UnauthorizedAgent>>(){

            protected List<UnauthorizedAgent> load() {
                ArrayList agents = Lists.newArrayList(AgentManager.instance.getUnauthorizedAgents());
                String pattern = (String)UnauthorizedNodesPanel.this.patternModel.getObject();
                if (!Strings.isNullOrEmpty((String)pattern)) {
                    Iterator it = agents.iterator();
                    while (it.hasNext()) {
                        UnauthorizedAgent agent = (UnauthorizedAgent)it.next();
                        String hostName = agent.getHostName();
                        if (hostName != null && hostName.toLowerCase().contains(pattern)) continue;
                        it.remove();
                    }
                }
                Collections.sort(agents, new Comparator<UnauthorizedAgent>(){

                    @Override
                    public int compare(UnauthorizedAgent agent1, UnauthorizedAgent agent2) {
                        return agent1.getAddress().compareTo(agent2.getAddress());
                    }
                });
                return agents;
            }
        });
        WebMarkupContainer actionsTrigger = new WebMarkupContainer("actions");
        actionsTrigger.setVisible(SecurityHelper.isAdmin());
        this.add(new Component[]{actionsTrigger});
        actionsTrigger.add(new Behavior[]{new MenuBehavior(){

            @Override
            protected List<MenuItem> getMenuItems() {
                ArrayList<MenuItem> items = new ArrayList<MenuItem>();
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Authorize Selected Nodes"))){

                            public void onClick() {
                                if (!UnauthorizedNodesPanel.this.selectionColumn.getSelections().isEmpty()) {
                                    for (UnauthorizedAgent agent : UnauthorizedNodesPanel.this.selectionColumn.getSelections()) {
                                        Token token = new Token();
                                        token.setValue(UUID.randomUUID().toString());
                                        token.setIp(agent.getIp());
                                        token.setPort(agent.getPort());
                                        token.setHostName(agent.getHostName());
                                        TokenManager.instance.save(token);
                                        AgentManager.instance.removeUnauthorizedAgent(agent.getIp(), agent.getPort());
                                        AuditManager.instance.audit("Grid::Nodes", "Node " + token.getHostName() + ":" + token.getPort() + " was authorized");
                                    }
                                    UnauthorizedNodesPanel.this.selectionColumn.getSelections().clear();
                                    this.getSession().info((Serializable)((Object)"Selected nodes authorized. It will take a short while for them to appear in the active node list."));
                                } else {
                                    this.getSession().warn((Serializable)((Object)"Please select nodes to authorize."));
                                }
                            }
                        };
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Authorize All Nodes"))){

                            public void onClick() {
                                List<UnauthorizedAgent> unauthorizedBuildAgents = AgentManager.instance.getUnauthorizedAgents();
                                if (!unauthorizedBuildAgents.isEmpty()) {
                                    for (UnauthorizedAgent agent : unauthorizedBuildAgents) {
                                        Token token = new Token();
                                        token.setValue(UUID.randomUUID().toString());
                                        token.setIp(agent.getIp());
                                        token.setPort(agent.getPort());
                                        token.setHostName(agent.getHostName());
                                        TokenManager.instance.save(token);
                                        AgentManager.instance.removeUnauthorizedAgent(agent.getIp(), agent.getPort());
                                    }
                                    AuditManager.instance.audit("Grid::Nodes", "All unauthorized nodes were authorized.");
                                    this.getSession().info((Serializable)((Object)"Nodes authorized. It will take a short while for them to appear in the active node list."));
                                }
                                UnauthorizedNodesPanel.this.selectionColumn.getSelections().clear();
                            }
                        };
                    }
                });
                return items;
            }
        }});
        ArrayList<Object> columns = new ArrayList<Object>();
        if (SecurityHelper.isAdmin()) {
            this.selectionColumn = new SelectionColumn();
            columns.add(this.selectionColumn);
        }
        columns.add(new AbstractColumn<UnauthorizedAgent>((IModel)new Model((Serializable)((Object)"Host Name"))){

            public void populateItem(Item<ICellPopulator<UnauthorizedAgent>> cellItem, String componentId, IModel<UnauthorizedAgent> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, ((UnauthorizedAgent)rowModel.getObject()).getHostName())});
            }
        });
        columns.add(new AbstractColumn<UnauthorizedAgent>((IModel)new Model((Serializable)((Object)"IP"))){

            public void populateItem(Item<ICellPopulator<UnauthorizedAgent>> cellItem, String componentId, IModel<UnauthorizedAgent> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, ((UnauthorizedAgent)rowModel.getObject()).getIp())});
            }
        });
        columns.add(new AbstractColumn<UnauthorizedAgent>((IModel)new Model((Serializable)((Object)"Port"))){

            public void populateItem(Item<ICellPopulator<UnauthorizedAgent>> cellItem, String componentId, IModel<UnauthorizedAgent> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, String.valueOf(((UnauthorizedAgent)rowModel.getObject()).getPort()))});
            }
        });
        columns.add(new AbstractColumn<UnauthorizedAgent>((IModel)new Model((Serializable)((Object)"Over SSL"))){

            public void populateItem(Item<ICellPopulator<UnauthorizedAgent>> cellItem, String componentId, IModel<UnauthorizedAgent> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, String.valueOf(((UnauthorizedAgent)rowModel.getObject()).isOverSSL()))});
            }
        });
        DataProvider<UnauthorizedAgent> dataProvider = new DataProvider<UnauthorizedAgent>(){

            public Iterator<UnauthorizedAgent> iterator(int first, int count) {
                int end = Math.min(this.size(), first + count);
                return UnauthorizedNodesPanel.this.getAgents().subList(first, end).iterator();
            }

            public int size() {
                return UnauthorizedNodesPanel.this.getAgents().size();
            }
        };
        DataTable table = new DataTable("nodes", columns, (IDataProvider)dataProvider, 100);
        table.setOutputMarkupId(true);
        table.addTopToolbar((AbstractToolbar)new AjaxFallbackHeadersToolbar(table, (ISortStateLocator)dataProvider));
        table.addTopToolbar((AbstractToolbar)new SearchNavToolbar(table));
        table.addTopToolbar((AbstractToolbar)new NoRecordsToolbar(table, (IModel)Model.of((Serializable)((Object)"No nodes found"))));
        table.addBottomToolbar((AbstractToolbar)new SearchNavToolbar(table));
        this.add(new Component[]{table});
        WebMarkupContainer breadcrumbs = new WebMarkupContainer("breadcrumbs"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisibilityAllowed(!Strings.isNullOrEmpty((String)((String)UnauthorizedNodesPanel.this.patternModel.getObject())));
            }
        };
        this.add(new Component[]{breadcrumbs});
        breadcrumbs.add(new Component[]{new AjaxLink<Void>("allLink"){

            public void onClick(AjaxRequestTarget target) {
                this.send((IEventSink)this.getPage(), Broadcast.DEPTH, SearchPatternChanged.of(target, ""));
            }
        }});
        breadcrumbs.add(new Component[]{new Label("pattern", this.patternModel)});
    }

    private List<UnauthorizedAgent> getAgents() {
        return (List)this.getDefaultModelObject();
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof SearchPatternChanged) {
            SearchPatternChanged event = (SearchPatternChanged)sink.getPayload();
            this.patternModel.setObject((Object)event.getPattern());
            event.getTarget().add(new Component[]{this});
        }
    }

    public void onDetach() {
        super.onDetach();
        if (this.patternModel != null) {
            this.patternModel.detach();
        }
    }
}

