/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid;

import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class SystemAttributePanel
extends Panel {
    public SystemAttributePanel(String panelId, IModel<GridNode> nodeModel) {
        super(panelId, nodeModel);
        this.add(new Component[]{new ListView("attributes", (IModel)new LoadableDetachableModel(){

            protected Object load() {
                ArrayList<Pair<String, String>> nameValuePairs = new ArrayList<Pair<String, String>>();
                GridNode node = (GridNode)SystemAttributePanel.this.getDefaultModelObject();
                for (Map.Entry<String, String> entry : node.getSystemAttributes().entrySet()) {
                    nameValuePairs.add(new Pair<String, String>(entry.getKey(), entry.getValue().toString()));
                }
                Collections.sort(nameValuePairs, new Comparator<Pair<String, String>>(){

                    @Override
                    public int compare(Pair<String, String> pair1, Pair<String, String> pair2) {
                        return pair1.getFirst().compareTo(pair2.getFirst());
                    }
                });
                return nameValuePairs;
            }
        }){

            protected void populateItem(ListItem item) {
                Pair nameValuePair = (Pair)item.getModelObject();
                item.add(new Component[]{new Label("name", (String)nameValuePair.getFirst())});
                item.add(new Component[]{new Label("value", (String)nameValuePair.getSecond())});
            }
        }});
    }
}

