/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.web.component.build.BuildLink;
import com.pmease.quickbuild.web.component.configuration.ConfigurationLink;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class RunningStepsPanel
extends Panel {
    private IModel<Map<Long, Configuration>> configurationsModel = new LoadableDetachableModel<Map<Long, Configuration>>(){

        protected Map<Long, Configuration> load() {
            return CacheManager.instance.cloneConfigurations();
        }
    };

    public RunningStepsPanel(String panelId, IModel<GridNode> nodeModel) {
        super(panelId, nodeModel);
        this.add(new Component[]{new ListView<Step>("steps", (IModel)new LoadableDetachableModel<List<Step>>(){

            protected List<Step> load() {
                ArrayList<Step> steps = new ArrayList<Step>();
                for (BuildRequest request : BuildEngine.instance.getBuildRequests(null)) {
                    Build build = request.getBuild();
                    for (Step step : build.getSteps()) {
                        if (!step.isRunning() || !RunningStepsPanel.this.getNode().getAddress().equals(step.getNodeAddress())) continue;
                        steps.add(step);
                    }
                }
                return steps;
            }
        }){

            protected void populateItem(final ListItem<Step> item) {
                Step step = (Step)item.getModelObject();
                item.add(new Component[]{new Label("stepPath", step.getPath().toString())});
                StringBuffer buffer = new StringBuffer();
                for (Map.Entry<String, Integer> entry : step.getResources().entrySet()) {
                    buffer.append(entry.getKey() + ":" + entry.getValue() + ", ");
                }
                if (buffer.length() != 0) {
                    item.add(new Component[]{new Label("resources", StringUtils.stripEnd((String)buffer.toString(), (String)", "))});
                } else {
                    item.add(new Component[]{new Label("resources", "<i>No reserved resources</i>").setEscapeModelStrings(false)});
                }
                item.add(new Component[]{new ConfigurationLink("configurationLink", (IModel<Configuration>)new LoadableDetachableModel<Configuration>(){

                    protected Configuration load() {
                        return (Configuration)RunningStepsPanel.this.getConfigurations().get(((Step)item.getModelObject()).getBuild().getConfiguration().getId());
                    }
                })});
                if (step.getBuild().getId() != null) {
                    item.add(new Component[]{new BuildLink("buildLink", (IModel<Build>)new LoadableDetachableModel<Build>(){

                        protected Build load() {
                            return ((Step)item.getModelObject()).getBuild();
                        }
                    })});
                } else {
                    item.add(new Component[]{new Label("buildLink", "<i>Not determined</i>").setEscapeModelStrings(false)});
                }
            }
        }});
    }

    private GridNode getNode() {
        return (GridNode)this.getDefaultModelObject();
    }

    private Map<Long, Configuration> getConfigurations() {
        return (Map)this.configurationsModel.getObject();
    }

    public void detachModels() {
        this.configurationsModel.detach();
        super.detachModels();
    }
}

