/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid;

import com.google.common.base.Strings;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.TokenManager;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Token;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.component.BookmarkableTextLink;
import com.pmease.quickbuild.web.component.TextLink;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.SearchNavToolbar;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.SearchPatternChanged;
import com.pmease.quickbuild.web.page.grid.GridPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackHeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NoRecordsToolbar;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class InactiveNodesPanel
extends Panel {
    private SelectionColumn<Token> selectionColumn;
    private IModel<String> patternModel = Model.of((Serializable)((Object)""));

    public InactiveNodesPanel(String panelId, final Long cloudProfileId) {
        super(panelId);
        this.setOutputMarkupId(true);
        this.setDefaultModel((IModel)new LoadableDetachableModel<List<Token>>(){

            protected List<Token> load() {
                List<Token> tokens = TokenManager.instance.getAll();
                if (cloudProfileId != null) {
                    Iterator it = tokens.iterator();
                    while (it.hasNext()) {
                        Token token = (Token)it.next();
                        if (token.getCloudProfile() != null && token.getCloudProfile().getId().equals(cloudProfileId)) continue;
                        it.remove();
                    }
                }
                HashSet<String> activeTokens = new HashSet<String>();
                for (GridNode each : AgentManager.instance.getBuildAgents()) {
                    activeTokens.add(each.getToken());
                }
                Iterator it = tokens.iterator();
                while (it.hasNext()) {
                    Token token = (Token)it.next();
                    if (!activeTokens.contains(token.getValue())) continue;
                    it.remove();
                }
                String pattern = (String)InactiveNodesPanel.this.patternModel.getObject();
                if (!Strings.isNullOrEmpty((String)pattern)) {
                    pattern = pattern.toLowerCase();
                    Iterator<Token> it2 = tokens.iterator();
                    while (it2.hasNext()) {
                        Token t = it2.next();
                        String hostName = t.getHostName();
                        if (hostName != null && hostName.toLowerCase().contains(pattern)) continue;
                        it2.remove();
                    }
                }
                return tokens;
            }
        });
        WebMarkupContainer actionsTrigger = new WebMarkupContainer("actions");
        actionsTrigger.setVisible(SecurityHelper.isAdmin());
        this.add(new Component[]{actionsTrigger});
        actionsTrigger.add(new Behavior[]{new MenuBehavior(){

            @Override
            protected List<MenuItem> getMenuItems() {
                ArrayList<MenuItem> items = new ArrayList<MenuItem>();
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Unauthorize Selected Nodes"))){

                            public void onClick() {
                                if (!InactiveNodesPanel.this.selectionColumn.getSelections().isEmpty()) {
                                    for (Token token : InactiveNodesPanel.this.selectionColumn.getSelections()) {
                                        TokenManager.instance.delete(token);
                                        AuditManager.instance.audit("Grid::Nodes", "Inactive node " + token.getHostName() + ":" + token.getPort() + " was unauthorized.");
                                    }
                                    InactiveNodesPanel.this.selectionColumn.getSelections().clear();
                                } else {
                                    this.getSession().warn((Serializable)((Object)"Please select nodes to unauthorize."));
                                }
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to unauthorize selected nodes?")});
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Terminate Selected Nodes"))){

                            public void onClick() {
                                if (!InactiveNodesPanel.this.selectionColumn.getSelections().isEmpty()) {
                                    boolean notEligiblesFound = false;
                                    for (Token token : InactiveNodesPanel.this.selectionColumn.getSelections()) {
                                        if (token.getCloudProfile() != null) {
                                            token.getCloudProfile().getNodeLauncher().terminateNode(token.getNodeLaunchId());
                                            TokenManager.instance.delete(token);
                                            AuditManager.instance.audit("Grid::Nodes", "Inactive node '" + token.getAddress() + "' was terminated.");
                                            continue;
                                        }
                                        notEligiblesFound = true;
                                    }
                                    InactiveNodesPanel.this.selectionColumn.getSelections().clear();
                                    if (notEligiblesFound) {
                                        this.getSession().warn((Serializable)((Object)"Some of the selected nodes can not be terminated as they are not launched by cloud profiles."));
                                    } else {
                                        this.getSession().info((Serializable)((Object)"Terminating requests have been sent to selected nodes."));
                                    }
                                } else {
                                    this.getSession().warn((Serializable)((Object)"Please select nodes to terminate."));
                                }
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("This will forcibly terminate selected nodes even if they are still being used by builds. Do you really want to continue?")});
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Unauthorize All Nodes"))){

                            public void onClick() {
                                for (Token token : InactiveNodesPanel.this.getInactiveTokens()) {
                                    TokenManager.instance.delete(token);
                                }
                                AuditManager.instance.audit("Grid::Nodes", "All inactive nodes were unauthorized.");
                                InactiveNodesPanel.this.getDefaultModel().detach();
                                InactiveNodesPanel.this.selectionColumn.getSelections().clear();
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to unauthorize all inactive nodes?")});
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new TextLink<Void>(componentId, (IModel)Model.of((Serializable)((Object)"Terminate All Nodes"))){

                            public void onClick() {
                                for (Token token : InactiveNodesPanel.this.getInactiveTokens()) {
                                    if (token.getCloudProfile() == null) continue;
                                    token.getCloudProfile().getNodeLauncher().terminateNode(token.getNodeLaunchId());
                                    TokenManager.instance.delete(token);
                                    AuditManager.instance.audit("Grid::Nodes", "Inactive node '" + token.getAddress() + "' was terminated.");
                                }
                                this.getSession().info((Serializable)((Object)"Terminating requests have been sent to all nodes launched by cloud profiles."));
                            }
                        }.add(new Behavior[]{new ConfirmBehavior("This will forcibly terminate all nodes launched by cloud profiles even if they are still being used by builds. Do you really want to continue?")});
                    }
                });
                return items;
            }
        }});
        ArrayList<Object> columns = new ArrayList<Object>();
        if (SecurityHelper.isAdmin()) {
            this.selectionColumn = new SelectionColumn();
            columns.add(this.selectionColumn);
        }
        columns.add(new AbstractColumn<Token>((IModel)new Model((Serializable)((Object)"Address")), "address"){

            public void populateItem(Item<ICellPopulator<Token>> cellItem, String componentId, IModel<Token> rowModel) {
                Token token = (Token)rowModel.getObject();
                if (token.getPort() != 0) {
                    cellItem.add(new Component[]{new Label(componentId, token.getAddress())});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "<i>Unknown</i>").setEscapeModelStrings(false)});
                }
            }
        });
        columns.add(new AbstractColumn<Token>((IModel)new Model((Serializable)((Object)"Host Name")), "hostName"){

            public void populateItem(Item<ICellPopulator<Token>> cellItem, String componentId, IModel<Token> rowModel) {
                Token token = (Token)rowModel.getObject();
                if (token.getPort() != 0) {
                    cellItem.add(new Component[]{new Label(componentId, token.getHostName())});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "<i>Unknown</i>").setEscapeModelStrings(false)});
                }
            }
        });
        columns.add(new AbstractColumn<Token>((IModel)new Model((Serializable)((Object)"IP")), "ip"){

            public void populateItem(Item<ICellPopulator<Token>> cellItem, String componentId, IModel<Token> rowModel) {
                Token token = (Token)rowModel.getObject();
                if (token.getPort() != 0) {
                    cellItem.add(new Component[]{new Label(componentId, token.getIp())});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "<i>Unknown</i>").setEscapeModelStrings(false)});
                }
            }
        });
        columns.add(new AbstractColumn<Token>((IModel)new Model((Serializable)((Object)"Port")), "port"){

            public void populateItem(Item<ICellPopulator<Token>> cellItem, String componentId, IModel<Token> rowModel) {
                Token token = (Token)rowModel.getObject();
                if (token.getPort() != 0) {
                    cellItem.add(new Component[]{new Label(componentId, String.valueOf(token.getPort()))});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "<i>Unknown</i>").setEscapeModelStrings(false)});
                }
            }
        });
        if (cloudProfileId == null) {
            columns.add(new AbstractColumn<Token>((IModel)new Model((Serializable)((Object)"Cloud Profile")), "cloudProfile"){

                public void populateItem(Item<ICellPopulator<Token>> cellItem, String componentId, IModel<Token> rowModel) {
                    Token token = (Token)rowModel.getObject();
                    if (token.getCloudProfile() != null) {
                        Fragment linkFrag = new Fragment(componentId, "linkFrag", (MarkupContainer)InactiveNodesPanel.this);
                        linkFrag.add(new Component[]{new BookmarkableTextLink("link", token.getCloudProfile().getName(), GridPage.class, GridPage.params4Profile(token.getCloudProfile().getId()))});
                        cellItem.add(new Component[]{linkFrag});
                    } else {
                        cellItem.add(new Component[]{new Label(componentId, "<i>N/A</i>").setEscapeModelStrings(false)});
                    }
                }
            });
        }
        columns.add(new AbstractColumn<Token>((IModel)new Model((Serializable)((Object)"Launch Id")), "nodeLaunchId"){

            public void populateItem(Item<ICellPopulator<Token>> cellItem, String componentId, IModel<Token> rowModel) {
                Token token = (Token)rowModel.getObject();
                if (token.getNodeLaunchId() != null) {
                    cellItem.add(new Component[]{new Label(componentId, token.getNodeLaunchId())});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "<i>N/A</i>").setEscapeModelStrings(false)});
                }
            }
        });
        columns.add(new AbstractColumn<Token>((IModel)new Model((Serializable)((Object)"Test Launch")), "test"){

            public void populateItem(Item<ICellPopulator<Token>> cellItem, String componentId, IModel<Token> rowModel) {
                Token token = (Token)rowModel.getObject();
                if (token.getNodeLaunchId() != null) {
                    cellItem.add(new Component[]{new Label(componentId, String.valueOf(token.isTest()))});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "<i>N/A</i>").setEscapeModelStrings(false)});
                }
            }
        });
        DataProvider<Token> dataProvider = new DataProvider<Token>(){

            public Iterator<Token> iterator(int first, int count) {
                List tokens = InactiveNodesPanel.this.getInactiveTokens();
                Collections.sort(tokens, new Comparator<Token>(){

                    @Override
                    public int compare(Token token1, Token token2) {
                        int result;
                        if (this.getSort() != null) {
                            if (this.getSort().getProperty().equals("address")) {
                                result = token1.getAddress().compareTo(token2.getAddress());
                            } else if (this.getSort().getProperty().equals("hostName")) {
                                result = token1.getHostName().compareTo(token2.getHostName());
                            } else if (this.getSort().getProperty().equals("ip")) {
                                result = token1.getIp().compareTo(token2.getIp());
                            } else if (this.getSort().getProperty().equals("port")) {
                                result = token1.getPort() - token2.getPort();
                            } else if (this.getSort().getProperty().equals("test")) {
                                result = String.valueOf(token1.isTest()).compareTo(String.valueOf(token2.isTest()));
                            } else {
                                throw new QuickbuildException("Unrecognized sort property: " + this.getSort().getProperty());
                            }
                            if (!this.getSort().isAscending()) {
                                result *= -1;
                            }
                        } else {
                            result = token1.getAddress().compareTo(token2.getAddress());
                        }
                        return result;
                    }
                });
                return tokens.subList(first, first + count).iterator();
            }

            public int size() {
                return InactiveNodesPanel.this.getInactiveTokens().size();
            }
        };
        DataTable table = new DataTable("nodes", columns, (IDataProvider)dataProvider, 100);
        table.setOutputMarkupId(true);
        table.addTopToolbar((AbstractToolbar)new AjaxFallbackHeadersToolbar(table, (ISortStateLocator)dataProvider));
        table.addTopToolbar((AbstractToolbar)new SearchNavToolbar(table));
        table.addTopToolbar((AbstractToolbar)new NoRecordsToolbar(table, (IModel)Model.of((Serializable)((Object)"No nodes found"))));
        table.addBottomToolbar((AbstractToolbar)new SearchNavToolbar(table));
        this.add(new Component[]{table});
        WebMarkupContainer breadcrumbs = new WebMarkupContainer("breadcrumbs"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisibilityAllowed(!Strings.isNullOrEmpty((String)((String)InactiveNodesPanel.this.patternModel.getObject())));
            }
        };
        this.add(new Component[]{breadcrumbs});
        breadcrumbs.add(new Component[]{new AjaxLink<Void>("allLink"){

            public void onClick(AjaxRequestTarget target) {
                this.send((IEventSink)this.getPage(), Broadcast.DEPTH, SearchPatternChanged.of(target, ""));
            }
        }});
        breadcrumbs.add(new Component[]{new Label("pattern", this.patternModel)});
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof SearchPatternChanged) {
            SearchPatternChanged event = (SearchPatternChanged)sink.getPayload();
            this.patternModel.setObject((Object)event.getPattern());
            event.getTarget().add(new Component[]{this});
        }
    }

    private List<Token> getInactiveTokens() {
        return (List)this.getDefaultModelObject();
    }

    public void onDetach() {
        super.onDetach();
        if (this.patternModel != null) {
            this.patternModel.detach();
        }
    }
}

