/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.CloudProfileManager;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.component.tabbedpanel.GroupingTab;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.pmease.quickbuild.web.component.tabbedpanel.TabbedPanel;
import com.pmease.quickbuild.web.page.MainPage;
import com.pmease.quickbuild.web.page.grid.GridNodePanel;
import com.pmease.quickbuild.web.page.grid.GridTabContribution;
import com.pmease.quickbuild.web.page.grid.InactiveNodesPanel;
import com.pmease.quickbuild.web.page.grid.UnauthorizedNodesPanel;
import com.pmease.quickbuild.web.page.grid.UserAgentsOverview;
import com.pmease.quickbuild.web.page.grid.cloud.CloudProfilePanel;
import com.pmease.quickbuild.web.page.grid.cloud.CloudProfilesOverview;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class GridPage
extends MainPage {
    private PageParameters params;
    private static final String RESOURCES = "resources";
    private static final String ACTIVE_NODES = "active_nodes";
    private static final String INACTIVE_NODES = "inactive_nodes";
    private static final String USER_AGENTS = "user_agents";
    private static final String UNAUTHORIZED_NODES = "unauthorized_nodes";
    private static final String CLOUD_PROFILES = "cloud_profiles";

    public static PageParameters params4(String[] tabIds) {
        PageParameters params = new PageParameters();
        for (int i = 0; i < tabIds.length; ++i) {
            try {
                params.set(i, (Object)URLEncoder.encode(tabIds[i], "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return params;
    }

    public static PageParameters params4Resources() {
        return new PageParameters().set(0, (Object)RESOURCES);
    }

    public static PageParameters params4(String nodeAddress) {
        GridNode node = Grid.instance.getNode(nodeAddress);
        if (node != null) {
            if (node.isServer() || node.isBuildAgent()) {
                return GridPage.params4(new String[]{ACTIVE_NODES, nodeAddress});
            }
            return GridPage.params4(new String[]{USER_AGENTS, nodeAddress});
        }
        return new PageParameters();
    }

    public static PageParameters params4(String nodeAddress, String nodeTabId) {
        GridNode node = Grid.instance.getNode(nodeAddress);
        if (node != null) {
            if (node.isServer() || node.isBuildAgent()) {
                return GridPage.params4(new String[]{ACTIVE_NODES, nodeAddress, nodeTabId});
            }
            return GridPage.params4(new String[]{USER_AGENTS, nodeAddress, nodeTabId});
        }
        return new PageParameters();
    }

    public static PageParameters params4Profile(Long profileId, String profileTabId) {
        return GridPage.params4(new String[]{CLOUD_PROFILES, profileId.toString(), profileTabId});
    }

    public static PageParameters params4Profile(Long profileId) {
        return GridPage.params4(new String[]{CLOUD_PROFILES, profileId.toString()});
    }

    public static PageParameters params4(String nodeAddress, String nodeTabId, String nodeTabParam) {
        GridNode node = Grid.instance.getNode(nodeAddress);
        if (node != null) {
            if (node.isServer() || node.isBuildAgent()) {
                return GridPage.params4(new String[]{ACTIVE_NODES, nodeAddress, nodeTabId, nodeTabParam});
            }
            return GridPage.params4(new String[]{USER_AGENTS, nodeAddress, nodeTabId, nodeTabParam});
        }
        return new PageParameters();
    }

    public GridPage() {
        this(new PageParameters());
    }

    public GridPage(PageParameters params) {
        this.params = params;
    }

    private String decode(String encoded) {
        if (encoded != null) {
            try {
                return URLDecoder.decode(encoded, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return encoded;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        WebMarkupContainer toolbar = new WebMarkupContainer("toolbar");
        toolbar.setVisible(SecurityHelper.isAdmin());
        this.add(new Component[]{toolbar});
        toolbar.add(new Component[]{new WebMarkupContainer("downloadAgent").add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                Fragment frag = new Fragment(componentId, "agentDownloadFrag", (MarkupContainer)GridPage.this);
                frag.add(new Component[]{new WebMarkupContainer("installServiceUrl").add(new Behavior[]{new AttributeModifier("href", (Serializable)((Object)(Bootstrap.docroot + "/Install+As+System+Service")))})});
                return frag;
            }
        }})});
        this.newCreateTabs();
    }

    void newCreateTabs() {
        String category = this.decode(this.params.get(0).toString());
        String item = this.decode(this.params.get(1).toString());
        final String itemTabId = this.decode(this.params.get(2).toString());
        final String itemTabParam = this.decode(this.params.get(3).toString());
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        List<GridTabContribution> contributions = PluginManager.instance.getExtensions(GridTabContribution.class);
        for (GridTabContribution each : contributions) {
            tabs.addAll(each.getTabs());
        }
        int inactiveCount = CacheManager.instance.getTokenCount() - AgentManager.instance.getBuildAgentCount();
        if (inactiveCount < 0) {
            inactiveCount = 0;
        }
        tabs.add(new Tab(INACTIVE_NODES, "Inactive Nodes (" + inactiveCount + ")"){

            @Override
            public Panel getPanel(String panelId, Map<String, String> panelParams) {
                return new InactiveNodesPanel(panelId, null);
            }
        });
        tabs.add(new Tab(UNAUTHORIZED_NODES, "Unauthorized Nodes (" + AgentManager.instance.getUnauthorizedAgentCount() + ")"){

            @Override
            public Panel getPanel(String panelId, Map<String, String> panelParams) {
                return new UnauthorizedNodesPanel(panelId);
            }
        });
        ArrayList<Tab> children = new ArrayList<Tab>();
        children.add(new Tab("Overview"){

            @Override
            public Panel getPanel(String panelId, Map<String, String> panelParams) {
                return new CloudProfilesOverview(panelId);
            }
        });
        List<CloudProfile> cloudProfiles = CacheManager.instance.getCloudProfiles();
        Collections.sort(cloudProfiles, new Comparator<CloudProfile>(){

            @Override
            public int compare(CloudProfile profile1, CloudProfile profile2) {
                return profile1.getName().compareTo(profile2.getName());
            }
        });
        for (CloudProfile profile : cloudProfiles) {
            children.add(new Tab(profile.getId().toString(), profile.getName()){

                @Override
                public Panel getPanel(String panelId, Map<String, String> panelParams) {
                    CloudProfile profile = (CloudProfile)CloudProfileManager.instance.load(Long.valueOf(this.getId()));
                    return new CloudProfilePanel(panelId, profile, itemTabId, itemTabParam);
                }
            });
        }
        GroupingTab cloudProfilesTab = new GroupingTab(CLOUD_PROFILES, "Cloud Profiles (" + cloudProfiles.size() + ")", children);
        tabs.add(cloudProfilesTab);
        children = new ArrayList();
        children.add(new Tab("Overview"){

            @Override
            public Panel getPanel(String panelId, Map<String, String> panelParams) {
                return new UserAgentsOverview(panelId);
            }
        });
        List<GridNode> userAgents = AgentManager.instance.getUserAgents();
        Collections.sort(userAgents, new Comparator<GridNode>(){

            @Override
            public int compare(GridNode node1, GridNode node2) {
                return node1.getAddress().compareTo(node2.getAddress());
            }
        });
        for (GridNode agent : userAgents) {
            children.add(new Tab(agent.getAddress(), agent.getAddress()){

                @Override
                public Panel getPanel(String panelId, Map<String, String> panelParams) {
                    return new GridNodePanel(panelId, this.getId(), itemTabId, itemTabParam);
                }
            });
        }
        GroupingTab userAgentsTab = new GroupingTab(USER_AGENTS, "User Agents (" + AgentManager.instance.getUserAgentCount() + ")", children);
        tabs.add(userAgentsTab);
        Collections.sort(tabs, new Comparator<Tab>(){

            @Override
            public int compare(Tab o1, Tab o2) {
                return o1.getOrder() - o2.getOrder();
            }
        });
        this.add(new Component[]{new TabbedPanel("tabs", tabs, new String[]{category, item}){

            @Override
            protected WebMarkupContainer newTabLink(String linkId, String[] tabIds) {
                return new BookmarkablePageLink(linkId, GridPage.class, GridPage.params4(tabIds));
            }
        }});
    }
}

