/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.grid;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.log.NodeLog;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.component.LogPanel;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.pmease.quickbuild.web.component.tabbedpanel.TabbedPanel;
import com.pmease.quickbuild.web.page.grid.GridNodeModel;
import com.pmease.quickbuild.web.page.grid.GridPage;
import com.pmease.quickbuild.web.page.grid.RunningStepsPanel;
import com.pmease.quickbuild.web.page.grid.SystemAttributePanel;
import com.pmease.quickbuild.web.page.grid.UserAttributeEdit;
import com.pmease.quickbuild.web.page.grid.resource.NodeResourcesPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class GridNodePanel
extends Panel {
    public static final String SYSTEM_ATTRIBUTES = "system_attributes";
    public static final String USER_ATTRIBUTES = "user_attributes";
    public static final String RESOURCES = "resources";
    public static final String STEPS = "steps";
    public static final String LOG = "log";

    public GridNodePanel(String panelId, String nodeAddress) {
        this(panelId, nodeAddress, null, null);
    }

    public GridNodePanel(String panelId, final String nodeAddress, final String tabId, final String tabParam) {
        super(panelId);
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        if (SecurityHelper.isNodeAttributesAllowed(Context.getUser())) {
            tabs.add(new Tab(SYSTEM_ATTRIBUTES, "System Attributes"){

                @Override
                public Panel getPanel(String panelId, Map<String, String> panelParams) {
                    return new SystemAttributePanel(panelId, (IModel<GridNode>)new GridNodeModel(nodeAddress));
                }
            });
            tabs.add(new Tab(USER_ATTRIBUTES, "User Attributes"){

                @Override
                public Panel getPanel(String panelId, Map<String, String> panelParams) {
                    return new UserAttributeEdit(panelId, (IModel<GridNode>)new GridNodeModel(nodeAddress));
                }
            });
        }
        tabs.add(new Tab(RESOURCES, "Resources"){

            @Override
            public Panel getPanel(String panelId, Map<String, String> params) {
                return new NodeResourcesPanel(panelId, (IModel<GridNode>)new GridNodeModel(nodeAddress));
            }
        });
        tabs.add(new Tab(STEPS, "Running Steps"){

            @Override
            public Panel getPanel(String panelId, Map<String, String> params) {
                return new RunningStepsPanel(panelId, (IModel<GridNode>)new GridNodeModel(nodeAddress));
            }
        });
        if (SecurityHelper.isSystemLogAllowed()) {
            String title = nodeAddress.equals(Grid.instance.getServerNode().getAddress()) ? "Server Log" : "Agent Log";
            tabs.add(new Tab(LOG, title){

                @Override
                public Panel getPanel(String panelId, Map<String, String> params) {
                    Date anchorDate = this.getId().equals(tabId) && tabParam != null ? new Date(Long.parseLong(tabParam)) : null;
                    return new LogPanel(panelId, (IModel<? extends Log>)new Model((Serializable)new NodeLog(nodeAddress, anchorDate)), false);
                }
            });
        }
        if (tabId != null) {
            this.add(new Component[]{new TabbedPanel("tabs", tabs, new String[]{tabId}){

                @Override
                protected WebMarkupContainer newTabLink(String linkId, String[] tabIds) {
                    return new BookmarkablePageLink(linkId, GridPage.class, GridPage.params4(nodeAddress, tabIds[0]));
                }
            }});
        } else {
            this.add(new Component[]{new TabbedPanel("tabs", tabs){

                @Override
                protected WebMarkupContainer newTabLink(String linkId, String[] tabIds) {
                    return new BookmarkablePageLink(linkId, GridPage.class, GridPage.params4(nodeAddress, tabIds[0]));
                }
            }});
        }
    }
}

