/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.find;

import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.component.BookmarkableTextLink;
import com.pmease.quickbuild.web.component.build.BuildDurationPanel;
import com.pmease.quickbuild.web.component.build.BuildInfoPanel;
import com.pmease.quickbuild.web.component.configuration.ConfigurationLink;
import com.pmease.quickbuild.web.component.datatablesupport.EntityColumn;
import com.pmease.quickbuild.web.component.datatablesupport.EntityProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.MainPage;
import com.pmease.quickbuild.web.page.find.SearchBuildsOption;
import com.pmease.quickbuild.web.page.grid.GridPage;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class SearchBuildsPage
extends MainPage {
    private SearchBuildsOption findOption;
    private SelectionColumn<Long> selectionColumn;

    public SearchBuildsPage(SearchBuildsOption findOption) {
        this.findOption = findOption;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        final EditContext editContext = new EditContext(this.findOption != null ? this.findOption : new SearchBuildsOption());
        Form<Void> form = new Form<Void>("optionForm"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    SearchBuildsPage.this.findOption = new SearchBuildsOption();
                    editContext.update(SearchBuildsPage.this.findOption);
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        this.add(new Component[]{form});
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        this.add(new Component[]{new Label("title", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                if (SearchBuildsPage.this.findOption == null) {
                    return "Please Specify Find Option and Hit the Find Button";
                }
                return "Found Builds";
            }
        })});
        WebMarkupContainer operations = new WebMarkupContainer("operations"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.isAdmin() && SearchBuildsPage.this.findOption != null);
            }
        };
        this.add(new Component[]{operations});
        Component[] componentArray = new Component[1];
        Link link = new Link<Void>("deleteSelected"){

            public void onClick() {
                if (!SearchBuildsPage.this.selectionColumn.getSelections().isEmpty()) {
                    boolean runningsFound = false;
                    for (Long buildId : SearchBuildsPage.this.selectionColumn.getSelections()) {
                        Build build = (Build)BuildManager.instance.load(buildId);
                        if (build.isRunning()) {
                            runningsFound = true;
                            continue;
                        }
                        BuildManager.instance.delete(build);
                        AuditManager.instance.audit(build.getConfiguration(), "Build " + build.getVersion() + " (#" + build.getId() + ") was deleted.");
                    }
                    if (runningsFound) {
                        this.getSession().warn((Serializable)((Object)"Builds can only be deleted after they are stopped."));
                    }
                    SearchBuildsPage.this.selectionColumn.getSelections().clear();
                } else {
                    this.getSession().warn((Serializable)((Object)"Please select finished builds to delete."));
                }
            }
        };
        componentArray[0] = link;
        operations.add(componentArray);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete selected builds?")});
        Component[] componentArray2 = new Component[1];
        link = new Link<Void>("deleteAll"){

            public void onClick() {
                boolean runningsFound = false;
                SearchCriteria criteria = new SearchCriteria(SearchBuildsPage.this.findOption.getCriterions());
                for (Build build : BuildManager.instance.search(criteria, 0, 0)) {
                    if (build.isRunning()) {
                        runningsFound = true;
                        continue;
                    }
                    BuildManager.instance.delete(build);
                    AuditManager.instance.audit(build.getConfiguration(), "Build " + build.getVersion() + " (#" + build.getId() + ") was deleted.");
                }
                if (runningsFound) {
                    this.getSession().warn((Serializable)((Object)"Running builds can only be deleted after they are stopped."));
                }
            }
        };
        componentArray2[0] = link;
        operations.add(componentArray2);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete all finished builds?")});
        ArrayList<Object> columns = new ArrayList<Object>();
        if (SecurityHelper.isAdmin()) {
            this.selectionColumn = new SelectionColumn();
            columns.add(this.selectionColumn);
        }
        columns.add(new EntityColumn(Build.class, "id", true));
        columns.add(new EntityColumn(Build.class, "version", true){

            @Override
            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                final Long buildId = (Long)rowModel.getObject();
                cellItem.add(new Component[]{new BuildInfoPanel(componentId, (IModel<Build>)new AbstractReadOnlyModel<Build>(){

                    public Build getObject() {
                        return (Build)BuildManager.instance.load(buildId);
                    }
                }).showProgress(false).showStopButton(false).showAge(false).showDuration(false)});
            }
        });
        columns.add(new AbstractColumn<Long>((IModel)new Model((Serializable)((Object)"Master Node"))){

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                Build build = (Build)BuildManager.instance.load((Long)rowModel.getObject());
                String masterNode = build.getMasterStep().getNodeAddress();
                cellItem.add(new Component[]{new BookmarkableTextLink(componentId, masterNode, GridPage.class, GridPage.params4(masterNode)).add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"link"))})});
            }
        });
        columns.add(new EntityColumn(Build.class, "duration", true){

            @Override
            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                final Long buildId = (Long)rowModel.getObject();
                cellItem.add(new Component[]{new BuildDurationPanel(componentId, (IModel<Build>)new AbstractReadOnlyModel<Build>(){

                    public Build getObject() {
                        return (Build)BuildManager.instance.load(buildId);
                    }
                })});
            }
        });
        columns.add(new EntityColumn(Build.class, "beginDate", true){

            @Override
            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                final Long buildId = (Long)rowModel.getObject();
                cellItem.add(new Component[]{new Label(componentId, (IModel)new AbstractReadOnlyModel<String>(){

                    public String getObject() {
                        return DateUtils.formatDateTime(((Build)BuildManager.instance.load(buildId)).getBeginDate());
                    }
                })});
            }
        });
        columns.add(new AbstractColumn<Long>((IModel)new Model((Serializable)((Object)"Triggered By"))){

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                Build build = (Build)BuildManager.instance.load((Long)rowModel.getObject());
                cellItem.add(new Component[]{new Label(componentId, build.getRequesterName())});
            }
        });
        columns.add(new AbstractColumn<Long>((IModel)new Model((Serializable)((Object)"Configuration"))){

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, final IModel<Long> rowModel) {
                cellItem.add(new Component[]{new ConfigurationLink(componentId, (IModel<Configuration>)new LoadableDetachableModel<Configuration>(){

                    protected Configuration load() {
                        return ((Build)BuildManager.instance.load((Long)rowModel.getObject())).getConfiguration();
                    }
                })});
            }
        });
        this.add(new Component[]{new DefaultDataTable<Long>("builds", columns, (ISortableDataProvider)new EntityProvider(Build.class, new SortParam("id", false)){

            @Override
            protected Criterion[] getCriterions() {
                if (SearchBuildsPage.this.findOption != null) {
                    return SearchBuildsPage.this.findOption.getCriterions();
                }
                return new Criterion[]{Restrictions.eq((String)"id", (Object)0L)};
            }
        }, 25){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SearchBuildsPage.this.findOption != null);
            }
        }});
    }
}

