/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.find;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class SearchBuildsOption
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String version;
    private Build.Status status;
    private Date fromDate;
    private Date toDate;
    private Configuration configuration;
    private boolean recursive;
    private User user;

    @Editable(order=100, description="Specify a string to match the build version. The version can be prefixed or suffixed with character '*' to support partial match.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Editable(order=200, description="Optionally specify status to match.")
    public Build.Status getStatus() {
        return this.status;
    }

    public void setStatus(Build.Status status) {
        this.status = status;
    }

    @Editable(order=300, description="Format of date is of <em>yyyy-MM-dd</em>. For example, <em>2009-01-31</em>.")
    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    @Editable(order=350, description="Format of date is of <em>yyyy-MM-dd</em>. For example, <em>2009-01-31</em>.")
    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    @Editable(order=400, description="Specify the configuration to search builds under. If left empty, all configurations will be searched.")
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Editable(order=450, description="Whether or not search recursively. If set to yes, builds will also be searched in descendents of the configuration specified above.")
    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Editable(order=500, name="Triggered By", description="Optionally specify the user who triggered the build.")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Criterion[] getCriterions() {
        Configuration configuration;
        ArrayList<Object> criterions = new ArrayList<Object>();
        if (this.getVersion() != null) {
            if (this.getVersion().indexOf(42) != -1) {
                criterions.add(Restrictions.like((String)"version", (Object)this.getVersion().replace('*', '%')));
            } else {
                criterions.add(Restrictions.eq((String)"version", (Object)this.getVersion()));
            }
        }
        if ((configuration = this.getConfiguration()) != null) {
            if (this.isRecursive()) {
                ArrayList<Long> configurationIds = new ArrayList<Long>();
                configurationIds.add(configuration.getId());
                CacheManager cacheManager = Quickbuild.getInstance(CacheManager.class);
                for (Configuration each : cacheManager.getDescendents(configuration.getId())) {
                    configurationIds.add(each.getId());
                }
                criterions.add(Restrictions.in((String)"configuration.id", configurationIds));
            } else {
                criterions.add(Restrictions.eq((String)"configuration.id", (Object)configuration.getId()));
            }
        }
        if (this.getUser() != null) {
            criterions.add(Restrictions.eq((String)"requester", (Object)this.getUser()));
        }
        if (this.getStatus() != null) {
            criterions.add(Restrictions.eq((String)"status", (Object)((Object)this.getStatus())));
        }
        if (this.getFromDate() != null) {
            criterions.add(Restrictions.ge((String)"beginDate", (Object)this.getFromDate()));
        }
        if (this.getToDate() != null) {
            criterions.add(Restrictions.le((String)"beginDate", (Object)this.getToDate()));
        }
        return criterions.toArray(new Criterion[criterions.size()]);
    }
}

