/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.find;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.taskschedule.schedule.Schedule;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.component.MultilineText;
import com.pmease.quickbuild.web.component.build.BuildLink;
import com.pmease.quickbuild.web.component.configuration.ConfigurationLink;
import com.pmease.quickbuild.web.page.MainPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class FoundConfigurationsPage
extends MainPage {
    private IModel<List<Configuration>> foundConfigurationsModel;

    public FoundConfigurationsPage(final String searchString) {
        super(searchString);
        this.foundConfigurationsModel = new LoadableDetachableModel<List<Configuration>>(){

            protected List<Configuration> load() {
                ArrayList<Configuration> configurations = new ArrayList<Configuration>();
                if (searchString != null) {
                    for (Configuration each : FoundConfigurationsPage.this.getConfigurations().values()) {
                        if (!StringUtils.matchPath(searchString.toLowerCase(), each.getPathName().toLowerCase())) continue;
                        configurations.add(each);
                    }
                }
                Collections.sort(configurations, new Comparator<Configuration>(){

                    @Override
                    public int compare(Configuration o1, Configuration o2) {
                        return o1.getId().compareTo(o2.getId());
                    }
                });
                return configurations;
            }
        };
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Label("title", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                if (FoundConfigurationsPage.this.getSearchString() == null) {
                    return "Please Specify Search String";
                }
                return "Configurations Matching \"" + FoundConfigurationsPage.this.getSearchString() + "\"";
            }
        })});
        ArrayList<AbstractColumn> columns = new ArrayList<AbstractColumn>();
        columns.add(new AbstractColumn<Configuration>((IModel)Model.of((Serializable)((Object)"Id"))){

            public void populateItem(Item<ICellPopulator<Configuration>> cellItem, String componentId, IModel<Configuration> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, ((Configuration)rowModel.getObject()).getId().toString())});
            }
        });
        columns.add(new AbstractColumn<Configuration>((IModel)Model.of((Serializable)((Object)"Path"))){

            public void populateItem(Item<ICellPopulator<Configuration>> cellItem, String componentId, final IModel<Configuration> rowModel) {
                cellItem.add(new Component[]{new ConfigurationLink(componentId, (IModel<Configuration>)new AbstractReadOnlyModel<Configuration>(){

                    public Configuration getObject() {
                        return (Configuration)rowModel.getObject();
                    }
                })});
            }
        });
        columns.add(new AbstractColumn<Configuration>((IModel)new Model((Serializable)((Object)"Description"))){

            public void populateItem(Item<ICellPopulator<Configuration>> cellItem, String componentId, IModel<Configuration> rowModel) {
                Configuration configuration = (Configuration)rowModel.getObject();
                cellItem.add(new Component[]{new MultilineText(componentId, configuration.getDescription())});
            }
        });
        columns.add(new AbstractColumn<Configuration>((IModel)new Model((Serializable)((Object)"Schedule"))){

            public void populateItem(Item<ICellPopulator<Configuration>> cellItem, String componentId, IModel<Configuration> rowModel) {
                Configuration configuration = (Configuration)rowModel.getObject();
                Schedule schedule = configuration.findSchedule();
                if (schedule != null) {
                    cellItem.add(new Component[]{new Label(componentId, schedule.toString())});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "<i>No schedule</i>").setEscapeModelStrings(false)});
                }
            }
        });
        columns.add(new AbstractColumn<Configuration>((IModel)new Model((Serializable)((Object)"Latest Build"))){

            public void populateItem(Item<ICellPopulator<Configuration>> cellItem, String componentId, IModel<Configuration> rowModel) {
                Configuration configuration = (Configuration)rowModel.getObject();
                Build build = CacheManager.instance.getLatestBuild(configuration.getId());
                if (build != null) {
                    build.setConfiguration(configuration);
                    cellItem.add(new Component[]{new BuildLink(componentId, (IModel<Build>)Model.of((Serializable)build))});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "<i>No builds</i>").setEscapeModelStrings(false)});
                }
            }
        });
        this.add(new Component[]{new DefaultDataTable<Configuration>("configurations", columns, (ISortableDataProvider)new ISortableDataProvider<Configuration>(){

            public Iterator<? extends Configuration> iterator(int first, int count) {
                return FoundConfigurationsPage.this.getFoundConfigurations().subList(first, first + count).iterator();
            }

            public int size() {
                return FoundConfigurationsPage.this.getFoundConfigurations().size();
            }

            public IModel<Configuration> model(Configuration object) {
                return Model.of((Serializable)object);
            }

            public void detach() {
            }

            public ISortState getSortState() {
                return null;
            }
        }, 25){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(FoundConfigurationsPage.this.getSearchString() != null);
            }
        }});
    }

    private List<Configuration> getFoundConfigurations() {
        return (List)this.foundConfigurationsModel.getObject();
    }

    @Override
    protected void onDetach() {
        this.foundConfigurationsModel.detach();
        super.onDetach();
    }
}

