/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.error;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.page.BasePage;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

public class BugReportPage
extends BasePage {
    private static final long serialVersionUID = 1L;
    private Exception exception;

    public BugReportPage(Exception exception) {
        this.exception = exception;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        Label description = new Label("description", "Error Details: \n\n" + StringUtils.replace((String)Strings.toString((Throwable)this.exception), (String)"    ", (String)"\t"));
        description.setRenderBodyOnly(true);
        this.add(new Component[]{description});
        this.add(new Component[]{new WebMarkupContainer("contactName"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                User user = Context.getUser();
                if (user != null) {
                    tag.put("value", (CharSequence)user.getDisplayName());
                }
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("contactEmail"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                User user = Context.getUser();
                if (user != null) {
                    tag.put("value", (CharSequence)user.getEmail());
                }
            }
        }});
        final ArrayList<Pair<String, String>> serverProps = new ArrayList<Pair<String, String>>();
        try {
            serverProps.add(new Pair<String, String>("Host Name", InetAddress.getLocalHost().getHostName()));
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        serverProps.add(new Pair<String, String>("System Date and Time", DateUtils.formatDateTime(new Date())));
        serverProps.add(new Pair<String, String>("Operating System", System.getProperty("os.name") + " " + System.getProperty("os.version") + ", " + System.getProperty("os.arch")));
        serverProps.add(new Pair<String, String>("OS User Name", System.getProperty("user.name")));
        serverProps.add(new Pair<String, String>("JVM", System.getProperty("java.vm.name") + " " + System.getProperty("java.version") + ", " + System.getProperty("java.vm.vendor")));
        serverProps.add(new Pair<String, String>("QuickBuild Version", Bootstrap.buildVersion + " - " + Bootstrap.releaseDate));
        User user = Context.getUser();
        if (user != null) {
            serverProps.add(new Pair<String, String>("Current User", user.getName()));
        } else {
            serverProps.add(new Pair<String, String>("Current User", "<anonymous>"));
        }
        serverProps.add(new Pair<String, String>("Total Memory", FileUtils.byteCountToDisplaySize(Runtime.getRuntime().maxMemory())));
        serverProps.add(new Pair<String, String>("Used Memory", FileUtils.byteCountToDisplaySize(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())));
        serverProps.add(new Pair<String, String>("Configurations", "" + Quickbuild.getInstance(ConfigurationManager.class).count()));
        this.add(new Component[]{new ListView("props", (IModel)new Model((Serializable)serverProps)){

            protected void populateItem(ListItem item) {
                Pair pair = (Pair)item.getModelObject();
                item.add(new Component[]{new Label("name", (String)pair.getFirst())});
                item.add(new Component[]{new Label("value", (String)pair.getSecond())});
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("dashboardUrl"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("value", (CharSequence)Quickbuild.getInstance().getUrl());
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("additionalInfo"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String serverInfo = "";
                for (Pair pair : serverProps) {
                    serverInfo = serverInfo + (String)pair.getFirst() + ": " + (String)pair.getSecond() + "\n";
                }
                tag.put("value", (CharSequence)serverInfo);
            }
        }});
    }

    @Override
    protected String getBodyCssClass() {
        return "red-body";
    }

    @Override
    protected boolean isAuthorized() {
        return true;
    }

    public boolean isErrorPage() {
        return true;
    }
}

