/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.dashboard;

import com.pmease.quickbuild.entitymanager.DashboardManager;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Dashboard;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.component.LazyLoadPanel;
import com.pmease.quickbuild.web.component.dialog.Dialog;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.dashboard.DashboardPage;
import com.pmease.quickbuild.web.page.dashboard.GadgetEditor;
import com.pmease.quickbuild.web.page.dashboard.GadgetPosition;
import com.pmease.quickbuild.web.page.dashboard.LayoutColumn;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang.Validate;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class GadgetPanel
extends Panel {
    private GadgetPosition position;
    private boolean minimized;
    private Gadget gadget;

    public GadgetPanel(String id, GadgetPosition position) {
        super(id);
        this.position = position;
        this.gadget = this.getDashboard().getGadget(position);
        Validate.notNull((Object)this.gadget);
    }

    public GadgetPosition getPosition() {
        return this.position;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        String cssClasses = "round window gadget ";
        if (this.gadget.getCssClass() != null) {
            cssClasses = cssClasses + this.gadget.getCssClass();
        }
        tag.put("class", (CharSequence)cssClasses);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.setOutputMarkupId(true);
        this.add(new Component[]{this.gadget.renderHead("head")});
        WebMarkupContainer operations = new WebMarkupContainer("operations");
        operations.setOutputMarkupId(true);
        this.add(new Component[]{operations});
        operations.add(new Component[]{new WebMarkupContainer("moveIndicator"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(GadgetPanel.this.getDashboard().isEditable() && GadgetPanel.this.getDashboardPage().getMaximized() == null);
            }
        }});
        operations.add(new Component[]{new AjaxLink<Void>("minimize"){

            public void onClick(AjaxRequestTarget target) {
                GadgetPanel.this.minimized = true;
                target.add(new Component[]{GadgetPanel.this});
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(!GadgetPanel.this.minimized && GadgetPanel.this.getDashboardPage().getMaximized() == null);
            }
        }});
        operations.add(new Component[]{new Link<Void>("maximize"){

            public void onClick() {
                if (GadgetPanel.this.getDashboardPage().checkSynchronous()) {
                    DashboardPage page = new DashboardPage(WebSession.get().getActiveDashboardId(), false);
                    page.setMaximized(GadgetPanel.this.position);
                    this.setResponsePage((Page)page);
                }
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(!GadgetPanel.this.minimized && GadgetPanel.this.getDashboardPage().getMaximized() == null);
            }
        }});
        if (this.position.equals(this.getDashboardPage().getMaximized())) {
            operations.add(new Component[]{new Link<Void>("restore"){

                public void onClick() {
                    this.setResponsePage((Page)new DashboardPage(WebSession.get().getActiveDashboardId(), false));
                }
            }});
        } else {
            operations.add(new Component[]{new AjaxLink<Void>("restore"){

                public void onClick(AjaxRequestTarget target) {
                    GadgetPanel.this.minimized = false;
                    target.add(new Component[]{GadgetPanel.this});
                }

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(GadgetPanel.this.minimized);
                }
            }});
        }
        operations.add(new Component[]{new AjaxLink<Void>("refresh"){

            public void onClick(AjaxRequestTarget target) {
                if (GadgetPanel.this.getDashboardPage().checkSynchronous()) {
                    GadgetPanel newPanel = new GadgetPanel(GadgetPanel.this.getId(), GadgetPanel.this.position);
                    GadgetPanel.this.replaceWith((Component)((Object)newPanel));
                    target.add(new Component[]{newPanel});
                }
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(!GadgetPanel.this.getDashboard().isEditable());
            }
        }});
        operations.add(new Component[]{new WebMarkupContainer("operationMenuTrigger"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(GadgetPanel.this.getDashboard().isEditable());
            }
        }.add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                Fragment fragment = new Fragment(componentId, "operationMenuFrag", (MarkupContainer)GadgetPanel.this);
                fragment.add(new Component[]{new AjaxLink<Void>("refresh"){

                    public void onClick(AjaxRequestTarget target) {
                        this.closePopup(target);
                        if (GadgetPanel.this.getDashboardPage().checkSynchronous()) {
                            GadgetPanel newPanel = new GadgetPanel(GadgetPanel.this.getId(), GadgetPanel.this.position);
                            GadgetPanel.this.replaceWith((Component)((Object)newPanel));
                            target.add(new Component[]{newPanel});
                        }
                    }
                }});
                fragment.add(new Component[]{new AjaxLink<Void>("setting"){

                    public void onClick(AjaxRequestTarget target) {
                        this.closePopup(target);
                        new Dialog("Edit Gadget Setting"){

                            @Override
                            protected Component render(String id) {
                                return new GadgetEditor(id, GadgetPanel.this.gadget){

                                    @Override
                                    protected void onGadgetSaved(AjaxRequestTarget target) {
                                        if (GadgetPanel.this.getDashboardPage().checkSynchronous()) {
                                            Dashboard dashboard = GadgetPanel.this.getDashboard();
                                            LayoutColumn column = dashboard.getColumns().get(GadgetPanel.this.position.getColumnIndex());
                                            column.getGadgetDOMs().set(GadgetPanel.this.position.getRowIndex(), VersionedDocument.fromBean(GadgetPanel.this.gadget));
                                            DashboardManager.instance.save(dashboard);
                                            GadgetPanel newGadgetPanel = new GadgetPanel(GadgetPanel.this.getId(), GadgetPanel.this.position);
                                            GadgetPanel.this.replaceWith((Component)((Object)newGadgetPanel));
                                            target.add(new Component[]{newGadgetPanel});
                                            Session.get().info((Serializable)((Object)"Gadget setting saved."));
                                        }
                                    }
                                };
                            }
                        }.width(600).open(target);
                    }
                }});
                if (GadgetPanel.this.getDashboardPage().getMaximized() == null) {
                    fragment.add(new Component[]{new AjaxLink<Void>("delete"){

                        public void onClick(AjaxRequestTarget target) {
                            this.closePopup(target);
                            if (GadgetPanel.this.getDashboardPage().checkSynchronous()) {
                                Dashboard dashboard = GadgetPanel.this.getDashboard();
                                dashboard.getColumns().get(GadgetPanel.this.position.getColumnIndex()).getGadgetDOMs().remove(GadgetPanel.this.position.getRowIndex());
                                DashboardManager.instance.save(dashboard);
                                final ArrayList gadgetPanels = new ArrayList();
                                this.getPage().visitChildren(GadgetPanel.class, (IVisitor)new IVisitor<GadgetPanel, Void>(){

                                    public void component(GadgetPanel object, IVisit<Void> visit) {
                                        gadgetPanels.add(object);
                                    }
                                });
                                for (GadgetPanel each : gadgetPanels) {
                                    if (each.getPosition().getColumnIndex() != GadgetPanel.this.position.getColumnIndex()) continue;
                                    if (each.getPosition().getRowIndex() == GadgetPanel.this.position.getRowIndex()) {
                                        each.remove();
                                        continue;
                                    }
                                    if (each.getPosition().getRowIndex() <= GadgetPanel.this.position.getRowIndex()) continue;
                                    each.getPosition().setRowIndex(each.getPosition().getRowIndex() - 1);
                                }
                                String scriptTemplate = "$('td.layout-column:eq(%d)>div.gadget:eq(%d)').remove();";
                                target.appendJavaScript(String.format(scriptTemplate, GadgetPanel.this.position.getColumnIndex(), GadgetPanel.this.position.getRowIndex()));
                                target.appendJavaScript("decorateDashboard();");
                            }
                        }

                        protected void onConfigure() {
                            super.onConfigure();
                            this.setVisible(GadgetPanel.this.getDashboard().isEditable());
                        }
                    }});
                } else {
                    fragment.add(new Component[]{new Link<Void>("delete"){

                        public void onClick() {
                            Dashboard dashboard = GadgetPanel.this.getDashboard();
                            dashboard.getColumns().get(GadgetPanel.this.position.getColumnIndex()).getGadgetDOMs().remove(GadgetPanel.this.position.getRowIndex());
                            DashboardManager.instance.save(dashboard);
                            this.setResponsePage((Page)new DashboardPage(WebSession.get().getActiveDashboardId(), false));
                        }

                        protected void onConfigure() {
                            super.onConfigure();
                            this.setVisible(GadgetPanel.this.getDashboard().isEditable());
                        }
                    }.add(new Behavior[]{new ConfirmBehavior("Do you really want to remove this gadget?")})});
                }
                return fragment;
            }
        }.alignment(new PopupBehavior.Alignment(operations.getMarkupId()))})});
        if (!this.getDashboardPage().isFailsafe()) {
            this.add(new Component[]{new LazyLoadPanel("body"){

                @Override
                public Component getLazyLoadComponent(String markupId) {
                    return GadgetPanel.this.gadget.renderBody(markupId);
                }

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(!GadgetPanel.this.minimized);
                }
            }});
        } else {
            this.add(new Component[]{new Label("body", "Gadget is in failsafe mode.").add(new Behavior[]{new AttributeAppender("style", (Serializable)((Object)"padding:8px;"))})});
        }
    }

    private DashboardPage getDashboardPage() {
        return (DashboardPage)BasePage.get();
    }

    private Dashboard getDashboard() {
        return this.getDashboardPage().getActiveDashboard();
    }
}

