/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.dashboard;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.DashboardManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Dashboard;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.util.EasyList;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.behavior.DragBehavior;
import com.pmease.quickbuild.web.behavior.DropBehavior;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.behavior.SortBehavior;
import com.pmease.quickbuild.web.behavior.SortPosition;
import com.pmease.quickbuild.web.behavior.menu.AjaxTypeMenuBehavior;
import com.pmease.quickbuild.web.component.dialog.ConfirmDialog;
import com.pmease.quickbuild.web.component.dialog.Dialog;
import com.pmease.quickbuild.web.page.MainPage;
import com.pmease.quickbuild.web.page.dashboard.DashboardEditor;
import com.pmease.quickbuild.web.page.dashboard.GadgetEditor;
import com.pmease.quickbuild.web.page.dashboard.GadgetPanel;
import com.pmease.quickbuild.web.page.dashboard.GadgetPosition;
import com.pmease.quickbuild.web.page.dashboard.LayoutColumn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class DashboardPage
extends MainPage {
    private ListView<LayoutColumn> columnsView;
    private GadgetPosition maximized;
    private boolean failsafe;
    private IModel<List<Dashboard>> accessibleDashboardsModel;

    public DashboardPage(Long dashboardId, boolean failsafe) {
        if (dashboardId != null && !dashboardId.equals(WebSession.get().getActiveDashboardId())) {
            WebSession.get().setActiveDashboardId(dashboardId);
        }
        this.add(new Component[]{new WebMarkupContainer("failsafeNotice").setVisible(failsafe)});
        this.accessibleDashboardsModel = new LoadableDetachableModel<List<Dashboard>>(){

            protected List<Dashboard> load() {
                ArrayList<Dashboard> accessibleDashboards = new ArrayList<Dashboard>();
                if (Context.getUser() != null) {
                    List<Dashboard> userDashboards = CacheManager.instance.getDashboardsOwnedByUser(Context.getUser().getId());
                    if (userDashboards.isEmpty()) {
                        Dashboard dashboard = Dashboard.getDefault();
                        dashboard.setUser(Context.getUser());
                        DashboardManager.instance.save(dashboard);
                        Context.getUser().getFavoriteDashboardIds().add(dashboard.getId());
                        UserManager.instance.save(Context.getUser());
                    }
                    accessibleDashboards.addAll(CacheManager.instance.getDashboardsAccessibleByUser(Context.getUser().getId()));
                } else {
                    Group anonymousGroup = CacheManager.instance.getGroup("anonymous");
                    Validate.notNull((Object)anonymousGroup);
                    accessibleDashboards.addAll(CacheManager.instance.getDashboardsAccessibleByGroup(anonymousGroup.getId()));
                }
                Collections.sort(accessibleDashboards, new Comparator<Dashboard>(){

                    @Override
                    public int compare(Dashboard o1, Dashboard o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                return accessibleDashboards;
            }
        };
        this.setDefaultModel((IModel)new LoadableDetachableModel<Dashboard>(){

            protected Dashboard load() {
                Long activeDashboardId = WebSession.get().getActiveDashboardId();
                for (Dashboard each : DashboardPage.this.getAccessibleDashboards()) {
                    if (!each.getId().equals(activeDashboardId)) continue;
                    return (Dashboard)DashboardManager.instance.load(each.getId());
                }
                if (DashboardPage.this.getAccessibleDashboards().isEmpty()) {
                    return Dashboard.getDefault();
                }
                return (Dashboard)DashboardManager.instance.load(((Dashboard)DashboardPage.this.getAccessibleDashboards().get(0)).getId());
            }
        });
        this.failsafe = failsafe;
    }

    public DashboardPage() {
        this(null, false);
    }

    private static Long getDashboardId(PageParameters params) {
        if (params.getIndexedCount() == 0) {
            return null;
        }
        String param = params.get(0).toString();
        if (NumberUtils.isNumber((String)param)) {
            return Long.parseLong(param);
        }
        return null;
    }

    private static boolean isFailsafe(PageParameters params) {
        if (params.getIndexedCount() == 0) {
            return false;
        }
        String param = params.get(0).toString();
        if (param.equals("failsafe")) {
            return true;
        }
        return "failsafe".equals(params.get(1).toOptionalString());
    }

    public DashboardPage(PageParameters params) {
        this(DashboardPage.getDashboardId(params), DashboardPage.isFailsafe(params));
    }

    public Dashboard getActiveDashboard() {
        return (Dashboard)this.getDefaultModelObject();
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new WebMarkupContainer("icon"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (!ObjectUtils.equals((Object)DashboardPage.this.getActiveDashboard().getUser(), (Object)Context.getUser())) {
                    tag.put("src", (CharSequence)"/images/share.png");
                } else {
                    tag.put("src", (CharSequence)"/images/dashboard.png");
                }
                String tooltip = DashboardPage.this.getTooltip(DashboardPage.this.getActiveDashboard());
                if (tooltip != null) {
                    tag.put("title", (CharSequence)tooltip);
                }
            }
        }});
        this.add(new Component[]{new Label("name", this.getActiveDashboard().getName())});
        this.add(new Component[]{new WebMarkupContainer("dashboardOrganizerTrigger"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(DashboardPage.this.getAccessibleDashboards().size() > 1);
            }
        }.add(new Behavior[]{new PopupBehavior(){
            private boolean showAvailables;

            @Override
            protected Component getPopup(String componentId) {
                if (Context.getUser() == null || DashboardPage.this.getAccessibleDashboards().size() <= 10) {
                    Fragment fragment = new Fragment(componentId, "dashboardMenuFrag", (MarkupContainer)DashboardPage.this);
                    fragment.add(new Component[]{new ListView<Dashboard>("dashboards", (IModel)new LoadableDetachableModel<List<Dashboard>>(){

                        protected List<Dashboard> load() {
                            ArrayList<Dashboard> dashboards = new ArrayList<Dashboard>();
                            if (Context.getUser() != null) {
                                HashMap<Long, Dashboard> map = new HashMap<Long, Dashboard>();
                                for (Dashboard dashboard : DashboardPage.this.getAccessibleDashboards()) {
                                    map.put(dashboard.getId(), dashboard);
                                }
                                for (Long l : Context.getUser().getFavoriteDashboardIds()) {
                                    Dashboard dashboard = (Dashboard)map.get(l);
                                    if (dashboard == null) continue;
                                    dashboards.add(dashboard);
                                }
                                for (Dashboard dashboard : DashboardPage.this.getAccessibleDashboards()) {
                                    if (Context.getUser().getFavoriteDashboardIds().contains(dashboard.getId())) continue;
                                    dashboards.add(dashboard);
                                }
                            } else {
                                dashboards.addAll(DashboardPage.this.getAccessibleDashboards());
                            }
                            return dashboards;
                        }
                    }){

                        protected void populateItem(ListItem<Dashboard> item) {
                            final Dashboard dashboard = (Dashboard)item.getModelObject();
                            Link<Void> link = new Link<Void>("link"){

                                public void onClick() {
                                    this.setResponsePage(DashboardPage.class, new PageParameters().set(0, (Object)dashboard.getId()));
                                }
                            };
                            link.add(new Component[]{new Label("label", dashboard.getName())});
                            String tooltip = DashboardPage.this.getTooltip(dashboard);
                            if (tooltip != null) {
                                link.add(new Behavior[]{new AttributeAppender("title", (Serializable)((Object)tooltip))});
                            }
                            item.add(new Component[]{link});
                        }
                    }});
                    return fragment;
                }
                final Fragment fragment = new Fragment(componentId, "dashboardOrganizerFrag", (MarkupContainer)DashboardPage.this);
                WebMarkupContainer favoritesContainer = new WebMarkupContainer("favoritesContainer");
                favoritesContainer.add(new Behavior[]{new DropBehavior(".dashboard-organizer .availables *"){

                    @Override
                    public void onDropped(AjaxRequestTarget target, String dragData) {
                        Context.getUser().getFavoriteDashboardIds().add(Long.valueOf(dragData));
                        UserManager.instance.save(Context.getUser());
                        target.add(new Component[]{fragment});
                    }
                }});
                favoritesContainer.add(new Component[]{new AjaxLink<Void>("showAvailables"){

                    public void onClick(AjaxRequestTarget target) {
                        showAvailables = true;
                        target.add(new Component[]{fragment});
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(!showAvailables);
                    }
                }});
                fragment.add(new Component[]{favoritesContainer});
                favoritesContainer.add(new Component[]{new ListView<Dashboard>("favorites", (IModel)new LoadableDetachableModel<List<Dashboard>>(){

                    protected List<Dashboard> load() {
                        ArrayList<Dashboard> favorites = new ArrayList<Dashboard>();
                        HashMap<Long, Dashboard> accessibleDashboardMap = new HashMap<Long, Dashboard>();
                        for (Dashboard dashboard : DashboardPage.this.getAccessibleDashboards()) {
                            accessibleDashboardMap.put(dashboard.getId(), dashboard);
                        }
                        for (Long l : Context.getUser().getFavoriteDashboardIds()) {
                            Dashboard dashboard = (Dashboard)accessibleDashboardMap.get(l);
                            if (dashboard == null) continue;
                            favorites.add(dashboard);
                        }
                        return favorites;
                    }
                }){

                    protected void populateItem(ListItem<Dashboard> item) {
                        Dashboard dashboard = (Dashboard)item.getModelObject();
                        final Long dashboardId = dashboard.getId();
                        item.add(new Component[]{new WebMarkupContainer("dragHandle"){

                            protected void onConfigure() {
                                super.onConfigure();
                                this.setVisible(showAvailables);
                            }
                        }.add(new Behavior[]{new DragBehavior(dashboard.getId().toString(), dashboard.getName())})});
                        Link<Void> link = new Link<Void>("link"){

                            public void onClick() {
                                this.setResponsePage(DashboardPage.class, new PageParameters().set(0, (Object)dashboardId));
                            }
                        };
                        String tooltip = DashboardPage.this.getTooltip(dashboard);
                        if (tooltip != null) {
                            link.add(new Behavior[]{new AttributeAppender("title", (Serializable)((Object)tooltip))});
                        }
                        link.add(new Component[]{new Label("label", dashboard.getName())});
                        item.add(new Component[]{link});
                    }
                }});
                WebMarkupContainer availablesContainer = new WebMarkupContainer("availablesContainer"){

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(showAvailables);
                    }
                };
                availablesContainer.add(new Behavior[]{new DropBehavior(".dashboard-organizer .favorites *"){

                    @Override
                    public void onDropped(AjaxRequestTarget target, String dragData) {
                        Context.getUser().getFavoriteDashboardIds().remove(Long.valueOf(dragData));
                        UserManager.instance.save(Context.getUser());
                        target.add(new Component[]{fragment});
                    }
                }});
                fragment.add(new Component[]{availablesContainer});
                availablesContainer.add(new Component[]{new ListView<Dashboard>("availables", (IModel)new LoadableDetachableModel<List<Dashboard>>(){

                    protected List<Dashboard> load() {
                        ArrayList<Dashboard> availables = new ArrayList<Dashboard>();
                        for (Dashboard each : DashboardPage.this.getAccessibleDashboards()) {
                            if (Context.getUser().getFavoriteDashboardIds().contains(each.getId())) continue;
                            availables.add(each);
                        }
                        return availables;
                    }
                }){

                    protected void populateItem(ListItem<Dashboard> item) {
                        Dashboard dashboard = (Dashboard)item.getModelObject();
                        final Long dashboardId = dashboard.getId();
                        item.add(new Component[]{new WebMarkupContainer("dragHandle").add(new Behavior[]{new DragBehavior(dashboard.getId().toString(), dashboard.getName())})});
                        Link<Void> link = new Link<Void>("link"){

                            public void onClick() {
                                this.setResponsePage(DashboardPage.class, new PageParameters().set(0, (Object)dashboardId));
                            }
                        };
                        link.add(new Component[]{new Label("label", dashboard.getName())});
                        String tooltip = DashboardPage.this.getTooltip(dashboard);
                        if (tooltip != null) {
                            link.add(new Behavior[]{new AttributeAppender("title", (Serializable)((Object)tooltip))});
                        }
                        item.add(new Component[]{link});
                    }
                }});
                return fragment;
            }
        }.hoverMode(false)})});
        WebMarkupContainer layoutMenuTrigger = new WebMarkupContainer("layoutMenuTrigger"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(DashboardPage.this.getActiveDashboard().isEditable() && DashboardPage.this.maximized == null);
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String cssClass = tag.getAttribute("class");
                ArrayList<LayoutColumn> columns = DashboardPage.this.getActiveDashboard().getColumns();
                cssClass = columns.size() == 1 ? cssClass + " one-column" : (columns.size() == 2 ? (((LayoutColumn)columns.get(0)).getWidth() < 49 ? cssClass + " two-columns-left-small" : (((LayoutColumn)columns.get(0)).getWidth() > 51 ? cssClass + " two-columns-left-big" : cssClass + " two-columns")) : cssClass + " three-columns");
                tag.put("class", (CharSequence)cssClass);
            }
        };
        this.add(new Component[]{layoutMenuTrigger});
        layoutMenuTrigger.add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                Fragment fragment = new Fragment(componentId, "layoutMenuFrag", (MarkupContainer)DashboardPage.this);
                fragment.add(new Component[]{new Link<Void>("oneColumn"){

                    public void onClick() {
                        DashboardPage.this.getActiveDashboard().useLayout(EasyList.create(100));
                        DashboardManager.instance.save(DashboardPage.this.getActiveDashboard());
                        this.setResponsePage(DashboardPage.class);
                    }
                }});
                fragment.add(new Component[]{new Link<Void>("twoColumns"){

                    public void onClick() {
                        DashboardPage.this.getActiveDashboard().useLayout(EasyList.create(49, 49));
                        DashboardManager.instance.save(DashboardPage.this.getActiveDashboard());
                        this.setResponsePage(DashboardPage.class);
                    }
                }});
                fragment.add(new Component[]{new Link<Void>("twoColumnsLeftBig"){

                    public void onClick() {
                        DashboardPage.this.getActiveDashboard().useLayout(EasyList.create(66, 33));
                        DashboardManager.instance.save(DashboardPage.this.getActiveDashboard());
                        this.setResponsePage(DashboardPage.class);
                    }
                }});
                fragment.add(new Component[]{new Link<Void>("twoColumnsLeftSmall"){

                    public void onClick() {
                        DashboardPage.this.getActiveDashboard().useLayout(EasyList.create(33, 66));
                        DashboardManager.instance.save(DashboardPage.this.getActiveDashboard());
                        this.setResponsePage(DashboardPage.class);
                    }
                }});
                fragment.add(new Component[]{new Link<Void>("threeColumns"){

                    public void onClick() {
                        DashboardPage.this.getActiveDashboard().useLayout(EasyList.create(33, 33, 33));
                        DashboardManager.instance.save(DashboardPage.this.getActiveDashboard());
                        this.setResponsePage(DashboardPage.class);
                    }
                }});
                return fragment;
            }
        }.hoverMode(false)});
        this.add(new Component[]{new Link<Void>("restoreLayout"){

            public void onClick() {
                this.setResponsePage(DashboardPage.class);
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(DashboardPage.this.maximized != null);
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("operationMenuTrigger"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(Context.getUser() != null);
            }
        }.add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                Fragment fragment = new Fragment(componentId, "operationMenuFrag", (MarkupContainer)DashboardPage.this);
                fragment.add(new Component[]{new AjaxLink<Void>("copy"){

                    public void onClick(AjaxRequestTarget target) {
                        this.closePopup(target);
                        new Dialog("Copy Dashboard"){

                            @Override
                            protected Component render(String id) {
                                Dashboard copy = DashboardManager.instance.copyAsNew(DashboardPage.this.getActiveDashboard());
                                return new DashboardEditor(id, copy);
                            }
                        }.width(600).open(target);
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(Context.getUser() != null);
                    }
                }});
                fragment.add(new Component[]{new AjaxLink<Void>("edit"){

                    public void onClick(AjaxRequestTarget target) {
                        this.closePopup(target);
                        new Dialog("Edit Dashboard"){

                            @Override
                            protected Component render(String id) {
                                return new DashboardEditor(id, DashboardPage.this.getActiveDashboard());
                            }
                        }.width(600).open(target);
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(DashboardPage.this.getActiveDashboard().isEditable());
                    }
                }});
                fragment.add(new Component[]{new AjaxLink<Void>("delete"){

                    public void onClick(AjaxRequestTarget target) {
                        this.closePopup(target);
                        new ConfirmDialog("Do you really want to delete this dashboard?"){

                            @Override
                            protected void onConfirm(AjaxRequestTarget target) {
                                DashboardManager.instance.delete(DashboardPage.this.getActiveDashboard());
                                this.setResponsePage(DashboardPage.class);
                            }
                        }.open(target);
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        User user = Context.getUser();
                        if (user == null || DashboardPage.this.getActiveDashboard().getId() == null) {
                            this.setVisible(false);
                        } else {
                            this.setVisible(user.getId().equals(DashboardPage.this.getActiveDashboard().getUser().getId()));
                        }
                    }
                }});
                fragment.add(new Component[]{new AjaxLink<Void>("addNew"){

                    public void onClick(AjaxRequestTarget target) {
                        this.closePopup(target);
                        new Dialog("Add New Dashboard"){

                            @Override
                            protected Component render(String id) {
                                return new DashboardEditor(id, new Dashboard());
                            }
                        }.width(600).open(target);
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(Context.getUser() != null);
                    }
                }});
                return fragment;
            }
        }.hoverMode(false)})});
        WebMarkupContainer gadgetMenuTrigger = new WebMarkupContainer("gadgetMenuTrigger"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(DashboardPage.this.getActiveDashboard().isEditable() && DashboardPage.this.maximized == null);
            }
        };
        gadgetMenuTrigger.add(new Behavior[]{new AjaxTypeMenuBehavior<Gadget>(){

            @Override
            public void onSelect(AjaxRequestTarget target, Class<Gadget> gadgetClass) {
                this.closePopup(target);
                DashboardPage.this.addGadget(target, gadgetClass, 0);
            }
        }.hoverMode(false)});
        this.add(new Component[]{gadgetMenuTrigger});
        if (this.maximized == null) {
            Fragment body = new Fragment("dashboardBody", "bodyFrag", (MarkupContainer)this);
            this.add(new Component[]{body});
            LoadableDetachableModel<List<LayoutColumn>> columnsModel = new LoadableDetachableModel<List<LayoutColumn>>(){

                protected List<LayoutColumn> load() {
                    return DashboardPage.this.getActiveDashboard().getColumns();
                }
            };
            Component[] componentArray = new Component[1];
            this.columnsView = new ListView<LayoutColumn>("columns", (IModel)columnsModel){

                protected void populateItem(final ListItem<LayoutColumn> columnItem) {
                    columnItem.setOutputMarkupId(true);
                    if (columnItem.getIndex() == DashboardPage.this.getActiveDashboard().getColumns().size() - 1) {
                        columnItem.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"last layout-column"))});
                    }
                    LayoutColumn column = (LayoutColumn)columnItem.getModelObject();
                    columnItem.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)("width:" + column.getWidth() + "%;")))});
                    RepeatingView columnView = new RepeatingView("gadgets");
                    columnItem.add(new Component[]{columnView});
                    for (int rowIndex = 0; rowIndex < column.getGadgetDOMs().size(); ++rowIndex) {
                        GadgetPosition position = new GadgetPosition(columnItem.getIndex(), rowIndex);
                        columnView.add(new Component[]{new GadgetPanel(columnView.newChildId(), position)});
                    }
                    WebMarkupContainer gadgetMenuTrigger = new WebMarkupContainer("addGadget");
                    gadgetMenuTrigger.add(new Behavior[]{new AjaxTypeMenuBehavior<Gadget>(){

                        @Override
                        public void onSelect(AjaxRequestTarget target, Class<Gadget> gadgetClass) {
                            this.closePopup(target);
                            DashboardPage.this.addGadget(target, gadgetClass, columnItem.getIndex());
                        }
                    }.hoverMode(false)});
                    columnItem.add(new Component[]{gadgetMenuTrigger});
                }
            };
            componentArray[0] = this.columnsView;
            body.add(componentArray);
            if (this.getActiveDashboard().isEditable()) {
                body.add(new Behavior[]{new SortBehavior(){

                    @Override
                    protected void onSort(AjaxRequestTarget target, SortPosition from, SortPosition to) {
                        if (DashboardPage.this.checkSynchronous()) {
                            Dashboard dashboard = DashboardPage.this.getActiveDashboard();
                            final ArrayList gadgetPositions = new ArrayList();
                            for (int i = 0; i < dashboard.getColumns().size(); ++i) {
                                gadgetPositions.add(new ArrayList());
                                for (int j = 0; j < dashboard.getColumns().get(i).getGadgetDOMs().size(); ++j) {
                                    ((List)gadgetPositions.get(i)).add(new GadgetPosition(0, 0));
                                }
                            }
                            VersionedDocument dom = dashboard.getColumns().get(from.getListIndex()).getGadgetDOMs().remove(from.getItemIndex());
                            dashboard.getColumns().get(to.getListIndex()).getGadgetDOMs().add(to.getItemIndex(), dom);
                            DashboardManager.instance.save(dashboard);
                            DashboardPage.this.getPage().visitChildren(GadgetPanel.class, (IVisitor)new IVisitor<GadgetPanel, Void>(){

                                public void component(GadgetPanel object, IVisit<Void> visit) {
                                    GadgetPosition position = object.getPosition();
                                    ((List)gadgetPositions.get(position.getColumnIndex())).set(position.getRowIndex(), position);
                                }
                            });
                            GadgetPosition position = (GadgetPosition)((List)gadgetPositions.get(from.getListIndex())).remove(from.getItemIndex());
                            ((List)gadgetPositions.get(to.getListIndex())).add(to.getItemIndex(), position);
                            for (int i = 0; i < gadgetPositions.size(); ++i) {
                                for (int j = 0; j < ((List)gadgetPositions.get(i)).size(); ++j) {
                                    position = (GadgetPosition)((List)gadgetPositions.get(i)).get(j);
                                    position.setColumnIndex(i);
                                    position.setRowIndex(j);
                                }
                            }
                        }
                    }
                }.sortable(".layout-column").connectWith(".layout-column").handle(">.head").placeholder("gadget-placeholder").distance(5).itemIndex("ui.item.parent().find('>.gadget').index(ui.item)").items(">.gadget").change("function(){decorateDashboard();}").update("function(){decorateDashboard();}")});
            }
        } else {
            this.add(new Component[]{new GadgetPanel("dashboardBody", this.maximized)});
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderOnLoadJavaScript("decorateDashboard();");
    }

    @Override
    protected int getAjaxRefreshInterval() {
        return CacheManager.instance.getSystemSetting().getAutoRefreshInterval() * 1000;
    }

    private void addGadget(AjaxRequestTarget target, final Class<? extends Gadget> gadgetClass, final int columnIndex) {
        new Dialog("Gadget Setting"){

            @Override
            protected Component render(String id) {
                Gadget gadget;
                try {
                    gadget = (Gadget)gadgetClass.newInstance();
                }
                catch (Exception e) {
                    throw ExceptionUtils.wrapAsUnchecked(e);
                }
                return new GadgetEditor(id, gadget){

                    @Override
                    protected void onGadgetSaved(AjaxRequestTarget target) {
                        if (DashboardPage.this.checkSynchronous()) {
                            Dashboard dashboard = DashboardPage.this.getActiveDashboard();
                            LayoutColumn column = dashboard.getColumns().get(columnIndex);
                            column.getGadgetDOMs().add(VersionedDocument.fromBean(gadget));
                            DashboardManager.instance.save(dashboard);
                            RepeatingView columnView = (RepeatingView)DashboardPage.this.columnsView.get(columnIndex).get("gadgets");
                            GadgetPanel gadgetPanel = new GadgetPanel(columnView.newChildId(), new GadgetPosition(columnIndex, column.getGadgetDOMs().size() - 1));
                            columnView.add(new Component[]{gadgetPanel});
                            target.add(new Component[]{gadgetPanel});
                            String scriptTemplate = "var element = document.createElement('div');element.id='%s'; document.getElementById('%s').appendChild(element);";
                            target.prependJavaScript(String.format(scriptTemplate, gadgetPanel.getMarkupId(), columnView.getParent().getMarkupId()));
                            target.appendJavaScript("decorateDashboard();");
                            Session.get().info((Serializable)((Object)"Gadget setting saved."));
                        }
                    }
                };
            }
        }.width(600).open(target);
    }

    private List<Dashboard> getAccessibleDashboards() {
        return (List)this.accessibleDashboardsModel.getObject();
    }

    public GadgetPosition getMaximized() {
        return this.maximized;
    }

    public void setMaximized(GadgetPosition maximized) {
        this.maximized = maximized;
    }

    private String getTooltip(Dashboard dashboard) {
        User user = dashboard.getUser();
        if (user == null) {
            return dashboard.getDescription();
        }
        if (user.getName() == null) {
            user = CacheManager.instance.getUser(user.getId());
            Validate.notNull((Object)user);
        }
        if (!ObjectUtils.equals((Object)user, (Object)Context.getUser())) {
            String tooltip = dashboard.getDescription();
            tooltip = tooltip != null ? tooltip + " (shared by " + user.getDisplayName() + ")" : "shared by " + user.getDisplayName();
            return tooltip;
        }
        if (dashboard.getDescription() != null) {
            return dashboard.getDescription();
        }
        return null;
    }

    protected boolean checkSynchronous() {
        Dashboard dashboard = this.getActiveDashboard();
        if (this.maximized != null) {
            int column = this.maximized.getColumnIndex();
            int row = this.maximized.getRowIndex();
            if (column >= dashboard.getColumns().size() || row >= dashboard.getColumns().get(column).getGadgetDOMs().size()) {
                Session.get().warn((Serializable)((Object)"Dashboard is out of sync. Please refresh the page and try again."));
                return false;
            }
            return true;
        }
        final ArrayList positionFlags = new ArrayList();
        for (int i = 0; i < dashboard.getColumns().size(); ++i) {
            positionFlags.add(new ArrayList());
            for (int j = 0; j < dashboard.getColumns().get(i).getGadgetDOMs().size(); ++j) {
                ((List)positionFlags.get(i)).add(false);
            }
        }
        Component violated = (Component)this.visitChildren(GadgetPanel.class, (IVisitor)new IVisitor<GadgetPanel, Component>(){

            public void component(GadgetPanel object, IVisit<Component> visit) {
                GadgetPosition position = object.getPosition();
                int column = position.getColumnIndex();
                int row = position.getRowIndex();
                if (column >= positionFlags.size() || row >= ((List)positionFlags.get(column)).size() || ((Boolean)((List)positionFlags.get(column)).get(row)).booleanValue()) {
                    visit.stop((Object)object);
                } else {
                    ((List)positionFlags.get(column)).set(row, true);
                }
            }
        });
        if (violated != null) {
            Session.get().warn((Serializable)((Object)"Dashboard is out of sync. Please refresh the page and try again."));
            return false;
        }
        for (int i = 0; i < positionFlags.size(); ++i) {
            for (int j = 0; j < ((List)positionFlags.get(i)).size(); ++j) {
                if (((Boolean)((List)positionFlags.get(i)).get(j)).booleanValue()) continue;
                Session.get().warn((Serializable)((Object)"Dashboard is out of sync. Please refresh the page and try again."));
                return false;
            }
        }
        return true;
    }

    public boolean isFailsafe() {
        return this.failsafe;
    }

    @Override
    protected void onDetach() {
        if (this.accessibleDashboardsModel != null) {
            this.accessibleDashboardsModel.detach();
        }
        super.onDetach();
    }
}

