/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.dashboard;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.DashboardManager;
import com.pmease.quickbuild.entitymanager.GroupShareManager;
import com.pmease.quickbuild.entitymanager.UserShareManager;
import com.pmease.quickbuild.model.Dashboard;
import com.pmease.quickbuild.model.GroupShare;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.model.UserShare;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.component.dialog.Dialog;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.dashboard.DashboardPage;
import com.pmease.quickbuild.web.page.dashboard.ShareEditBean;
import java.io.Serializable;
import org.apache.commons.lang.Validate;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class DashboardEditor
extends Panel {
    public DashboardEditor(String id, final Dashboard dashboard) {
        super(id, (IModel)new LoadableDetachableModel<Dashboard>(){

            protected Dashboard load() {
                if (dashboard.getId() != null) {
                    return (Dashboard)DashboardManager.instance.load(dashboard.getId());
                }
                return dashboard;
            }
        });
    }

    private Dashboard getDashboard() {
        return (Dashboard)this.getDefaultModelObject();
    }

    protected void onInitialize() {
        super.onInitialize();
        final EditContext dashboardEditContext = new EditContext(this.getDashboard(), new String[]{"name", "description"});
        final ShareEditBean shareEditBean = new ShareEditBean();
        for (GroupShare groupShare : this.getDashboard().getGroupShares()) {
            shareEditBean.getGroups().add(groupShare.getGroup());
        }
        for (UserShare userShare : this.getDashboard().getUserShares()) {
            shareEditBean.getUsers().add(userShare.getUser());
        }
        final EditContext shareEditContext = new EditContext(shareEditBean);
        Form form = new Form("form");
        this.add(new Component[]{form});
        form.add(new Component[]{new BeanEditor("dashboardEditor", dashboardEditContext)});
        form.add(new Component[]{new BeanEditor("shareEditor", shareEditContext){

            protected void onConfigure() {
                super.onConfigure();
                if (!SecurityHelper.isShareDashboardAllowed()) {
                    this.setVisible(false);
                }
            }
        }});
        form.add(new Component[]{new AjaxSubmitLink("save"){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                dashboardEditContext.validate(false);
                if (dashboardEditContext.hasError()) {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                    target.add(new Component[]{form});
                    return;
                }
                dashboardEditContext.update(DashboardEditor.this.getDashboard());
                User user = Context.getUser();
                Validate.notNull((Object)user);
                Dashboard dashboardWithSameName = user.getDashboard(DashboardEditor.this.getDashboard().getName());
                if (dashboardWithSameName != null && (DashboardEditor.this.getDashboard().isNew() || !dashboardWithSameName.getId().equals(DashboardEditor.this.getDashboard().getId()))) {
                    this.getSession().error((Serializable)((Object)"This name has already been used."));
                    target.add(new Component[]{form});
                    return;
                }
                if (SecurityHelper.isShareDashboardAllowed()) {
                    shareEditContext.validate(false);
                    if (shareEditContext.hasError()) {
                        this.getSession().error((Serializable)((Object)"Fix errors below."));
                        target.add(new Component[]{form});
                        return;
                    }
                    shareEditContext.update(shareEditBean);
                }
                if (DashboardEditor.this.getDashboard().getUser() == null) {
                    DashboardEditor.this.getDashboard().setUser(user);
                }
                DashboardManager.instance.save(DashboardEditor.this.getDashboard());
                if (SecurityHelper.isShareDashboardAllowed()) {
                    GroupShareManager.instance.share(DashboardEditor.this.getDashboard(), shareEditBean.getGroups());
                    UserShareManager.instance.share(DashboardEditor.this.getDashboard(), shareEditBean.getUsers());
                }
                this.getSession().info((Serializable)((Object)"Dashboard saved."));
                DashboardEditor.this.onAfterSave(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        }});
        form.add(new Component[]{new AjaxLink<Void>("cancel"){

            public void onClick(AjaxRequestTarget target) {
                Dialog.closeTopmost(target);
            }
        }});
    }

    protected void onAfterSave(AjaxRequestTarget target) {
        this.setResponsePage(DashboardPage.class, new PageParameters().set(0, (Object)this.getDashboard().getId()));
    }
}

