/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.configuration.pipeline;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.dependency.DependencyRevision;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.repositorysupport.RepositoryRuntime;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.setting.configuration.promotion.NeverPromote;
import com.pmease.quickbuild.setting.configuration.promotion.Promotion;
import com.pmease.quickbuild.util.HibernateUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.util.SimpleCacheItem;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.variable.VariableBeanHelper;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.behavior.RefreshBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.component.AjaxTextLink;
import com.pmease.quickbuild.web.component.TextLink;
import com.pmease.quickbuild.web.component.build.BuildLink;
import com.pmease.quickbuild.web.component.build.BuildStatusPanel;
import com.pmease.quickbuild.web.page.build.PromoteOptionEdit;
import com.pmease.quickbuild.web.page.configuration.pipeline.PipelinePanel;
import com.pmease.quickbuild.web.page.dashboard.GadgetPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.visit.IVisit;

public class PipelineSegment
extends Panel {
    private IModel<List<Promotion>> allPromotionsModel;
    private IModel<List<Promotion>> applicablePromotionsModel;
    private Long buildId;
    private String requestId;
    private Long configurationId;
    private IModel<RepositoryInfo> repoInfoModel;
    private int itemIndex;

    public PipelineSegment(String id, Long buildId, String requestId, Long configurationId, int itemIndex) {
        super(id);
        this.buildId = buildId;
        this.requestId = requestId;
        this.configurationId = configurationId;
        this.itemIndex = itemIndex;
        this.setDefaultModel((IModel)new LoadableDetachableModel<Build>(){

            protected Build load() {
                if (PipelineSegment.this.buildId != null) {
                    return (Build)BuildManager.instance.load(PipelineSegment.this.buildId);
                }
                SimpleCacheItem<Object> cacheItem = BuildEngine.instance.getBuildIdCacheItem(PipelineSegment.this.requestId);
                if (cacheItem == null) {
                    Build build = new Build();
                    build.setConfiguration((Configuration)ConfigurationManager.instance.load(PipelineSegment.this.configurationId));
                    build.setStatusDate(null);
                    return build;
                }
                if (cacheItem.getData() == null) {
                    Build build = new Build();
                    build.setConfiguration((Configuration)ConfigurationManager.instance.load(PipelineSegment.this.configurationId));
                    build.setStatusDate(cacheItem.getTimestamp());
                    return build;
                }
                if (cacheItem.getData() instanceof Long) {
                    PipelineSegment.this.buildId = (Long)cacheItem.getData();
                    return (Build)BuildManager.instance.load(PipelineSegment.this.buildId);
                }
                Build build = new Build();
                build.setConfiguration((Configuration)ConfigurationManager.instance.load(PipelineSegment.this.configurationId));
                build.setErrorMessage((String)cacheItem.getData());
                build.setStatusDate(cacheItem.getTimestamp());
                build.setStatus(Build.Status.FAILED);
                return build;
            }
        });
        this.allPromotionsModel = new LoadableDetachableModel<List<Promotion>>(){

            protected List<Promotion> load() {
                ArrayList<Promotion> allPromotions = new ArrayList<Promotion>();
                for (Promotion each : PipelineSegment.this.getBuild().getConfiguration().findPromotions()) {
                    if (each.getCondition() instanceof NeverPromote) continue;
                    allPromotions.add(each);
                }
                return allPromotions;
            }
        };
        this.applicablePromotionsModel = new LoadableDetachableModel<List<Promotion>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Promotion> load() {
                Build build = PipelineSegment.this.getBuild();
                ArrayList<Promotion> applicablePromotions = new ArrayList<Promotion>();
                if (build.getId() != null && SecurityHelper.hasPermission(build.getConfiguration(), ConfigurationPermission.PROMOTE_BUILD.name())) {
                    Context.push(build);
                    try {
                        for (Promotion promotion : PipelineSegment.this.getAllPromotions()) {
                            if (!promotion.getCondition().satisfied(promotion)) continue;
                            applicablePromotions.add(promotion);
                        }
                    }
                    finally {
                        Context.pop();
                    }
                }
                return applicablePromotions;
            }
        };
        this.repoInfoModel = new LoadableDetachableModel<RepositoryInfo>(){

            protected RepositoryInfo load() {
                RepositoryInfo info = new RepositoryInfo();
                String activeRepository = PipelineSegment.this.getBuild().getConfiguration().getActiveRepository();
                RepositoryRuntime runtime = null;
                if (activeRepository != null) {
                    runtime = PipelineSegment.this.getBuild().getRepositoryRuntimes().get(activeRepository);
                }
                if (runtime != null && runtime.getRevision() != null) {
                    info.name = activeRepository;
                    info.runtime = runtime;
                    return info;
                }
                for (Map.Entry<String, RepositoryRuntime> entry : PipelineSegment.this.getBuild().getRepositoryRuntimes().entrySet()) {
                    if (entry.getValue().getRevision() == null || entry.getValue().getRevision() instanceof DependencyRevision) continue;
                    info.name = entry.getKey();
                    info.runtime = entry.getValue();
                    return info;
                }
                return null;
            }
        };
    }

    protected void onBeforeRender() {
        boolean menuAttached = false;
        for (Behavior each : this.getBehaviors()) {
            if (!(each instanceof MenuBehavior)) continue;
            menuAttached = true;
            break;
        }
        if (!menuAttached && !this.getApplicablePromotions().isEmpty()) {
            this.add(new Behavior[]{new MenuBehavior(){

                @Override
                protected List<MenuItem> getMenuItems() {
                    ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
                    for (final Promotion promotion : PipelineSegment.this.getApplicablePromotions()) {
                        menuItems.add(new MenuItem(){

                            @Override
                            public Component render(String componentId) {
                                if (PipelineSegment.this.findParent(GadgetPanel.class) == null) {
                                    return new TextLink<Void>(componentId, promotion.getName()){

                                        public void onClick() {
                                            PipelineSegment.this.promote(promotion);
                                        }
                                    };
                                }
                                return new AjaxTextLink<Void>(componentId, promotion.getName()){

                                    public void onClick(AjaxRequestTarget target) {
                                        PipelineSegment.this.promote(promotion);
                                    }
                                };
                            }
                        });
                    }
                    return menuItems;
                }
            }.hoverMode(true).alignment(new PopupBehavior.Alignment(100, 50, 0, 50))});
        }
        super.onBeforeRender();
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        String cssClass = "segment ";
        if (this.getAllPromotions().isEmpty()) {
            cssClass = cssClass + "end ";
            tag.put("title", (CharSequence)"No promotions defined for this build.");
        } else if (this.getApplicablePromotions().isEmpty()) {
            cssClass = cssClass + "disabled ";
            tag.put("title", (CharSequence)"Not authorized to promote, or promote conditions not satisfied.");
        }
        tag.put("class", (CharSequence)cssClass);
    }

    protected void onInitialize() {
        super.onInitialize();
        WebMarkupContainer buildContainer = new WebMarkupContainer("build"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                Build latestBuild = PipelineSegment.this.getBuild().getConfiguration().getCachedLatestBuild();
                if (PipelineSegment.this.itemIndex != 0 && latestBuild != null && latestBuild.getId().equals(PipelineSegment.this.getBuild().getId())) {
                    tag.put("class", (CharSequence)"latest");
                }
            }
        };
        this.add(new Component[]{buildContainer});
        buildContainer.add(new Component[]{new BuildStatusPanel("buildStatus", (IModel<Build>)new AbstractReadOnlyModel<Build>(){

            public Build getObject() {
                return PipelineSegment.this.getBuild();
            }
        })});
        buildContainer.add(new Component[]{new BuildLink("buildLink", (IModel<Build>)new AbstractReadOnlyModel<Build>(){

            public Build getObject() {
                return PipelineSegment.this.getBuild();
            }
        }, Context.getConfiguration().findShowConfigurationNameInPipeline(), true, 45)});
        LoadableDetachableModel<List<String>> selectionsModel = new LoadableDetachableModel<List<String>>(){

            public List<String> load() {
                ArrayList<String> choices = new ArrayList<String>();
                for (String each : PipelineSegment.this.getBuild().getRepositoryRuntimes().keySet()) {
                    choices.add(each);
                }
                return choices;
            }
        };
        this.add(new Component[]{new DropDownChoice<String>("repositoryChoice", (IModel)new IModel<String>(){

            public String getObject() {
                String activeRepository = PipelineSegment.this.getBuild().getConfiguration().getActiveRepository();
                RepositoryRuntime runtime = null;
                if (activeRepository != null) {
                    runtime = PipelineSegment.this.getBuild().getRepositoryRuntimes().get(activeRepository);
                }
                if (runtime != null) {
                    return activeRepository;
                }
                for (Map.Entry<String, RepositoryRuntime> entry : PipelineSegment.this.getBuild().getRepositoryRuntimes().entrySet()) {
                    if (entry.getValue().getRevision() instanceof DependencyRevision) continue;
                    return entry.getKey();
                }
                return null;
            }

            public void setObject(String object) {
                Configuration configuration = PipelineSegment.this.getBuild().getConfiguration();
                configuration.setActiveRepository(object);
                ConfigurationManager.instance.saveActiveRepository(configuration);
            }

            public void detach() {
            }
        }, (IModel)selectionsModel, (IChoiceRenderer)new IChoiceRenderer<String>(){

            public Object getDisplayValue(String object) {
                int maxLen = 20;
                return StringUtils.abbreviate((String)object, (int)maxLen);
            }

            public String getIdValue(String object, int index) {
                return object;
            }
        }){

            protected boolean wantOnSelectionChangedNotifications() {
                return true;
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(this.getChoices().size() >= 2);
            }
        }});
        this.add(new Component[]{new Label("repositoryName", (IModel)new LoadableDetachableModel<String>(){

            protected String load() {
                int maxLen = 19;
                RepositoryInfo info = (RepositoryInfo)PipelineSegment.this.repoInfoModel.getObject();
                if (info != null) {
                    return StringUtils.abbreviate((String)info.name, (int)maxLen) + ":";
                }
                return null;
            }
        }){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(PipelineSegment.this.getBuild().getRepositoryRuntimes().size() == 1);
            }
        }});
        this.add(new Component[]{new Label("revision", (IModel)new LoadableDetachableModel<String>(){

            public String load() {
                int maxLen = 13;
                RepositoryInfo info = (RepositoryInfo)PipelineSegment.this.repoInfoModel.getObject();
                if (info != null) {
                    return StringUtils.abbreviate((String)info.runtime.getRevision().toString(), (int)maxLen);
                }
                return null;
            }
        }){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(this.getDefaultModelObject() != null);
            }
        }});
        this.add(new Component[]{new Label("committer", (IModel)new LoadableDetachableModel<String>(){

            public String load() {
                int maxLen = 30;
                RepositoryInfo info = (RepositoryInfo)PipelineSegment.this.repoInfoModel.getObject();
                if (info != null && info.runtime.getRevisionInfo() != null && info.runtime.getRevisionInfo().getCommitter() != null) {
                    return StringUtils.abbreviate((String)info.runtime.getRevisionInfo().getCommitter(), (int)maxLen);
                }
                return null;
            }
        }){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(this.getDefaultModelObject() != null);
            }
        }});
        LoadableDetachableModel<String> commentModel = new LoadableDetachableModel<String>(){

            protected String load() {
                RepositoryInfo info = (RepositoryInfo)PipelineSegment.this.repoInfoModel.getObject();
                if (info != null && info.runtime.getRevisionInfo() != null && info.runtime.getRevisionInfo().getComment() != null) {
                    return info.runtime.getRevisionInfo().getComment();
                }
                return null;
            }
        };
        this.add(new Component[]{new WebMarkupContainer("comment", (IModel)commentModel){
            final /* synthetic */ IModel val$commentModel;
            {
                this.val$commentModel = iModel;
                super(x0);
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(this.val$commentModel.getObject() != null);
            }
        }.add(new Behavior[]{AttributeModifier.append((String)"title", (IModel)commentModel)})});
        this.add(new Behavior[]{new RefreshBehavior(){

            @Override
            public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                Build build = PipelineSegment.this.getBuild();
                Long buildId = HibernateUtils.getId(build);
                if (buildId != null) {
                    Pair<Build, Date> pair = CacheManager.instance.getActiveBuild(buildId);
                    return pair != null && pair.getSecond().after(lastRefreshDate);
                }
                return build.getStatusDate() != null && build.getStatusDate().after(lastRefreshDate);
            }
        }});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promote(Promotion promotion) {
        Build build = this.getBuild();
        Context.push(build);
        try {
            promotion = (Promotion)ScriptEngine.instance.installInterpolator(promotion);
            if (VariableBeanHelper.hasPromptFields(promotion.getVariablePromptBeanClass(build))) {
                PipelinePanel pipelinePanel = (PipelinePanel)((Object)this.findParent(PipelinePanel.class));
                WebMarkupContainer container = pipelinePanel.getContainer();
                PromoteOptionEdit editor = new PromoteOptionEdit(container.getId(), promotion, (Component)container);
                editor.setBuild(this.getBuild());
                container.replaceWith((Component)((Object)editor));
                if (AjaxRequestTarget.get() != null) {
                    AjaxRequestTarget.get().add(new Component[]{editor});
                }
            } else {
                try {
                    promotion.promote(build, new HashMap<String, String>());
                    this.getSession().info((Serializable)((Object)"Promotion request has been queued."));
                }
                catch (QuickbuildException e) {
                    this.getSession().error((Serializable)((Object)e.getMessage()));
                }
            }
        }
        finally {
            Context.pop();
        }
    }

    private List<Promotion> getAllPromotions() {
        return (List)this.allPromotionsModel.getObject();
    }

    private List<Promotion> getApplicablePromotions() {
        return (List)this.applicablePromotionsModel.getObject();
    }

    private Build getBuild() {
        return (Build)this.getDefaultModelObject();
    }

    protected void detachModel() {
        super.detachModel();
        this.repoInfoModel.detach();
        this.allPromotionsModel.detach();
        this.applicablePromotionsModel.detach();
    }

    private static class RepositoryInfo {
        String name;
        RepositoryRuntime runtime;

        private RepositoryInfo() {
        }
    }
}

