/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.configuration.pipeline;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.web.page.configuration.pipeline.FilterToolbar;
import com.pmease.quickbuild.web.page.configuration.pipeline.PipelineDataProvider;
import com.pmease.quickbuild.web.page.configuration.pipeline.PipelineSegment;
import com.pmease.quickbuild.web.page.dashboard.GadgetPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxNavigationToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NavigationToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NoRecordsToolbar;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class PipelinePanel
extends Panel {
    private boolean showBuildFilter;
    private boolean showPageNavigator;
    private int pageSize;
    private WebMarkupContainer container;
    private IModel<List<Build>> promotionsModel = new LoadableDetachableModel<List<Build>>(){

        protected List<Build> load() {
            return BuildEngine.instance.getPromotions();
        }
    };

    public PipelinePanel(String id, boolean showBuildFilter, boolean showPageNavigator, int pageSize) {
        super(id);
        this.showBuildFilter = showBuildFilter;
        this.showPageNavigator = showPageNavigator;
        this.pageSize = pageSize;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.container = new Fragment("container", "pipelinesFrag", (MarkupContainer)this);
        this.add(new Component[]{this.container});
        this.container.setOutputMarkupId(true);
        this.container.setOutputMarkupPlaceholderTag(true);
        ArrayList<2> columns = new ArrayList<2>();
        columns.add(new AbstractColumn<Build>((IModel)Model.of((Serializable)((Object)"Build"))){

            public void populateItem(Item<ICellPopulator<Build>> cellItem, String componentId, IModel<Build> rowModel) {
                Build build = (Build)rowModel.getObject();
                int zIndex = 100;
                int intersect = 0;
                int index = ((Item)cellItem.getParent().getParent()).getIndex();
                Fragment fragment = new Fragment(componentId, "pipelineFrag", (MarkupContainer)PipelinePanel.this);
                PipelineSegment segment = new PipelineSegment("current", build.getId(), null, null, index);
                segment.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)("z-index:" + zIndex)))});
                fragment.add(new Component[]{segment});
                cellItem.add(new Component[]{fragment});
                RepeatingView repeatingView = new RepeatingView("forwards");
                fragment.add(new Component[]{repeatingView});
                while (true) {
                    --zIndex;
                    intersect -= 32;
                    Build forward = null;
                    for (Build each : PipelinePanel.this.getPromotions()) {
                        if (!each.getPromotedFrom().getId().equals(build.getId())) continue;
                        forward = each;
                        break;
                    }
                    if (forward == null) {
                        forward = BuildManager.instance.getPromotedTo(build);
                    }
                    if (forward != null) {
                        String requestId = forward.getRequest() != null ? forward.getRequest().getId() : null;
                        segment = new PipelineSegment(repeatingView.newChildId(), forward.getId(), requestId, forward.getConfiguration().getId(), index);
                        segment.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)("z-index:" + zIndex + ";left:" + intersect + "px;")))});
                        repeatingView.add(new Component[]{segment});
                    }
                    if (forward == null || forward.getId() == null) break;
                    build = forward;
                }
            }
        });
        ArrayList<SimpleExpression> criterions = new ArrayList<SimpleExpression>();
        criterions.add(Restrictions.eq((String)"configuration", (Object)Context.getConfiguration()));
        PipelineDataProvider dataProvider = new PipelineDataProvider();
        DataTable dataTable = new DataTable("pipelines", columns, (IDataProvider)dataProvider, this.pageSize);
        if (this.showBuildFilter) {
            dataTable.addTopToolbar((AbstractToolbar)new FilterToolbar((DataTable<Build>)dataTable));
        }
        if (this.showPageNavigator) {
            if (this.findParent(GadgetPanel.class) != null) {
                dataTable.addTopToolbar((AbstractToolbar)new AjaxNavigationToolbar(dataTable));
            } else {
                dataTable.addTopToolbar((AbstractToolbar)new NavigationToolbar(dataTable));
            }
        }
        dataTable.addBottomToolbar((AbstractToolbar)new NoRecordsToolbar(dataTable));
        dataTable.setOutputMarkupId(true);
        this.container.add(new Component[]{dataTable});
    }

    private List<Build> getPromotions() {
        return (List)this.promotionsModel.getObject();
    }

    protected void detachModel() {
        this.promotionsModel.detach();
        super.detachModel();
    }

    public WebMarkupContainer getContainer() {
        return this.container;
    }
}

