/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.configuration.pipeline;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.web.page.configuration.pipeline.FilterOption;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class PipelineDataProvider
implements IDataProvider<Build> {
    private FilterOption filterOption = new FilterOption();

    public void detach() {
    }

    public FilterOption getFilterOption() {
        return this.filterOption;
    }

    public void setFilterOption(FilterOption filterOption) {
        this.filterOption = filterOption;
    }

    private SearchCriteria getSearchCriteria() {
        ArrayList<Object> criterions = new ArrayList<Object>();
        criterions.add(Restrictions.eq((String)"configuration", (Object)Context.getConfiguration()));
        if (this.filterOption.getStatus() != null) {
            if (this.filterOption.getStatus() != Build.Status.SUCCESSFUL) {
                criterions.add(Restrictions.eq((String)"status", (Object)((Object)this.filterOption.getStatus())));
            } else {
                criterions.add(Restrictions.or((Criterion)Restrictions.eq((String)"status", (Object)((Object)Build.Status.SUCCESSFUL)), (Criterion)Restrictions.eq((String)"status", (Object)((Object)Build.Status.RECOMMENDED))));
            }
        }
        if (this.filterOption.getVersion() != null) {
            criterions.add(Restrictions.like((String)"version", (Object)("%" + this.filterOption.getVersion() + "%")));
        }
        if (this.filterOption.getFromDate() != null) {
            criterions.add(Restrictions.ge((String)"beginDate", (Object)this.filterOption.getFromDate()));
        }
        if (this.filterOption.getToDate() != null) {
            criterions.add(Restrictions.le((String)"beginDate", (Object)this.filterOption.getToDate()));
        }
        return new SearchCriteria(criterions.toArray(new Criterion[0]), new Order[]{Order.desc((String)"id")});
    }

    public Iterator<? extends Build> iterator(int first, int count) {
        return BuildManager.instance.search(this.getSearchCriteria(), first, count).iterator();
    }

    public int size() {
        return BuildManager.instance.count(this.getSearchCriteria());
    }

    public IModel<Build> model(Build object) {
        final Long buildId = object.getId();
        return new LoadableDetachableModel<Build>(){

            protected Build load() {
                return (Build)BuildManager.instance.load(buildId);
            }
        };
    }
}

