/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.configuration.pipeline;

import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.web.component.editor.DateEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.EnumEditor;
import com.pmease.quickbuild.web.component.editor.StringEditor;
import com.pmease.quickbuild.web.page.configuration.pipeline.FilterOption;
import com.pmease.quickbuild.web.page.configuration.pipeline.PipelineDataProvider;
import com.pmease.quickbuild.web.page.dashboard.GadgetPanel;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.Link;

public class FilterToolbar
extends AbstractToolbar {
    private PipelineDataProvider dataProvider;

    public FilterToolbar(DataTable<Build> table) {
        super(table);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.dataProvider = (PipelineDataProvider)this.getTable().getDataProvider();
        WebMarkupContainer span = new WebMarkupContainer("span");
        this.add(new Component[]{span});
        span.add(new Behavior[]{AttributeModifier.replace((String)"colspan", (Serializable)((Object)String.valueOf(this.getTable().getColumns().size())))});
        final EditContext editContext = new EditContext(this.dataProvider.getFilterOption());
        Form<Void> form = new Form<Void>("form"){

            protected void onSubmit() {
                super.onSubmit();
                editContext.validate(false);
                if (editContext.hasError()) {
                    StringBuffer buffer = new StringBuffer();
                    for (EditContext.EditableProperty property : editContext.getProperties()) {
                        if (property.getError() == null) continue;
                        buffer.append(property.getError());
                        break;
                    }
                    this.getSession().error((Serializable)buffer);
                } else {
                    editContext.update(FilterToolbar.this.dataProvider.getFilterOption());
                    if (AjaxRequestTarget.get() != null) {
                        AjaxRequestTarget.get().add(new Component[]{FilterToolbar.this.getTable()});
                    }
                }
            }
        };
        span.add(new Component[]{form});
        form.add(new Component[]{new EnumEditor("status", (Class)FilterOption.class, editContext.getProperty("status"))});
        form.add(new Component[]{new StringEditor("version", (Class)FilterOption.class, editContext.getProperty("version"))});
        form.add(new Component[]{new DateEditor("fromDate", (Class)FilterOption.class, editContext.getProperty("fromDate"))});
        form.add(new Component[]{new DateEditor("toDate", (Class)FilterOption.class, editContext.getProperty("toDate"))});
        if (this.findParent(GadgetPanel.class) == null) {
            form.add(new Component[]{new SubmitLink("submit")});
            form.add(new Component[]{new Link<Void>("clear"){

                public void onClick() {
                    FilterToolbar.this.dataProvider.setFilterOption(new FilterOption());
                    for (EditContext.EditableProperty property : editContext.getProperties()) {
                        property.setValue(null);
                        property.setError(null);
                    }
                }
            }});
        } else {
            form.add(new Component[]{new AjaxSubmitLink("submit"){

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                }
            }});
            form.add(new Component[]{new AjaxLink<Void>("clear"){

                public void onClick(AjaxRequestTarget target) {
                    FilterToolbar.this.dataProvider.setFilterOption(new FilterOption());
                    for (EditContext.EditableProperty property : editContext.getProperties()) {
                        property.setValue(null);
                        property.setError(null);
                    }
                    target.add(new Component[]{FilterToolbar.this.getTable()});
                }
            }});
        }
    }
}

