/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.configuration;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.WorkspaceBrowser;
import com.pmease.quickbuild.grid.WorkspaceFile;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.component.InternalImage;
import com.pmease.quickbuild.web.component.treetable.TreeDataProvider;
import com.pmease.quickbuild.web.component.treetable.TreeState;
import com.pmease.quickbuild.web.component.treetable.TreeTable;
import com.pmease.quickbuild.web.component.treetable.TreeTableColumn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.resource.FileResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspacePanel
extends Panel {
    private static final Logger logger = LoggerFactory.getLogger(WorkspacePanel.class);
    private Set<String> expandedPaths = new HashSet<String>();
    private GridNode node;
    private TreeTable directoryView;

    public WorkspacePanel(String panelId, final GridNode node) {
        super(panelId);
        String workspaceDir;
        this.node = node;
        WebMarkupContainer container = new WebMarkupContainer("container");
        this.add(new Component[]{container});
        try {
            workspaceDir = node.getWorkspaceDir(Context.getConfiguration().getId());
        }
        catch (Exception e) {
            workspaceDir = null;
            logger.error("Error getting workspace directory", (Throwable)e);
        }
        if (workspaceDir != null) {
            container.add(new Component[]{new Label("location", workspaceDir)});
            Component[] componentArray = new Component[1];
            this.directoryView = new TreeTable("directoryView", new TreeDataProvider(){

                @Override
                public List<Serializable> getChildNodeKeys(Serializable nodeKey) {
                    ArrayList<Serializable> childNodeKeys = new ArrayList<Serializable>();
                    WorkspaceFile file = (WorkspaceFile)nodeKey;
                    List<WorkspaceFile> children = WorkspacePanel.this.getWorkspaceBrowser().getChildren(file);
                    if (children != null) {
                        Collections.sort(children, new Comparator<WorkspaceFile>(){

                            @Override
                            public int compare(WorkspaceFile file1, WorkspaceFile file2) {
                                if (file1.isDirectory()) {
                                    if (file2.isDirectory()) {
                                        return file1.getName().compareTo(file2.getName());
                                    }
                                    return -1;
                                }
                                if (file2.isDirectory()) {
                                    return 1;
                                }
                                return file1.getName().compareTo(file2.getName());
                            }
                        });
                        for (WorkspaceFile child : children) {
                            childNodeKeys.add(child);
                        }
                    }
                    return childNodeKeys;
                }

                @Override
                public Serializable getParentNodeKey(Serializable nodeKey) {
                    return WorkspacePanel.this.getWorkspaceBrowser().getParent((WorkspaceFile)nodeKey);
                }

                @Override
                public List<Serializable> getRootNodeKeys() {
                    return this.getChildNodeKeys(null);
                }

                @Override
                public boolean isExpandable(Serializable nodeKey) {
                    WorkspaceFile file = (WorkspaceFile)nodeKey;
                    return file.isDirectory();
                }
            }, new TreeState(){

                @Override
                public boolean isExpanded(Serializable nodeKey) {
                    return WorkspacePanel.this.expandedPaths.contains(((WorkspaceFile)nodeKey).getPath());
                }

                @Override
                public void setExpanded(Serializable nodeKey, boolean expanded) {
                    String path = ((WorkspaceFile)nodeKey).getPath();
                    if (expanded) {
                        WorkspacePanel.this.expandedPaths.add(path);
                    } else {
                        WorkspacePanel.this.expandedPaths.remove(path);
                    }
                }
            }, new TreeTableColumn(){

                @Override
                public Component newCell(String id, Serializable nodeKey) {
                    return new NodePanel(id, (WorkspaceFile)nodeKey);
                }

                @Override
                public Component newHeader(String id) {
                    Label header = new Label(id, "Name");
                    header.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"font-weight:bold;"))});
                    return header;
                }
            }, new TreeTableColumn[]{new TreeTableColumn(){

                @Override
                public Component newCell(String id, Serializable nodeKey) {
                    WorkspaceFile file = (WorkspaceFile)nodeKey;
                    if (!file.isDirectory()) {
                        return new Label(id, StringUtils.formatByteCount(file.getSize()));
                    }
                    return new Label(id, " ");
                }

                @Override
                public Component newHeader(String id) {
                    Label header = new Label(id, "Size");
                    header.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"font-weight:bold;"))});
                    return header;
                }
            }, new TreeTableColumn(){

                @Override
                public Component newCell(String id, Serializable nodeKey) {
                    WorkspaceFile file = (WorkspaceFile)nodeKey;
                    return new Label(id, DateUtils.formatDateTime(file.getLastModified()));
                }

                @Override
                public Component newHeader(String id) {
                    Label header = new Label(id, "Last Modified");
                    header.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"font-weight:bold;"))});
                    return header;
                }
            }}, false);
            componentArray[0] = this.directoryView;
            container.add(componentArray);
            Component[] componentArray2 = new Component[1];
            Link<Void> link = new Link<Void>("clean"){

                public void onClick() {
                    Configuration configuration = Context.getConfiguration();
                    String workspaceDir = node.getWorkspaceDir(configuration.getId());
                    try {
                        node.cleanDir(workspaceDir);
                        AuditManager.instance.audit(configuration, "Workspace on node '" + node.getAddress() + "' was cleaned up.");
                    }
                    catch (Exception e) {
                        logger.error("Error cleaning up workspace on node '" + node.getAddress() + "'.", (Throwable)e);
                        this.getSession().error((Serializable)((Object)("Failed to clean up workspace '" + workspaceDir + "' on node '" + node.getAddress() + "'. The most probable " + "reason is that some processes are currently accessing " + "the workspace. Please access the server log for more " + "information.")));
                    }
                    WorkspacePanel.this.directoryView.refresh();
                }

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(SecurityHelper.hasPermission(ConfigurationPermission.CLEAN_WORKSPACE.name()));
                }
            };
            componentArray2[0] = link;
            container.add(componentArray2);
            link.add(new Behavior[]{new ConfirmBehavior("Do you really want to clean workspace of current configuration on this node?")});
            container.add(new Component[]{new WebMarkupContainer("errorDetail")});
            container.get("errorDetail").setVisible(false);
        } else {
            container.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"round red window"))});
            container.add(new Component[]{new Label("location", "Error getting workspace directory")});
            container.add(new Component[]{new WebMarkupContainer("clean")});
            container.get("clean").setVisible(false);
            container.add(new Component[]{new WebMarkupContainer("directoryView")});
            container.add(new Component[]{new Label("errorDetail", "The node might be offline or invalid scripts are embedded in workspace setting of the configuration. Please check server log for details.")});
        }
    }

    private WorkspaceBrowser getWorkspaceBrowser() {
        return this.node.getWorkspaceBrowser(Context.getConfiguration());
    }

    private class NodePanel
    extends Fragment {
        public NodePanel(String id, final WorkspaceFile file) {
            super(id, "nodeFrag", (MarkupContainer)WorkspacePanel.this);
            if (file.isDirectory()) {
                if (WorkspacePanel.this.expandedPaths.contains(file.getPath())) {
                    this.add(new Component[]{new InternalImage("icon", "/images/folder-open.gif")});
                } else {
                    this.add(new Component[]{new InternalImage("icon", "/images/folder.gif")});
                }
            } else {
                this.add(new Component[]{new InternalImage("icon", "/images/file.gif")});
            }
            Link<Void> link = new Link<Void>("link"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onClick() {
                    block13: {
                        if (WorkspacePanel.this.node.isServer()) {
                            Configuration configuration = Context.getConfiguration();
                            String absolutePath = WorkspacePanel.this.node.getWorkspaceDir(configuration.getId()) + file.getPath();
                            if (file.isDirectory()) {
                                final java.io.File tempFile = FileUtils.createTempFile("workspace");
                                try {
                                    FileUtils.zip(new java.io.File(absolutePath), tempFile);
                                    FileResourceStream resourceStream = new FileResourceStream(new File(tempFile));
                                    this.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)new ResourceStreamRequestHandler((IResourceStream)resourceStream, file.getName() + ".zip"){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void respond(IRequestCycle requestCycle) {
                                            try {
                                                super.respond(requestCycle);
                                            }
                                            finally {
                                                FileUtils.deleteFile(tempFile);
                                            }
                                        }
                                    });
                                }
                                catch (Exception e) {
                                    FileUtils.deleteFile(tempFile);
                                }
                            } else {
                                FileResourceStream resourceStream = new FileResourceStream(new File(absolutePath));
                                this.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)new ResourceStreamRequestHandler((IResourceStream)resourceStream, file.getName()));
                            }
                        } else {
                            final java.io.File tempFile = FileUtils.createTempFile("workspace");
                            try {
                                Grid buildGrid = Quickbuild.getInstance(Grid.class);
                                Configuration configuration = Context.getConfiguration();
                                String srcPath = WorkspacePanel.this.node.getWorkspaceDir(configuration.getId()) + file.getPath();
                                if (file.isDirectory()) {
                                    java.io.File tempDir = FileUtils.createTempDir("workspace");
                                    try {
                                        buildGrid.transferFiles(WorkspacePanel.this.node, srcPath, "**", buildGrid.getLocalNode(), tempDir.getAbsolutePath(), false, null, null);
                                        FileUtils.zip(tempDir, tempFile);
                                    }
                                    finally {
                                        FileUtils.deleteDir(tempDir);
                                    }
                                    FileResourceStream resourceStream = new FileResourceStream(new File(tempFile));
                                    this.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)new ResourceStreamRequestHandler((IResourceStream)resourceStream, file.getName() + ".zip"){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void respond(IRequestCycle requestCycle) {
                                            try {
                                                super.respond(requestCycle);
                                            }
                                            finally {
                                                FileUtils.deleteFile(tempFile);
                                            }
                                        }
                                    });
                                    break block13;
                                }
                                buildGrid.transferFile(WorkspacePanel.this.node, srcPath, buildGrid.getLocalNode(), tempFile.getAbsolutePath(), null, null);
                                FileResourceStream resourceStream = new FileResourceStream(new File(tempFile));
                                this.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)new ResourceStreamRequestHandler((IResourceStream)resourceStream, file.getName()){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void respond(IRequestCycle requestCycle) {
                                        try {
                                            super.respond(requestCycle);
                                        }
                                        finally {
                                            FileUtils.deleteFile(tempFile);
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                FileUtils.deleteFile(tempFile);
                            }
                        }
                    }
                }

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    if (file.isDirectory() && !SecurityHelper.hasPermission(Context.getConfiguration(), ConfigurationPermission.BATCH_DOWNLOAD_ARTIFACTS.name())) {
                        tag.put("href", (CharSequence)"javascript:void(0);");
                        tag.put("class", (CharSequence)"not-link");
                    }
                }
            };
            this.add(new Component[]{link});
            if (file.isDirectory() && SecurityHelper.hasPermission(Context.getConfiguration(), ConfigurationPermission.BATCH_DOWNLOAD_ARTIFACTS.name())) {
                link.add(new Behavior[]{new ConfirmBehavior("This will download all files recursively under this directory, and may take a considerable time if there are many files. Do you really want to continue?")});
                link.add(new Behavior[]{new AttributeModifier("title", (Serializable)((Object)"Download all files recursively under this directory."))});
            }
            link.add(new Component[]{new Label("name", (IModel)new Model((Serializable)((Object)file.getName())))});
        }
    }
}

