/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.configuration;

import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.pmease.quickbuild.web.component.tabbedpanel.TabbedPanel;
import com.pmease.quickbuild.web.page.configuration.ConfigurationPage;
import com.pmease.quickbuild.web.page.configuration.WorkspacePanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class WorkspacePage
extends ConfigurationPage {
    private String nodeAddress;

    public WorkspacePage(PageParameters params) {
        this(params.get(0).toLong(), params.get(1).toString());
    }

    public WorkspacePage(Long configurationId) {
        this(configurationId, null);
    }

    public WorkspacePage(Long configurationId, String nodeAddress) {
        super(configurationId);
        this.nodeAddress = nodeAddress != null ? nodeAddress.toLowerCase() : null;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        ArrayList<GridNode> nodes = new ArrayList<GridNode>();
        nodes.add(Grid.instance.getLocalNode());
        List<GridNode> agents = AgentManager.instance.getBuildAgents();
        Collections.sort(agents, new Comparator<GridNode>(){

            @Override
            public int compare(GridNode node1, GridNode node2) {
                return node1.getAddress().compareTo(node2.getAddress());
            }
        });
        nodes.addAll(agents);
        for (final GridNode each : nodes) {
            tabs.add(new Tab(each.getAddress()){

                @Override
                public Panel getPanel(String panelId, Map<String, String> panelParams) {
                    return new WorkspacePanel(panelId, each);
                }
            });
        }
        if (this.nodeAddress != null) {
            this.add(new Component[]{new TabbedPanel("tabs", tabs, new String[]{this.nodeAddress})});
        } else {
            this.add(new Component[]{new TabbedPanel("tabs", tabs)});
        }
    }

    @Override
    protected boolean isAuthorized() {
        return SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_WORKSPACE.name());
    }
}

