/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.configuration;

import com.pmease.quickbuild.web.component.DirectoryView;
import com.pmease.quickbuild.web.page.configuration.ConfigurationPage;
import java.io.File;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoragePage
extends ConfigurationPage {
    private static final Logger logger = LoggerFactory.getLogger(StoragePage.class);

    public StoragePage(PageParameters params) {
        this(params.get(0).toLong());
    }

    public StoragePage(Long configurationId) {
        super(configurationId);
    }

    @Override
    protected void onInitialize() {
        File storageDir;
        super.onInitialize();
        WebMarkupContainer container = new WebMarkupContainer("container");
        this.add(new Component[]{container});
        try {
            storageDir = this.getConfiguration().getStorageDir();
        }
        catch (Exception e) {
            logger.error("Error getting storage directory.", (Throwable)e);
            storageDir = null;
        }
        if (storageDir != null) {
            container.add(new Component[]{new Label("location", storageDir.getAbsolutePath())});
            container.add(new Component[]{new DirectoryView("directoryView", (IModel<File>)new Model((Serializable)storageDir))});
            container.add(new Component[]{new WebMarkupContainer("errorDetail")});
            container.get("errorDetail").setVisible(false);
        } else {
            container.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"round red window"))});
            container.add(new Component[]{new Label("location", "Error getting storage directory")});
            container.add(new Component[]{new WebMarkupContainer("directoryView")});
            Label detail = new Label("errorDetail", "This is probably caused by invalid embedded scripts in storage setting of the configuration. Please check server log for more details.");
            container.add(new Component[]{detail});
        }
    }
}

