/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.configuration;

import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.component.BookmarkableTextLink;
import com.pmease.quickbuild.web.component.MultilineText;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import com.pmease.quickbuild.web.page.grid.GridPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class StepWaitReasonsPanel
extends Panel {
    private final List<NodeReasonEntry> reasons = new ArrayList<NodeReasonEntry>();

    public StepWaitReasonsPanel(String id, Map<String, List<String>> waitReasons) {
        super(id);
        for (Map.Entry<String, List<String>> entry : waitReasons.entrySet()) {
            this.reasons.add(new NodeReasonEntry(entry.getKey(), entry.getValue()));
        }
        Collections.sort(this.reasons, new Comparator<NodeReasonEntry>(){

            @Override
            public int compare(NodeReasonEntry o1, NodeReasonEntry o2) {
                return o1.getNodeAddress().compareTo(o2.getNodeAddress());
            }
        });
    }

    protected void onInitialize() {
        super.onInitialize();
        ArrayList<AbstractColumn> columns = new ArrayList<AbstractColumn>();
        columns.add(new AbstractColumn<NodeReasonEntry>((IModel)new Model((Serializable)((Object)"Node"))){

            public void populateItem(Item<ICellPopulator<NodeReasonEntry>> cellItem, String componentId, IModel<NodeReasonEntry> rowModel) {
                cellItem.add(new Component[]{new BookmarkableTextLink(componentId, ((NodeReasonEntry)rowModel.getObject()).getNodeAddress(), GridPage.class, GridPage.params4(((NodeReasonEntry)rowModel.getObject()).getNodeAddress(), "user_attributes"))});
            }
        });
        columns.add(new AbstractColumn<NodeReasonEntry>((IModel)new Model((Serializable)((Object)"Not Matching Reason"))){

            public void populateItem(Item<ICellPopulator<NodeReasonEntry>> cellItem, String componentId, IModel<NodeReasonEntry> rowModel) {
                cellItem.add(new Component[]{new MultilineText(componentId, StringUtils.join(((NodeReasonEntry)rowModel.getObject()).getReasons(), (String)"\n"))});
            }
        });
        this.add(new Component[]{new AjaxFallbackDefaultDataTable("reasons", columns, (ISortableDataProvider)new DataProvider<NodeReasonEntry>(){

            @Override
            public IModel<NodeReasonEntry> model(NodeReasonEntry object) {
                return new Model((Serializable)object);
            }

            public Iterator<? extends NodeReasonEntry> iterator(int first, int count) {
                return StepWaitReasonsPanel.this.reasons.subList(first, first + count).iterator();
            }

            public int size() {
                return StepWaitReasonsPanel.this.reasons.size();
            }
        }, 25)});
    }

    private static class NodeReasonEntry
    implements Serializable {
        private final String nodeAddress;
        private final List<String> reasons;

        public NodeReasonEntry(String nodeAddress, List<String> reasons) {
            this.nodeAddress = nodeAddress;
            this.reasons = reasons;
        }

        public String getNodeAddress() {
            return this.nodeAddress;
        }

        public List<String> getReasons() {
            return this.reasons;
        }
    }
}

