/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.configuration;

import com.pmease.quickbuild.extensionpoint.StatisticsTabContribution;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.pmease.quickbuild.web.component.tabbedpanel.TabbedPanel;
import com.pmease.quickbuild.web.page.configuration.ConfigurationPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class StatisticsPage
extends ConfigurationPage {
    private String[] tabIds;
    private Map<String, String> panelParams;

    public static PageParameters params4(Long configurationId, String[] tabIds, Map<String, String> panelParams) {
        PageParameters params = new PageParameters();
        params.set(0, (Object)configurationId);
        if (tabIds != null && tabIds.length >= 1) {
            params.set(1, (Object)tabIds[0]);
            if (tabIds.length >= 2) {
                params.set(2, (Object)tabIds[1]);
            }
        }
        if (panelParams != null) {
            for (Map.Entry<String, String> entry : panelParams.entrySet()) {
                params.add(entry.getKey(), (Object)entry.getValue());
            }
        }
        return params;
    }

    public static PageParameters params4(Long configurationId, String[] tabIds) {
        return StatisticsPage.params4(configurationId, tabIds, null);
    }

    public static PageParameters params4(Long configurationId) {
        return StatisticsPage.params4(configurationId, null);
    }

    private static String[] getTabIds(PageParameters params) {
        ArrayList<String> tabIds = new ArrayList<String>();
        for (int i = 1; i < 9; ++i) {
            String value = params.get(i).toString();
            if (value == null) continue;
            tabIds.add(value);
        }
        if (!tabIds.isEmpty()) {
            return tabIds.toArray(new String[tabIds.size()]);
        }
        return null;
    }

    private static Map<String, String> getPanelParams(PageParameters params) {
        HashMap<String, String> panelParams = new HashMap<String, String>();
        for (PageParameters.NamedPair pair : params.getAllNamed()) {
            if (NumberUtils.isNumber((String)pair.getKey())) continue;
            panelParams.put(pair.getKey(), pair.getValue());
        }
        if (!panelParams.isEmpty()) {
            return panelParams;
        }
        return null;
    }

    public StatisticsPage(PageParameters params) {
        this(Long.valueOf(params.get(0).toString()), StatisticsPage.getTabIds(params), StatisticsPage.getPanelParams(params));
    }

    public StatisticsPage(Long configurationId) {
        this(configurationId, null);
    }

    public StatisticsPage(Long configurationId, String[] tabIds) {
        this(configurationId, tabIds, null);
    }

    public StatisticsPage(Long configurationId, String[] tabIds, Map<String, String> panelParams) {
        super(configurationId);
        this.tabIds = tabIds;
        this.panelParams = panelParams;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        ArrayList<StatisticsTabContribution> contributions = new ArrayList<StatisticsTabContribution>();
        for (StatisticsTabContribution contribution : PluginManager.instance.getExtensions(StatisticsTabContribution.class)) {
            contributions.add(contribution);
        }
        Collections.sort(contributions, new Comparator<StatisticsTabContribution>(){

            @Override
            public int compare(StatisticsTabContribution contrib1, StatisticsTabContribution contrib2) {
                return contrib1.getOrder() - contrib2.getOrder();
            }
        });
        for (StatisticsTabContribution contrib : contributions) {
            List<Tab> contribTabs = contrib.getTabs();
            if (contribTabs == null) continue;
            tabs.addAll(contribTabs);
        }
        this.add(new Component[]{new TabbedPanel("statsTab", tabs, this.tabIds, this.panelParams){

            @Override
            protected WebMarkupContainer newTabLink(String linkId, String[] ids) {
                PageParameters params = new PageParameters();
                params.set(0, (Object)StatisticsPage.this.getConfigurationId());
                for (int i = 1; i <= ids.length; ++i) {
                    params.set(i, (Object)ids[i - 1]);
                }
                return new BookmarkablePageLink(linkId, StatisticsPage.class, params);
            }
        }});
    }
}

