/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.configuration;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.RequestResult;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.extensionpoint.ConfigurationTabContribution;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.WordUtils;
import com.pmease.quickbuild.variable.VariableBeanHelper;
import com.pmease.quickbuild.web.ContextAware;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.behavior.menu.SettingMenuBehavior;
import com.pmease.quickbuild.web.component.configuration.ConfigurationChooser;
import com.pmease.quickbuild.web.component.configuration.ConfigurationStatusPanel;
import com.pmease.quickbuild.web.component.tabbedpage.DefaultTabItem;
import com.pmease.quickbuild.web.component.tabbedpage.Tab;
import com.pmease.quickbuild.web.component.tabbedpage.TabbedPage;
import com.pmease.quickbuild.web.component.treetable.TreeState;
import com.pmease.quickbuild.web.page.BuildsTabState;
import com.pmease.quickbuild.web.page.MainPage;
import com.pmease.quickbuild.web.page.PageBack;
import com.pmease.quickbuild.web.page.build.BuildPage;
import com.pmease.quickbuild.web.page.build.HistoryBuildsPage;
import com.pmease.quickbuild.web.page.configuration.AuditLogPage;
import com.pmease.quickbuild.web.page.configuration.BuildOptionEdit;
import com.pmease.quickbuild.web.page.configuration.ChildrenPage;
import com.pmease.quickbuild.web.page.configuration.ConfigurationOverview;
import com.pmease.quickbuild.web.page.configuration.StatisticsPage;
import com.pmease.quickbuild.web.page.configuration.StoragePage;
import com.pmease.quickbuild.web.page.configuration.WorkspacePage;
import com.pmease.quickbuild.web.page.configuration.pipeline.PipelinePage;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurationPage
extends MainPage
implements ContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationPage.class);
    private Long configurationId;
    private IModel<Configuration> configurationModel;
    private BuildsTabState buildsTabState;

    @Override
    protected boolean isAuthorized() {
        return SecurityHelper.hasPermission();
    }

    protected ConfigurationPage(final Long configurationId) {
        this.configurationId = configurationId;
        this.configurationModel = new LoadableDetachableModel<Configuration>(){

            protected Configuration load() {
                return (Configuration)ConfigurationManager.instance.load(configurationId);
            }
        };
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new ListView("configurations", (IModel)new LoadableDetachableModel(){

            protected Object load() {
                ArrayList<Configuration> parents = new ArrayList<Configuration>();
                for (Configuration current = ConfigurationPage.this.getConfiguration(); current != null; current = current.getParent()) {
                    parents.add(current);
                }
                Collections.reverse(parents);
                return parents;
            }
        }){

            protected void populateItem(final ListItem item) {
                Configuration configuration = (Configuration)item.getModelObject();
                Link<?> link = ConfigurationPage.this.newSwitchLink("link", configuration.getId());
                link.setEnabled(SecurityHelper.hasPermission(configuration) && !ConfigurationPage.this.getConfiguration().getId().equals(configuration.getId()));
                link.add(new Component[]{new Label("name", configuration.getName())});
                item.add(new Component[]{link});
                item.add(new Component[]{new WebMarkupContainer("childrenSelectorTrigger"){

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(CacheManager.instance.hasChildren(((Configuration)item.getModelObject()).getId()));
                    }
                }.add(new Behavior[]{new PopupBehavior(){

                    @Override
                    protected Component getPopup(String componentId) {
                        return new ConfigurationChooser(componentId, ((Configuration)item.getModelObject()).getId(), false, new TreeState(){

                            @Override
                            public boolean isExpanded(Serializable nodeKey) {
                                return WebSession.get().getConfigurationChooserState().isExpanded(nodeKey);
                            }

                            @Override
                            public void setExpanded(Serializable nodeKey, boolean expanded) {
                                WebSession.get().getConfigurationChooserState().setExpanded(nodeKey, expanded);
                            }
                        }){

                            @Override
                            protected boolean isRevealLinkVisible() {
                                return true;
                            }

                            @Override
                            protected WebMarkupContainer newSelectLink(String id, Configuration configuration) {
                                return ConfigurationPage.this.newSwitchLink(id, configuration.getId());
                            }
                        };
                    }
                }.hoverMode(true)})});
            }
        }});
        this.add(new Component[]{new ConfigurationStatusPanel("configurationStatus", this.getConfigurationId())});
        this.add(new Component[]{new Link<Void>("run"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(!(this.getPage() instanceof BuildOptionEdit) && !ConfigurationPage.this.getConfiguration().isDisabled() && SecurityHelper.hasPermission(ConfigurationPermission.RUN_BUILD.name()));
            }

            public void onClick() {
                if (VariableBeanHelper.hasPromptFields(ConfigurationPage.this.getConfiguration().getVariablePromptBeanClass())) {
                    this.setResponsePage((Page)new BuildOptionEdit(ConfigurationPage.this.getConfigurationId(), new PageBack(){

                        @Override
                        public void go() {
                            if (ConfigurationPage.this instanceof BuildOptionEdit) {
                                this.setResponsePage(ConfigurationOverview.class, ConfigurationPage.params4(ConfigurationPage.this.getConfigurationId()));
                            } else {
                                this.setResponsePage(ConfigurationPage.this.getClass(), ConfigurationPage.this.getPageParameters());
                            }
                        }
                    }));
                } else {
                    BuildRequest request = new BuildRequest();
                    request.setConfigurationId(ConfigurationPage.this.getConfiguration().getId());
                    request.setRespectBuildCondition(false);
                    RequestResult result = BuildEngine.instance.requestBuild(Context.getUser(), false, request);
                    if (result.getRequestId() != null) {
                        if (ConfigurationPage.this.getConfiguration().findAuditBuildRequest().booleanValue()) {
                            AuditManager.instance.audit(ConfigurationPage.this.getConfiguration(), "Build was requested.");
                        }
                        this.getSession().info((Serializable)((Object)"Build request has been queued."));
                    } else {
                        this.getSession().warn((Serializable)((Object)result.getRejectReason()));
                    }
                    this.setResponsePage(ConfigurationOverview.class, ConfigurationOverview.params4(ConfigurationPage.this.getConfigurationId()));
                }
            }
        }});
        this.add(new Component[]{new Link("addConfiguration"){

            public void onClick() {
                Configuration configuration = new Configuration(true);
                configuration.setParent(ConfigurationPage.this.getConfiguration());
                this.setResponsePage((Page)new ConfigurationSettingPage(configuration, null, new PageBack(){

                    @Override
                    public void go() {
                        this.setResponsePage(ConfigurationPage.this.getClass(), ConfigurationPage.this.getPageParameters(ConfigurationPage.this.getConfigurationId()));
                    }
                }));
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.hasPermission(ConfigurationPermission.ADD_CHILDREN.name()));
            }
        }});
        Component[] componentArray = new Component[1];
        Link<Void> link = new Link<Void>("deleteConfiguration"){

            public void onClick() {
                Configuration configuration = ConfigurationPage.this.getConfiguration();
                Configuration parent = configuration.getParent();
                if (parent != null) {
                    Configuration found = null;
                    for (BuildRequest request : BuildEngine.instance.getBuildRequests(null)) {
                        Configuration requestConfiguration = (Configuration)ConfigurationManager.instance.load(request.getConfigurationId());
                        if (requestConfiguration.getInheritDistance(configuration) == -1) continue;
                        found = requestConfiguration;
                        break;
                    }
                    if (found != null) {
                        this.getSession().warn((Serializable)((Object)("There are waiting or processing build requests for configuration '" + found + "'. Please cancel them first.")));
                    } else {
                        ConfigurationManager.instance.delete(configuration);
                        AuditManager.instance.audit(configuration, "Configuration was deleted.");
                    }
                    PageParameters params = ConfigurationPage.this.getPageParameters(parent.getId());
                    if (params != null) {
                        this.setResponsePage(ConfigurationPage.this.getClass(), params);
                    } else {
                        this.setResponsePage(ConfigurationOverview.class, ConfigurationPage.params4(parent.getId()));
                    }
                }
            }

            protected void onConfigure() {
                super.onConfigure();
                if (ConfigurationPage.this.getConfiguration().isRoot()) {
                    this.setVisible(false);
                } else {
                    this.setVisible(SecurityHelper.hasPermission(ConfigurationPage.this.getConfiguration().getParent(), ConfigurationPermission.DELETE_CHILDREN.name()));
                }
            }
        };
        componentArray[0] = link;
        this.add(componentArray);
        link.add(new Behavior[]{new ConfirmBehavior("This will delete configuration '" + this.getConfiguration().getPathName() + "' and all its descendent configurations, including all build artifacts " + "and reports under them. Do you really want to continue?")});
        this.add(new Component[]{new WebMarkupContainer("copyConfiguration").add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                return new ConfigurationChooser(componentId, Configuration.ROOT_ID, true, new TreeState(){

                    @Override
                    public boolean isExpanded(Serializable nodeKey) {
                        return WebSession.get().getConfigurationChooserState().isExpanded(nodeKey);
                    }

                    @Override
                    public void setExpanded(Serializable nodeKey, boolean expanded) {
                        WebSession.get().getConfigurationChooserState().setExpanded(nodeKey, expanded);
                    }
                }){

                    @Override
                    protected WebMarkupContainer newSelectLink(String id, final Configuration selected) {
                        return new Link<Void>(id){

                            public void onClick() {
                                if (SecurityHelper.hasPermission(selected, ConfigurationPermission.ADD_CHILDREN.name())) {
                                    Configuration copy = ConfigurationManager.instance.copyAsNew(Context.getConfiguration(), false);
                                    copy.setParent(selected);
                                    this.setResponsePage((Page)new ConfigurationSettingPage(copy, Context.getConfiguration().getId(), new PageBack(){

                                        @Override
                                        public void go() {
                                            this.setResponsePage(ConfigurationPage.this.getClass(), ConfigurationPage.this.getPageParameters(ConfigurationPage.this.getConfigurationId()));
                                        }
                                    }));
                                } else {
                                    Session.get().error((Serializable)((Object)"You do not have permission to add children under this configuration"));
                                }
                            }
                        };
                    }
                };
            }
        }})});
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        if (SecurityHelper.hasPermission()) {
            tabs.add(new Tab("Overview", ConfigurationOverview.class, ConfigurationOverview.class));
            tabs.add(new Tab("Builds", BuildPage.class, HistoryBuildsPage.class));
        }
        if (SecurityHelper.hasPermission()) {
            tabs.add(new Tab("Pipelines", PipelinePage.class));
        }
        if (SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_STATISTICS.name())) {
            tabs.add(new Tab("Statistics", StatisticsPage.class));
        }
        if (SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_WORKSPACE.name())) {
            tabs.add(new Tab("Workspace", WorkspacePage.class));
        }
        if (SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_STORAGE.name())) {
            tabs.add(new Tab("Storage", StoragePage.class));
        }
        if (SecurityHelper.hasPermission()) {
            tabs.add(new Tab("Children", ChildrenPage.class));
        }
        if (SecurityHelper.hasPermission(ConfigurationPermission.VIEW_AUDIT_LOG.name())) {
            tabs.add(new Tab("Audit Log", AuditLogPage.class));
        }
        ArrayList<ConfigurationTabContribution> contributions = new ArrayList<ConfigurationTabContribution>();
        for (ConfigurationTabContribution contribution : PluginManager.instance.getExtensions(ConfigurationTabContribution.class)) {
            contributions.add(contribution);
        }
        Collections.sort(contributions, new Comparator<ConfigurationTabContribution>(){

            @Override
            public int compare(ConfigurationTabContribution contribution1, ConfigurationTabContribution contribution2) {
                return contribution1.getOrder() - contribution2.getOrder();
            }
        });
        for (ConfigurationTabContribution contribution : contributions) {
            tabs.addAll(contribution.getTabs());
        }
        this.add(new Component[]{new TabbedPage("configurationTab", tabs){

            @Override
            protected void renderTabItem(ListItem item, String componentId, Tab tab) {
                if (tab.getTitle().equals("Builds")) {
                    BookmarkablePageLink tabLink;
                    Fragment fragment = new Fragment(componentId, "buildsTabFrag", (MarkupContainer)ConfigurationPage.this);
                    BuildsTabState state = ConfigurationPage.this.getBuildsTabState();
                    Long buildId = state.getBuildId();
                    if (buildId != null) {
                        tabLink = new BookmarkablePageLink("link", BuildPage.class, BuildPage.params4(buildId));
                    } else {
                        String allWhich = state.getAllWhich();
                        if (allWhich != null) {
                            if (allWhich.length() == 0) {
                                tabLink = new BookmarkablePageLink("link", HistoryBuildsPage.class, HistoryBuildsPage.params4(ConfigurationPage.this.getConfigurationId()));
                            } else {
                                PageParameters params = HistoryBuildsPage.params4(ConfigurationPage.this.getConfigurationId(), Build.Status.valueOf(allWhich.toUpperCase()));
                                tabLink = new BookmarkablePageLink("link", HistoryBuildsPage.class, params);
                            }
                        } else {
                            tabLink = new BookmarkablePageLink("link", BuildPage.class, BuildPage.params4(ConfigurationPage.this.getConfigurationId(), state.getBuildIdOrVersion()));
                        }
                    }
                    tabLink.add(new Component[]{new Label("title", (IModel)new AbstractReadOnlyModel(){

                        public Object getObject() {
                            BuildsTabState state = ConfigurationPage.this.getBuildsTabState();
                            Long buildId = state.getBuildId();
                            if (buildId != null) {
                                return "Build (id:" + buildId + ")";
                            }
                            String latestWhich = state.getLatestWhich();
                            if (latestWhich != null) {
                                return WordUtils.capitalizeFully((String)("latest " + latestWhich)) + " Build";
                            }
                            String allWhich = state.getAllWhich();
                            if (allWhich != null) {
                                return WordUtils.capitalizeFully((String)("all " + allWhich)) + " Builds";
                            }
                            return "Build (version:" + state.getBuildIdOrVersion() + ")";
                        }
                    })});
                    tabLink.setOutputMarkupId(true);
                    fragment.add(new Component[]{tabLink});
                    fragment.add(new Component[]{new WebMarkupContainer("chooserTrigger").add(new Behavior[]{new PopupBehavior(){

                        @Override
                        protected Component getPopup(String componentId) {
                            Fragment fragment = new Fragment(componentId, "buildChooserFrag", (MarkupContainer)ConfigurationPage.this);
                            fragment.add(new Component[]{new BookmarkablePageLink("latest", BuildPage.class, BuildPage.params4(ConfigurationPage.this.getConfigurationId(), "latest"))});
                            fragment.add(new Component[]{new BookmarkablePageLink("latestFinished", BuildPage.class, BuildPage.params4(ConfigurationPage.this.getConfigurationId(), "latest_finished"))});
                            fragment.add(new Component[]{new ListView("latestStatusChoices", Arrays.asList(Build.Status.values())){

                                protected void populateItem(ListItem item) {
                                    Build.Status status = (Build.Status)((Object)item.getModelObject());
                                    BookmarkablePageLink link = new BookmarkablePageLink("link", BuildPage.class, BuildPage.params4(ConfigurationPage.this.getConfigurationId(), Build.version4latest(status)));
                                    link.add(new Component[]{new Label("label", WordUtils.capitalize((String)"latest") + " " + WordUtils.capitalize((String)status.name().toLowerCase()) + " Build")});
                                    item.add(new Component[]{link});
                                }
                            }});
                            fragment.add(new Component[]{new BookmarkablePageLink("all", HistoryBuildsPage.class, HistoryBuildsPage.params4(ConfigurationPage.this.getConfigurationId(), null))});
                            fragment.add(new Component[]{new ListView("allStatusChoices", Arrays.asList(Build.Status.values())){

                                protected void populateItem(ListItem item) {
                                    Build.Status status = (Build.Status)((Object)item.getModelObject());
                                    BookmarkablePageLink link = new BookmarkablePageLink("link", HistoryBuildsPage.class, HistoryBuildsPage.params4(ConfigurationPage.this.getConfigurationId(), status));
                                    link.add(new Component[]{new Label("label", WordUtils.capitalize((String)("all " + status.name().toLowerCase())) + " Builds")});
                                    item.add(new Component[]{link});
                                }
                            }});
                            return fragment;
                        }
                    }.hoverMode(true).alignment(new PopupBehavior.Alignment(tabLink.getMarkupId()))})});
                    item.add(new Component[]{fragment});
                } else if (tab.getTitle().equals("Workspace")) {
                    Fragment fragment = new Fragment(componentId, "workspaceTabFrag", (MarkupContainer)ConfigurationPage.this);
                    BookmarkablePageLink tabLink = new BookmarkablePageLink("link", WorkspacePage.class, ConfigurationPage.params4(ConfigurationPage.this.getConfigurationId()));
                    if (SecurityHelper.hasPermission(ConfigurationPermission.CLEAN_WORKSPACE.name())) {
                        item.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"padding-right:21px;"))});
                    } else {
                        tabLink.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"padding-right:12px;"))});
                    }
                    fragment.add(new Component[]{tabLink});
                    tabLink.add(new Component[]{new Label("title", tab.getTitle())});
                    Component[] componentArray = new Component[1];
                    Link<Void> link = new Link<Void>("clean"){

                        public void onClick() {
                            boolean errorFound = false;
                            for (GridNode node : Grid.instance.getAllNodes()) {
                                String workspaceDir = node.getWorkspaceDir(ConfigurationPage.this.getConfiguration().getId());
                                try {
                                    node.cleanDir(workspaceDir);
                                }
                                catch (Exception e) {
                                    logger.error("Error cleaning up workspace on node '" + node.getAddress() + "'.", (Throwable)e);
                                    errorFound = true;
                                    this.getSession().error((Serializable)((Object)("Failed to clean up workspace '" + workspaceDir + "' on node '" + node.getAddress() + "'. The most probable " + "reason is that some processes are currently accessing " + "the workspace. Check server log for details.")));
                                }
                            }
                            AuditManager.instance.audit(ConfigurationPage.this.getConfiguration(), "Workspaces on all nodes were cleaned up.");
                            if (this.getPage() instanceof WorkspacePage) {
                                this.setResponsePage(WorkspacePage.class, ConfigurationPage.params4(ConfigurationPage.this.getConfigurationId()));
                            }
                            if (!errorFound) {
                                this.getSession().info((Serializable)((Object)"Workspaces on all active nodes have been cleaned up."));
                            }
                        }

                        protected void onConfigure() {
                            super.onConfigure();
                            this.setVisible(SecurityHelper.hasPermission(ConfigurationPermission.CLEAN_WORKSPACE.name()));
                        }
                    };
                    componentArray[0] = link;
                    fragment.add(componentArray);
                    link.add(new Behavior[]{new ConfirmBehavior("Do you really want to clean workspaces on all active nodes for current configuration?")});
                    item.add(new Component[]{fragment});
                } else {
                    item.add(new Component[]{new DefaultTabItem(componentId, tab){

                        protected Link newLink(String linkId, Class<? extends Page> pageClass) {
                            PageParameters params = new PageParameters();
                            params.set(0, (Object)ConfigurationPage.this.getConfigurationId());
                            return new BookmarkablePageLink(linkId, pageClass, params);
                        }
                    }});
                }
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("settingMenuTrigger"){

            protected void onConfigure() {
                super.onConfigure();
                if (!SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_SETTINGS.name())) {
                    this.setVisible(false);
                } else {
                    this.setVisible(true);
                }
            }
        }.add(new Behavior[]{new SettingMenuBehavior(this.getConfigurationId()).hoverMode(true)})});
    }

    public Long getConfigurationId() {
        return this.configurationId;
    }

    public Configuration getConfiguration() {
        return (Configuration)this.configurationModel.getObject();
    }

    @Override
    public Build getContext() {
        Build context = new Build();
        context.setConfiguration(this.getConfiguration());
        return context;
    }

    public static PageParameters params4(Long configurationId) {
        PageParameters params = new PageParameters();
        params.set(0, (Object)configurationId);
        return params;
    }

    public BuildsTabState getBuildsTabState() {
        if (this.buildsTabState == null) {
            this.buildsTabState = (BuildsTabState)WebSession.get().getData().get(BuildsTabState.class.getSimpleName());
            if (this.buildsTabState == null) {
                this.buildsTabState = new BuildsTabState(this.getConfigurationId(), "latest");
            }
        }
        if (!this.buildsTabState.getConfigurationId().equals(this.getConfigurationId())) {
            this.buildsTabState.setConfigurationId(this.getConfigurationId());
            if (this.buildsTabState.getReservedVersion() == null) {
                this.buildsTabState.setBuildIdOrVersion("latest");
            }
        }
        return this.buildsTabState;
    }

    protected void setBuildsTabState(BuildsTabState state) {
        this.buildsTabState = state;
        WebSession.get().getData().put(BuildsTabState.class.getSimpleName(), state);
    }

    public PageParameters getPageParameters() {
        return this.getPageParameters(this.configurationId);
    }

    protected PageParameters getPageParameters(Long configurationId) {
        return ConfigurationPage.params4(configurationId);
    }

    public Link<?> newSwitchLink(String id, Long configurationId) {
        PageParameters params = this.getPageParameters(configurationId);
        if (params != null) {
            return new BookmarkablePageLink(id, this.getClass(), params);
        }
        return new BookmarkablePageLink(id, ConfigurationOverview.class, ConfigurationPage.params4(configurationId));
    }

    @Override
    protected int getAjaxRefreshInterval() {
        return CacheManager.instance.getSystemSetting().getAutoRefreshInterval() * 1000;
    }

    @Override
    protected void onDetach() {
        if (this.configurationModel != null) {
            this.configurationModel.detach();
        }
        super.onDetach();
    }

    @Override
    public String getPageTitle() {
        return "QuickBuild - " + this.getConfiguration().getPathName();
    }
}

